/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.DataConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.LabelType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of DATA_CONFIG_TO_LABEL_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     DATA_CRAWLING_CONFIG, LABEL_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     dataCrawlingConfig, labelType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToLabelTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToLabelTypeMappingDbm getMyDBMeta() {
        return DataConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public DataConfigToLabelTypeMapping newMyEntity() {
        return new DataConfigToLabelTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public DataConfigToLabelTypeMappingCB newMyConditionBean() {
        return new DataConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToLabelTypeMappingCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(DataConfigToLabelTypeMappingCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(DataConfigToLabelTypeMappingCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;DataConfigToLabelTypeMapping&gt;() {
     *     public void handle(DataConfigToLabelTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<DataConfigToLabelTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> void doSelectCursor(
            DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToLabelTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (dataConfigToLabelTypeMapping != null) {
     *     ... = dataConfigToLabelTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectEntity(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectEntity(cb, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectEntity(
            final DataConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = dataConfigToLabelTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final DataConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private DataConfigToLabelTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;DataConfigToLabelTypeMapping&gt; dataConfigToLabelTypeMappingList = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping : dataConfigToLabelTypeMappingList) {
     *     ... = dataConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<DataConfigToLabelTypeMapping> selectList(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectList(cb, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ListResultBean<ENTITY> doSelectList(
            DataConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;DataConfigToLabelTypeMapping&gt; page = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping : page) {
     *     ... = dataConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<DataConfigToLabelTypeMapping> selectPage(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectPage(cb, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            DataConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public int callbackSelectCount(
                            DataConfigToLabelTypeMappingCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(DataConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<DataConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends DataConfigToLabelTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToLabelTypeMappingList The list of dataConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToLabelTypeMappingList,
                new InternalPulloutCallback<DataConfigToLabelTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig getFr(
                            DataConfigToLabelTypeMapping e) {
                        return e.getDataCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param dataConfigToLabelTypeMappingList The list of dataConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToLabelTypeMappingList,
                new InternalPulloutCallback<DataConfigToLabelTypeMapping, LabelType>() {
                    public LabelType getFr(DataConfigToLabelTypeMapping e) {
                        return e.getLabelType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(LabelType e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataConfigToLabelTypeMapping.setFoo...(value);
     * dataConfigToLabelTypeMapping.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.set...;</span>
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">insert</span>(dataConfigToLabelTypeMapping);
     * ... = dataConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        doInsert(dataConfigToLabelTypeMapping, null);
    }

    protected void doInsert(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMapping",
                dataConfigToLabelTypeMapping);
        prepareInsertOption(option);
        delegateInsert(dataConfigToLabelTypeMapping, option);
    }

    protected void prepareInsertOption(
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * dataConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">update</span>(dataConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        doUpdate(dataConfigToLabelTypeMapping, null);
    }

    protected void doUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            final UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMapping",
                dataConfigToLabelTypeMapping);
        prepareUpdateOption(option);
        helpUpdateInternally(dataConfigToLabelTypeMapping,
                new InternalUpdateCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected DataConfigToLabelTypeMappingCB createCBForVaryingUpdate() {
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected DataConfigToLabelTypeMappingCB createCBForSpecifiedUpdate() {
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    @Override
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        doModify(entity, option);
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param dataConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        doInesrtOrUpdate(dataConfigToLabelTypeMapping, null, null);
    }

    protected void doInesrtOrUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            final InsertOption<DataConfigToLabelTypeMappingCB> insertOption,
            final UpdateOption<DataConfigToLabelTypeMappingCB> updateOption) {
        helpInsertOrUpdateInternally(
                dataConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToLabelTypeMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        doUpdate(entity, updateOption);
                    }

                    public DataConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    @Override
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        doCreateOrModify(entity, insertOption, updateOption);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * dataConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">delete</span>(dataConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        doDelete(dataConfigToLabelTypeMapping, null);
    }

    protected void doDelete(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            final DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMapping",
                dataConfigToLabelTypeMapping);
        prepareDeleteOption(option);
        helpDeleteInternally(dataConfigToLabelTypeMapping,
                new InternalDeleteCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(
            DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    @Override
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        doRemove(entity, option);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return doBatchInsert(dataConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchInsert(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        prepareInsertOption(option);
        return delegateBatchInsert(dataConfigToLabelTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return doBatchUpdate(dataConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchUpdate(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(dataConfigToLabelTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            SpecifyQuery<DataConfigToLabelTypeMappingCB> updateColumnSpec) {
        return doBatchUpdate(dataConfigToLabelTypeMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        return doLumpModify(ls, option);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return doBatchDelete(dataConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchDelete(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        prepareDeleteOption(option);
        return delegateBatchDelete(dataConfigToLabelTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    @Override
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        return doLumpRemove(ls, option);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;dataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB&gt;() {
     *     public ConditionBean setup(dataConfigToLabelTypeMapping entity, DataConfigToLabelTypeMappingCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB> setupper,
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        DataConfigToLabelTypeMapping entity = new DataConfigToLabelTypeMapping();
        DataConfigToLabelTypeMappingCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected DataConfigToLabelTypeMappingCB createCBForQueryInsert() {
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setPK...(value);</span>
     * dataConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setVersionNo(value);</span>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(dataConfigToLabelTypeMapping, cb);
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DataConfigToLabelTypeMappingCB cb) {
        return doQueryUpdate(dataConfigToLabelTypeMapping, cb, null);
    }

    protected int doQueryUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DataConfigToLabelTypeMappingCB cb,
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("dataConfigToLabelTypeMapping",
                dataConfigToLabelTypeMapping);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(dataConfigToLabelTypeMapping, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity),
                    (DataConfigToLabelTypeMappingCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (DataConfigToLabelTypeMappingCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(dataConfigToLabelTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(DataConfigToLabelTypeMappingCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(DataConfigToLabelTypeMappingCB cb,
            DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((DataConfigToLabelTypeMappingCB) cb);
        } else {
            return varyingQueryDelete((DataConfigToLabelTypeMappingCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataConfigToLabelTypeMapping.setFoo...(value);
     * dataConfigToLabelTypeMapping.setBar...(value);
     * InsertOption<DataConfigToLabelTypeMappingCB> option = new InsertOption<DataConfigToLabelTypeMappingCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingInsert</span>(dataConfigToLabelTypeMapping, option);
     * ... = dataConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(dataConfigToLabelTypeMapping, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * dataConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *         public void specify(DataConfigToLabelTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(dataConfigToLabelTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(dataConfigToLabelTypeMapping, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param dataConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            InsertOption<DataConfigToLabelTypeMappingCB> insertOption,
            UpdateOption<DataConfigToLabelTypeMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(dataConfigToLabelTypeMapping, insertOption,
                updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param dataConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(dataConfigToLabelTypeMapping, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(dataConfigToLabelTypeMappingList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(dataConfigToLabelTypeMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList,
            DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(dataConfigToLabelTypeMappingList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB> setupper,
            InsertOption<DataConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setPK...(value);</span>
     * dataConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setVersionNo(value);</span>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void specify(DataConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(dataConfigToLabelTypeMapping, cb, option);
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DataConfigToLabelTypeMappingCB cb,
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(dataConfigToLabelTypeMapping, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(DataConfigToLabelTypeMappingCB cb,
            DeleteOption<DataConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<DataConfigToLabelTypeMappingBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(DataConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(DataConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> void delegateSelectCursor(
            DataConfigToLabelTypeMappingCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> List<ENTITY> delegateSelectList(
            DataConfigToLabelTypeMappingCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToLabelTypeMapping e,
            InsertOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(DataConfigToLabelTypeMapping e,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return delegateUpdateNonstrict(e, op);
    }

    protected int delegateUpdateNonstrict(DataConfigToLabelTypeMapping e,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(DataConfigToLabelTypeMapping e,
            DeleteOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return delegateDeleteNonstrict(e, op);
    }

    protected int delegateDeleteNonstrict(DataConfigToLabelTypeMapping e,
            DeleteOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<DataConfigToLabelTypeMapping> ls,
            InsertOption<DataConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<DataConfigToLabelTypeMapping> ls,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchUpdateNonstrict(ls, op);
    }

    protected int[] delegateBatchUpdateNonstrict(
            List<DataConfigToLabelTypeMapping> ls,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<DataConfigToLabelTypeMapping> ls,
            DeleteOption<DataConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchDeleteNonstrict(ls, op);
    }

    protected int[] delegateBatchDeleteNonstrict(
            List<DataConfigToLabelTypeMapping> ls,
            DeleteOption<DataConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(DataConfigToLabelTypeMapping e,
            DataConfigToLabelTypeMappingCB inCB, ConditionBean resCB,
            InsertOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(DataConfigToLabelTypeMapping e,
            DataConfigToLabelTypeMappingCB cb,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(DataConfigToLabelTypeMappingCB cb,
            DeleteOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected DataConfigToLabelTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                DataConfigToLabelTypeMapping.class);
    }

    protected DataConfigToLabelTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                DataConfigToLabelTypeMappingCB.class);
    }
}
