/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.form.admin;

import java.io.Serializable;

import org.apache.struts.upload.FormFile;
import org.seasar.struts.annotation.Required;

public class DesignForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @Required(target = "upload")
    public FormFile designImageFile;

    public String designImageFileName;

    @Required(target = "edit,editAsUseDefault")
    public String fileName;

    public String content;

    public String getJspFileName() {
        if ("index".equals(fileName)) {
            return "index.jsp";
        } else if ("indexHtmlHead".equals(fileName)) {
            return "indexHtmlHead.jsp";
        } else if ("indexMain".equals(fileName)) {
            return "indexMain.jsp";
        } else if ("search".equals(fileName)) {
            return "search.jsp";
        } else if ("searchHtmlHead".equals(fileName)) {
            return "searchHtmlHead.jsp";
        } else if ("searchHeader".equals(fileName)) {
            return "searchHeader.jsp";
        } else if ("searchFooter".equals(fileName)) {
            return "searchFooter.jsp";
        } else if ("searchResults".equals(fileName)) {
            return "searchResults.jsp";
        } else if ("searchNoResult".equals(fileName)) {
            return "searchNoResult.jsp";
        } else if ("error".equals(fileName)) {
            return "error.jsp";
        } else if ("mobileIndex".equals(fileName)) {
            return "mobile/index.jsp";
        } else if ("mobileIndexHtmlHead".equals(fileName)) {
            return "mobile/indexHtmlHead.jsp";
        } else if ("mobileIndexMain".equals(fileName)) {
            return "mobile/indexMain.jsp";
        } else if ("mobileSearch".equals(fileName)) {
            return "mobile/search.jsp";
        } else if ("mobileSearchHtmlHead".equals(fileName)) {
            return "mobile/searchHtmlHead.jsp";
        } else if ("mobileSearchHeader".equals(fileName)) {
            return "mobile/searchHeader.jsp";
        } else if ("mobileSearchFooter".equals(fileName)) {
            return "mobile/searchFooter.jsp";
        } else if ("mobileSearchResults".equals(fileName)) {
            return "mobile/searchResults.jsp";
        } else if ("mobileSearchNoResult".equals(fileName)) {
            return "mobile/searchNoResult.jsp";
        }
        return null;
    }
}
