/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.cq.DataConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.LabelTypeToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.RoleTypeCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.ciq.RoleTypeCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The base condition-query of ROLE_TYPE.
 * @author DBFlute(AutoGenerator)
 */
public class BsRoleTypeCQ extends AbstractBsRoleTypeCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected RoleTypeCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsRoleTypeCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare InlineView query. <br />
     * {select ... from ... left outer join (select * from ROLE_TYPE) where FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">inline()</span>.setFoo...;
     * </pre>
     * @return The condition-query for InlineView query. (NotNull)
     */
    public RoleTypeCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = createInlineQuery();
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    protected RoleTypeCIQ createInlineQuery() {
        return new RoleTypeCIQ(getReferrerQuery(), getSqlClause(),
                getAliasName(), getNestLevel(), this);
    }

    /**
     * Prepare OnClause query. <br />
     * {select ... from ... left outer join ROLE_TYPE on ... and FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">on()</span>.setFoo...;
     * </pre>
     * @return The condition-query for OnClause query. (NotNull)
     * @throws IllegalConditionBeanOperationException When this condition-query is base query.
     */
    public RoleTypeCIQ on() {
        if (isBaseQuery()) {
            throw new IllegalConditionBeanOperationException(
                    "OnClause for local table is unavailable!");
        }
        RoleTypeCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_ExistsReferrer_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_ExistsReferrer_DataConfigToRoleTypeMappingList() {
        return _id_ExistsReferrer_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsReferrer_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsReferrer_DataConfigToRoleTypeMappingListMap == null) {
            _id_ExistsReferrer_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsReferrer_DataConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsReferrer_DataConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_ExistsReferrer_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_ExistsReferrer_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_ExistsReferrer_FileConfigToRoleTypeMappingList() {
        return _id_ExistsReferrer_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsReferrer_FileConfigToRoleTypeMappingListMap == null) {
            _id_ExistsReferrer_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsReferrer_FileConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsReferrer_FileConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_ExistsReferrer_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, LabelTypeToRoleTypeMappingCQ> _id_ExistsReferrer_LabelTypeToRoleTypeMappingListMap;

    public Map<String, LabelTypeToRoleTypeMappingCQ> getId_ExistsReferrer_LabelTypeToRoleTypeMappingList() {
        return _id_ExistsReferrer_LabelTypeToRoleTypeMappingListMap;
    }

    public String keepId_ExistsReferrer_LabelTypeToRoleTypeMappingList(
            LabelTypeToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsReferrer_LabelTypeToRoleTypeMappingListMap == null) {
            _id_ExistsReferrer_LabelTypeToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsReferrer_LabelTypeToRoleTypeMappingListMap.size() + 1);
        _id_ExistsReferrer_LabelTypeToRoleTypeMappingListMap.put(key, subQuery);
        return "id_ExistsReferrer_LabelTypeToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_ExistsReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_ExistsReferrer_WebConfigToRoleTypeMappingList() {
        return _id_ExistsReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_ExistsReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsReferrer_WebConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsReferrer_WebConfigToRoleTypeMappingListMap.put(key, subQuery);
        return "id_ExistsReferrer_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_NotExistsReferrer_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_NotExistsReferrer_DataConfigToRoleTypeMappingList() {
        return _id_NotExistsReferrer_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsReferrer_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsReferrer_DataConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsReferrer_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsReferrer_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsReferrer_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsReferrer_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_NotExistsReferrer_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_NotExistsReferrer_FileConfigToRoleTypeMappingList() {
        return _id_NotExistsReferrer_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsReferrer_FileConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsReferrer_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsReferrer_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsReferrer_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsReferrer_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, LabelTypeToRoleTypeMappingCQ> _id_NotExistsReferrer_LabelTypeToRoleTypeMappingListMap;

    public Map<String, LabelTypeToRoleTypeMappingCQ> getId_NotExistsReferrer_LabelTypeToRoleTypeMappingList() {
        return _id_NotExistsReferrer_LabelTypeToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsReferrer_LabelTypeToRoleTypeMappingList(
            LabelTypeToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsReferrer_LabelTypeToRoleTypeMappingListMap == null) {
            _id_NotExistsReferrer_LabelTypeToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsReferrer_LabelTypeToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsReferrer_LabelTypeToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsReferrer_LabelTypeToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_NotExistsReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_NotExistsReferrer_WebConfigToRoleTypeMappingList() {
        return _id_NotExistsReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsReferrer_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, LabelTypeToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingListMap;

    public Map<String, LabelTypeToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingList(
            LabelTypeToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_LabelTypeToRoleTypeMappingList."
                + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_InScopeRelation_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_InScopeRelation_DataConfigToRoleTypeMappingList() {
        return _id_InScopeRelation_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeRelation_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeRelation_DataConfigToRoleTypeMappingListMap == null) {
            _id_InScopeRelation_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeRelation_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_InScopeRelation_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeRelation_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_InScopeRelation_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_InScopeRelation_FileConfigToRoleTypeMappingList() {
        return _id_InScopeRelation_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeRelation_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeRelation_FileConfigToRoleTypeMappingListMap == null) {
            _id_InScopeRelation_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeRelation_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_InScopeRelation_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeRelation_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, LabelTypeToRoleTypeMappingCQ> _id_InScopeRelation_LabelTypeToRoleTypeMappingListMap;

    public Map<String, LabelTypeToRoleTypeMappingCQ> getId_InScopeRelation_LabelTypeToRoleTypeMappingList() {
        return _id_InScopeRelation_LabelTypeToRoleTypeMappingListMap;
    }

    public String keepId_InScopeRelation_LabelTypeToRoleTypeMappingList(
            LabelTypeToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeRelation_LabelTypeToRoleTypeMappingListMap == null) {
            _id_InScopeRelation_LabelTypeToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeRelation_LabelTypeToRoleTypeMappingListMap.size() + 1);
        _id_InScopeRelation_LabelTypeToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_InScopeRelation_LabelTypeToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_InScopeRelation_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_InScopeRelation_WebConfigToRoleTypeMappingList() {
        return _id_InScopeRelation_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeRelation_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeRelation_WebConfigToRoleTypeMappingListMap == null) {
            _id_InScopeRelation_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeRelation_WebConfigToRoleTypeMappingListMap.size() + 1);
        _id_InScopeRelation_WebConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_InScopeRelation_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_NotInScopeRelation_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_NotInScopeRelation_DataConfigToRoleTypeMappingList() {
        return _id_NotInScopeRelation_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeRelation_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeRelation_DataConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeRelation_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeRelation_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeRelation_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeRelation_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_NotInScopeRelation_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_NotInScopeRelation_FileConfigToRoleTypeMappingList() {
        return _id_NotInScopeRelation_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeRelation_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeRelation_FileConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeRelation_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeRelation_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeRelation_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeRelation_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, LabelTypeToRoleTypeMappingCQ> _id_NotInScopeRelation_LabelTypeToRoleTypeMappingListMap;

    public Map<String, LabelTypeToRoleTypeMappingCQ> getId_NotInScopeRelation_LabelTypeToRoleTypeMappingList() {
        return _id_NotInScopeRelation_LabelTypeToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeRelation_LabelTypeToRoleTypeMappingList(
            LabelTypeToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeRelation_LabelTypeToRoleTypeMappingListMap == null) {
            _id_NotInScopeRelation_LabelTypeToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeRelation_LabelTypeToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeRelation_LabelTypeToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeRelation_LabelTypeToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_NotInScopeRelation_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_NotInScopeRelation_WebConfigToRoleTypeMappingList() {
        return _id_NotInScopeRelation_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeRelation_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeRelation_WebConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeRelation_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeRelation_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeRelation_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeRelation_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_DataConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameter."
                + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_FileConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter."
                + key;
    }

    protected Map<String, LabelTypeToRoleTypeMappingCQ> _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListMap;

    public Map<String, LabelTypeToRoleTypeMappingCQ> getId_QueryDerivedReferrer_LabelTypeToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_LabelTypeToRoleTypeMappingList(
            LabelTypeToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_LabelTypeToRoleTypeMappingListParameter."
                + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter."
                + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _name;

    public ConditionValue getName() {
        if (_name == null) {
            _name = nCV();
        }
        return _name;
    }

    protected ConditionValue getCValueName() {
        return getName();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_Name_Asc() {
        regOBA("NAME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_Name_Desc() {
        regOBD("NAME");
        return this;
    }

    protected ConditionValue _value;

    public ConditionValue getValue() {
        if (_value == null) {
            _value = nCV();
        }
        return _value;
    }

    protected ConditionValue getCValueValue() {
        return getValue();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_Value_Asc() {
        regOBA("VALUE");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_Value_Desc() {
        regOBD("VALUE");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    /**
     * Add order-by for specified derived column as ascend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] asc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Asc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    /**
     * Add order-by for specified derived column as descend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] desc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Desc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsRoleTypeCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, RoleTypeCQ> _scalarConditionMap;

    public Map<String, RoleTypeCQ> getScalarCondition() {
        return _scalarConditionMap;
    }

    public String keepScalarCondition(RoleTypeCQ subQuery) {
        if (_scalarConditionMap == null) {
            _scalarConditionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarConditionMap.size() + 1);
        _scalarConditionMap.put(key, subQuery);
        return "scalarCondition." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, RoleTypeCQ> _myselfInScopeRelationMap;

    public Map<String, RoleTypeCQ> getMyselfInScopeRelation() {
        return _myselfInScopeRelationMap;
    }

    public String keepMyselfInScopeRelation(RoleTypeCQ subQuery) {
        if (_myselfInScopeRelationMap == null) {
            _myselfInScopeRelationMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeRelationMap.size() + 1);
        _myselfInScopeRelationMap.put(key, subQuery);
        return "myselfInScopeRelation." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xCB() {
        return RoleTypeCB.class.getName();
    }

    protected String xCQ() {
        return RoleTypeCQ.class.getName();
    }

    protected String xMap() {
        return Map.class.getName();
    }
}
