/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.ciq.CrawlingSessionCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The base condition-query of CRAWLING_SESSION.
 * @author DBFlute(AutoGenerator)
 */
public class BsCrawlingSessionCQ extends AbstractBsCrawlingSessionCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected CrawlingSessionCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsCrawlingSessionCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare InlineView query. <br />
     * {select ... from ... left outer join (select * from CRAWLING_SESSION) where FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">inline()</span>.setFoo...;
     * </pre>
     * @return The condition-query for InlineView query. (NotNull)
     */
    public CrawlingSessionCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = createInlineQuery();
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    protected CrawlingSessionCIQ createInlineQuery() {
        return new CrawlingSessionCIQ(getReferrerQuery(), getSqlClause(),
                getAliasName(), getNestLevel(), this);
    }

    /**
     * Prepare OnClause query. <br />
     * {select ... from ... left outer join CRAWLING_SESSION on ... and FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">on()</span>.setFoo...;
     * </pre>
     * @return The condition-query for OnClause query. (NotNull)
     * @throws IllegalConditionBeanOperationException When this condition-query is base query.
     */
    public CrawlingSessionCIQ on() {
        if (isBaseQuery()) {
            throw new IllegalConditionBeanOperationException(
                    "OnClause for local table is unavailable!");
        }
        CrawlingSessionCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_ExistsReferrer_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_ExistsReferrer_CrawlingSessionInfoList() {
        return _id_ExistsReferrer_CrawlingSessionInfoListMap;
    }

    public String keepId_ExistsReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_ExistsReferrer_CrawlingSessionInfoListMap == null) {
            _id_ExistsReferrer_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsReferrer_CrawlingSessionInfoListMap.size() + 1);
        _id_ExistsReferrer_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_ExistsReferrer_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_NotExistsReferrer_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_NotExistsReferrer_CrawlingSessionInfoList() {
        return _id_NotExistsReferrer_CrawlingSessionInfoListMap;
    }

    public String keepId_NotExistsReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_NotExistsReferrer_CrawlingSessionInfoListMap == null) {
            _id_NotExistsReferrer_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsReferrer_CrawlingSessionInfoListMap.size() + 1);
        _id_NotExistsReferrer_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_NotExistsReferrer_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_SpecifyDerivedReferrer_CrawlingSessionInfoList() {
        return _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap;
    }

    public String keepId_SpecifyDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap == null) {
            _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap.size() + 1);
        _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap
                .put(key, subQuery);
        return "id_SpecifyDerivedReferrer_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_InScopeRelation_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_InScopeRelation_CrawlingSessionInfoList() {
        return _id_InScopeRelation_CrawlingSessionInfoListMap;
    }

    public String keepId_InScopeRelation_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_InScopeRelation_CrawlingSessionInfoListMap == null) {
            _id_InScopeRelation_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeRelation_CrawlingSessionInfoListMap.size() + 1);
        _id_InScopeRelation_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_InScopeRelation_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_NotInScopeRelation_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_NotInScopeRelation_CrawlingSessionInfoList() {
        return _id_NotInScopeRelation_CrawlingSessionInfoListMap;
    }

    public String keepId_NotInScopeRelation_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_NotInScopeRelation_CrawlingSessionInfoListMap == null) {
            _id_NotInScopeRelation_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeRelation_CrawlingSessionInfoListMap.size() + 1);
        _id_NotInScopeRelation_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_NotInScopeRelation_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_QueryDerivedReferrer_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_QueryDerivedReferrer_CrawlingSessionInfoList() {
        return _id_QueryDerivedReferrer_CrawlingSessionInfoListMap;
    }

    public String keepId_QueryDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_QueryDerivedReferrer_CrawlingSessionInfoListMap == null) {
            _id_QueryDerivedReferrer_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_CrawlingSessionInfoListMap.size() + 1);
        _id_QueryDerivedReferrer_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_QueryDerivedReferrer_CrawlingSessionInfoList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_CrawlingSessionInfoListParameter() {
        return _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_CrawlingSessionInfoListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap == null) {
            _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap.put(key,
                parameterValue);
        return "id_QueryDerivedReferrer_CrawlingSessionInfoListParameter."
                + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _sessionId;

    public ConditionValue getSessionId() {
        if (_sessionId == null) {
            _sessionId = nCV();
        }
        return _sessionId;
    }

    protected ConditionValue getCValueSessionId() {
        return getSessionId();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addOrderBy_SessionId_Asc() {
        regOBA("SESSION_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addOrderBy_SessionId_Desc() {
        regOBD("SESSION_ID");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    /**
     * Add order-by for specified derived column as ascend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] asc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Asc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    /**
     * Add order-by for specified derived column as descend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] desc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Desc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsCrawlingSessionCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, CrawlingSessionCQ> _scalarConditionMap;

    public Map<String, CrawlingSessionCQ> getScalarCondition() {
        return _scalarConditionMap;
    }

    public String keepScalarCondition(CrawlingSessionCQ subQuery) {
        if (_scalarConditionMap == null) {
            _scalarConditionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarConditionMap.size() + 1);
        _scalarConditionMap.put(key, subQuery);
        return "scalarCondition." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, CrawlingSessionCQ> _myselfInScopeRelationMap;

    public Map<String, CrawlingSessionCQ> getMyselfInScopeRelation() {
        return _myselfInScopeRelationMap;
    }

    public String keepMyselfInScopeRelation(CrawlingSessionCQ subQuery) {
        if (_myselfInScopeRelationMap == null) {
            _myselfInScopeRelationMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeRelationMap.size() + 1);
        _myselfInScopeRelationMap.put(key, subQuery);
        return "myselfInScopeRelation." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xCB() {
        return CrawlingSessionCB.class.getName();
    }

    protected String xCQ() {
        return CrawlingSessionCQ.class.getName();
    }

    protected String xMap() {
        return Map.class.getName();
    }
}
