/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.SearchLogDbm;
import jp.sf.fess.db.cbean.ClickLogCB;
import jp.sf.fess.db.cbean.SearchLogCB;
import jp.sf.fess.db.exbhv.ClickLogBhv;
import jp.sf.fess.db.exentity.ClickLog;
import jp.sf.fess.db.exentity.SearchLog;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of SEARCH_LOG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, SEARCH_WORD, SEARCH_QUERY, SOLR_QUERY, REQUESTED_TIME, RESPONSE_TIME, HIT_COUNT, QUERY_OFFSET, QUERY_PAGE_SIZE, USER_AGENT, REFERER, CLIENT_IP, USER_SESSION_ID, ACCESS_TYPE
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     CLICK_LOG
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     clickLogList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsSearchLogBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    public static final String PATH_selectClientIpRanking = "selectClientIpRanking";

    public static final String PATH_selectUserAgentRanking = "selectUserAgentRanking";

    public static final String PATH_selectSearchWordRanking = "selectSearchWordRanking";

    public static final String PATH_selectRefererRanking = "selectRefererRanking";

    public static final String PATH_selectHotSearchWord = "selectHotSearchWord";

    public static final String PATH_selectSearchQueryRanking = "selectSearchQueryRanking";

    public static final String PATH_selectSolrQueryRanking = "selectSolrQueryRanking";

    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "SEARCH_LOG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return SearchLogDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public SearchLogDbm getMyDBMeta() {
        return SearchLogDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public SearchLog newMyEntity() {
        return new SearchLog();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public SearchLogCB newMyConditionBean() {
        return new SearchLogCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * int count = searchLogBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The selected count.
     */
    public int selectCount(SearchLogCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(SearchLogCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * searchLogBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;SearchLog&gt;() {
     *     public void handle(SearchLog entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @param entityRowHandler The handler of entity row of SearchLog. (NotNull)
     */
    public void selectCursor(SearchLogCB cb,
            EntityRowHandler<SearchLog> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> void doSelectCursor(SearchLogCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<SearchLog>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * SearchLog searchLog = searchLogBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (searchLog != null) {
     *     ... = searchLog.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public SearchLog selectEntity(SearchLogCB cb) {
        return doSelectEntity(cb, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> ENTITY doSelectEntity(
            final SearchLogCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, SearchLogCB>() {
                    public List<ENTITY> callbackSelectList(SearchLogCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * SearchLog searchLog = searchLogBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = searchLog.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public SearchLog selectEntityWithDeletedCheck(SearchLogCB cb) {
        return doSelectEntityWithDeletedCheck(cb, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> ENTITY doSelectEntityWithDeletedCheck(
            final SearchLogCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, SearchLogCB>() {
                    public List<ENTITY> callbackSelectList(SearchLogCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public SearchLog selectByPKValue(Long id) {
        return doSelectByPKValue(id, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public SearchLog selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private SearchLogCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        SearchLogCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;SearchLog&gt; searchLogList = searchLogBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (SearchLog searchLog : searchLogList) {
     *     ... = searchLog.get...();
     * }
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<SearchLog> selectList(SearchLogCB cb) {
        return doSelectList(cb, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> ListResultBean<ENTITY> doSelectList(
            SearchLogCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, SearchLogCB>() {
                    public List<ENTITY> callbackSelectList(SearchLogCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;SearchLog&gt; page = searchLogBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (SearchLog searchLog : page) {
     *     ... = searchLog.get...();
     * }
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<SearchLog> selectPage(SearchLogCB cb) {
        return doSelectPage(cb, SearchLog.class);
    }

    protected <ENTITY extends SearchLog> PagingResultBean<ENTITY> doSelectPage(
            SearchLogCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, SearchLogCB>() {
                    public int callbackSelectCount(SearchLogCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(SearchLogCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * searchLogBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(SearchLogCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<SearchLogCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends SearchLogCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param searchLog The entity of searchLog. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadClickLogList(SearchLog searchLog,
            ConditionBeanSetupper<ClickLogCB> conditionBeanSetupper) {
        xassLRArg(searchLog, conditionBeanSetupper);
        loadClickLogList(xnewLRLs(searchLog), conditionBeanSetupper);
    }

    /**
     * Load referrer of clickLogList with the set-upper for condition-bean of referrer.
     * <pre>
     * searchLogBhv.<span style="color: #FD4747">loadClickLogList</span>(searchLogList, new ConditionBeanSetupper&lt;ClickLogCB&gt;() {
     *     public void setup(ClickLogCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (SearchLog searchLog : searchLogList) {
     *     ... = searchLog.<span style="color: #FD4747">getClickLogList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setSearchId_InScope(pkList);
     * cb.query().addOrderBy_SearchId_Asc();
     * </pre>
     * @param searchLogList The entity list of searchLog. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadClickLogList(List<SearchLog> searchLogList,
            ConditionBeanSetupper<ClickLogCB> conditionBeanSetupper) {
        xassLRArg(searchLogList, conditionBeanSetupper);
        loadClickLogList(searchLogList,
                new LoadReferrerOption<ClickLogCB, ClickLog>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param searchLog The entity of searchLog. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadClickLogList(SearchLog searchLog,
            LoadReferrerOption<ClickLogCB, ClickLog> loadReferrerOption) {
        xassLRArg(searchLog, loadReferrerOption);
        loadClickLogList(xnewLRLs(searchLog), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param searchLogList The entity list of searchLog. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadClickLogList(List<SearchLog> searchLogList,
            LoadReferrerOption<ClickLogCB, ClickLog> loadReferrerOption) {
        xassLRArg(searchLogList, loadReferrerOption);
        if (searchLogList.isEmpty()) {
            return;
        }
        final ClickLogBhv referrerBhv = xgetBSFLR().select(ClickLogBhv.class);
        helpLoadReferrerInternally(
                searchLogList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<SearchLog, Long, ClickLogCB, ClickLog>() {
                    public Long getPKVal(SearchLog e) {
                        return e.getId();
                    }

                    public void setRfLs(SearchLog e, List<ClickLog> ls) {
                        e.setClickLogList(ls);
                    }

                    public ClickLogCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(ClickLogCB cb, List<Long> ls) {
                        cb.query().setSearchId_InScope(ls);
                    }

                    public void qyOdFKAsc(ClickLogCB cb) {
                        cb.query().addOrderBy_SearchId_Asc();
                    }

                    public List<ClickLog> selRfLs(ClickLogCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(ClickLog e) {
                        return e.getSearchId();
                    }

                    public void setlcEt(ClickLog re, SearchLog le) {
                        re.setSearchLog(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * SearchLog searchLog = new SearchLog();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * searchLog.setFoo...(value);
     * searchLog.setBar...(value);
     * searchLogBhv.<span style="color: #FD4747">insert</span>(searchLog);
     * ... = searchLog.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param searchLog The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(SearchLog searchLog) {
        assertEntityNotNull(searchLog);
        delegateInsert(searchLog);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * SearchLog searchLog = new SearchLog();
     * searchLog.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * searchLog.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * searchLog.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     searchLogBhv.<span style="color: #FD4747">update</span>(searchLog);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param searchLog The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final SearchLog searchLog) {
        helpUpdateInternally(searchLog,
                new InternalUpdateCallback<SearchLog>() {
                    public int callbackDelegateUpdate(SearchLog entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param searchLog The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final SearchLog searchLog) {
        helpInsertOrUpdateInternally(searchLog,
                new InternalInsertOrUpdateCallback<SearchLog, SearchLogCB>() {
                    public void callbackInsert(SearchLog entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(SearchLog entity) {
                        update(entity);
                    }

                    public SearchLogCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(SearchLogCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * SearchLog searchLog = new SearchLog();
     * searchLog.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * searchLog.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     searchLogBhv.<span style="color: #FD4747">delete</span>(searchLog);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param searchLog The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(SearchLog searchLog) {
        helpDeleteInternally(searchLog,
                new InternalDeleteCallback<SearchLog>() {
                    public int callbackDelegateDelete(SearchLog entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param searchLogList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<SearchLog> searchLogList) {
        assertObjectNotNull("searchLogList", searchLogList);
        return delegateInsertList(searchLogList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param searchLogList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<SearchLog> searchLogList) {
        assertObjectNotNull("searchLogList", searchLogList);
        return delegateUpdateList(searchLogList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param searchLogList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<SearchLog> searchLogList) {
        assertObjectNotNull("searchLogList", searchLogList);
        return delegateDeleteList(searchLogList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * SearchLog searchLog = new SearchLog();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//searchLog.setPK...(value);</span>
     * searchLog.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//searchLog.setVersionNo(value);</span>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * searchLogBhv.<span style="color: #FD4747">queryUpdate</span>(searchLog, cb);
     * </pre>
     * @param searchLog The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(SearchLog searchLog, SearchLogCB cb) {
        return delegateQueryUpdate(searchLog, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * searchLogBhv.<span style="color: #FD4747">queryDelete</span>(searchLog, cb);
     * </pre>
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(SearchLogCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * SearchLog searchLog = new SearchLog();
     * searchLog.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * searchLog.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * searchLog.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;SearchLogCB&gt; option = new UpdateOption&lt;SearchLogCB&gt;();
     *     option.self(new SpecifyQuery&lt;SearchLogCB&gt;() {
     *         public void specify(SearchLogCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     searchLogBhv.<span style="color: #FD4747">varyingUpdate</span>(searchLog, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param searchLog The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(SearchLog searchLog,
            final UpdateOption<SearchLogCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(searchLog,
                new InternalUpdateCallback<SearchLog>() {
                    public int callbackDelegateUpdate(SearchLog entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * SearchLog searchLog = new SearchLog();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//searchLog.setPK...(value);</span>
     * searchLog.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//searchLog.setVersionNo(value);</span>
     * SearchLogCB cb = new SearchLogCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;SearchLogCB&gt; option = new UpdateOption&lt;SearchLogCB&gt;();
     * option.self(new SpecifyQuery&lt;SearchLogCB&gt;() {
     *     public void specify(SearchLogCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * searchLogBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(searchLog, cb, option);
     * </pre>
     * @param searchLog The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of SearchLog. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(SearchLog searchLog, SearchLogCB cb,
            final UpdateOption<SearchLogCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(searchLog, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<SearchLogCB> option) {
        assertUpdateOptionNotNull(option);
        SearchLogCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(SearchLogCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends SearchLog> void delegateSelectCursor(
            SearchLogCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends SearchLog> List<ENTITY> delegateSelectList(
            SearchLogCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(SearchLog e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(SearchLog e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(SearchLog e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<SearchLog> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<SearchLog> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<SearchLog> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(SearchLog e, SearchLogCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(SearchLogCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(SearchLog e,
            UpdateOption<SearchLogCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(SearchLog e, SearchLogCB cb,
            UpdateOption<SearchLogCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected SearchLog downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, SearchLog.class);
    }

    protected SearchLogCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, SearchLogCB.class);
    }
}
