/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FileAuthenticationDbm;
import jp.sf.fess.db.cbean.FileAuthenticationCB;
import jp.sf.fess.db.exentity.FileAuthentication;
import jp.sf.fess.db.exentity.FileCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of FILE_AUTHENTICATION as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, HOSTNAME, PORT, PROTOCOL_SCHEME, USERNAME, PASSWORD, PARAMETERS, FILE_CRAWLING_CONFIG_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     FILE_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     fileCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileAuthenticationBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_AUTHENTICATION";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileAuthenticationDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileAuthenticationDbm getMyDBMeta() {
        return FileAuthenticationDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FileAuthentication newMyEntity() {
        return new FileAuthentication();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FileAuthenticationCB newMyConditionBean() {
        return new FileAuthenticationCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * int count = fileAuthenticationBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileAuthenticationCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(FileAuthenticationCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FileAuthentication&gt;() {
     *     public void handle(FileAuthentication entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @param entityRowHandler The handler of entity row of FileAuthentication. (NotNull)
     */
    public void selectCursor(FileAuthenticationCB cb,
            EntityRowHandler<FileAuthentication> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> void doSelectCursor(
            FileAuthenticationCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileAuthentication>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * FileAuthentication fileAuthentication = fileAuthenticationBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (fileAuthentication != null) {
     *     ... = fileAuthentication.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectEntity(FileAuthenticationCB cb) {
        return doSelectEntity(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectEntity(
            final FileAuthenticationCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, FileAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * FileAuthentication fileAuthentication = fileAuthenticationBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = fileAuthentication.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectEntityWithDeletedCheck(
            FileAuthenticationCB cb) {
        return doSelectEntityWithDeletedCheck(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectEntityWithDeletedCheck(
            final FileAuthenticationCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FileAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectByPKValue(Long id) {
        return doSelectByPKValue(id, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FileAuthenticationCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FileAuthenticationCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FileAuthentication&gt; fileAuthenticationList = fileAuthenticationBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FileAuthentication fileAuthentication : fileAuthenticationList) {
     *     ... = fileAuthentication.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FileAuthentication> selectList(FileAuthenticationCB cb) {
        return doSelectList(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ListResultBean<ENTITY> doSelectList(
            FileAuthenticationCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, FileAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FileAuthentication&gt; page = fileAuthenticationBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FileAuthentication fileAuthentication : page) {
     *     ... = fileAuthentication.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FileAuthentication> selectPage(
            FileAuthenticationCB cb) {
        return doSelectPage(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> PagingResultBean<ENTITY> doSelectPage(
            FileAuthenticationCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, FileAuthenticationCB>() {
                    public int callbackSelectCount(FileAuthenticationCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * fileAuthenticationBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FileAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FileAuthenticationCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FileAuthenticationCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param fileAuthenticationList The list of fileAuthentication. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FileAuthentication> fileAuthenticationList) {
        return helpPulloutInternally(
                fileAuthenticationList,
                new InternalPulloutCallback<FileAuthentication, FileCrawlingConfig>() {
                    public FileCrawlingConfig getFr(FileAuthentication e) {
                        return e.getFileCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileAuthentication> ls) {
                        e.setFileAuthenticationList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileAuthentication.setFoo...(value);
     * fileAuthentication.setBar...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">insert</span>(fileAuthentication);
     * ... = fileAuthentication.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileAuthentication The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileAuthentication fileAuthentication) {
        assertEntityNotNull(fileAuthentication);
        delegateInsert(fileAuthentication);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileAuthenticationBhv.<span style="color: #FD4747">update</span>(fileAuthentication);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final FileAuthentication fileAuthentication) {
        helpUpdateInternally(fileAuthentication,
                new InternalUpdateCallback<FileAuthentication>() {
                    public int callbackDelegateUpdate(FileAuthentication entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">updateNonstrict</span>(fileAuthentication);
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final FileAuthentication fileAuthentication) {
        helpUpdateNonstrictInternally(fileAuthentication,
                new InternalUpdateNonstrictCallback<FileAuthentication>() {
                    public int callbackDelegateUpdateNonstrict(
                            FileAuthentication entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param fileAuthentication The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final FileAuthentication fileAuthentication) {
        helpInsertOrUpdateInternally(
                fileAuthentication,
                new InternalInsertOrUpdateCallback<FileAuthentication, FileAuthenticationCB>() {
                    public void callbackInsert(FileAuthentication entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(FileAuthentication entity) {
                        update(entity);
                    }

                    public FileAuthenticationCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(FileAuthenticationCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param fileAuthentication The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(FileAuthentication fileAuthentication) {
        helpInsertOrUpdateInternally(
                fileAuthentication,
                new InternalInsertOrUpdateNonstrictCallback<FileAuthentication>() {
                    public void callbackInsert(FileAuthentication entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(
                            FileAuthentication entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileAuthenticationBhv.<span style="color: #FD4747">delete</span>(fileAuthentication);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileAuthentication fileAuthentication) {
        helpDeleteInternally(fileAuthentication,
                new InternalDeleteCallback<FileAuthentication>() {
                    public int callbackDelegateDelete(FileAuthentication entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">deleteNonstrict</span>(fileAuthentication);
     * </pre>
     * @param fileAuthentication Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(FileAuthentication fileAuthentication) {
        helpDeleteNonstrictInternally(fileAuthentication,
                new InternalDeleteNonstrictCallback<FileAuthentication>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileAuthentication entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(fileAuthentication);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param fileAuthentication Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            FileAuthentication fileAuthentication) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                fileAuthentication,
                new InternalDeleteNonstrictIgnoreDeletedCallback<FileAuthentication>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileAuthentication entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<FileAuthentication> fileAuthenticationList) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        return delegateInsertList(fileAuthenticationList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<FileAuthentication> fileAuthenticationList) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        return delegateUpdateList(fileAuthenticationList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<FileAuthentication> fileAuthenticationList) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        return delegateUpdateListNonstrict(fileAuthenticationList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<FileAuthentication> fileAuthenticationList) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        return delegateDeleteList(fileAuthenticationList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<FileAuthentication> fileAuthenticationList) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        return delegateDeleteListNonstrict(fileAuthenticationList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setPK...(value);</span>
     * fileAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">queryUpdate</span>(fileAuthentication, cb);
     * </pre>
     * @param fileAuthentication The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(FileAuthentication fileAuthentication,
            FileAuthenticationCB cb) {
        return delegateQueryUpdate(fileAuthentication, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">queryDelete</span>(fileAuthentication, cb);
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FileAuthenticationCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;FileAuthenticationCB&gt; option = new UpdateOption&lt;FileAuthenticationCB&gt;();
     *     option.self(new SpecifyQuery&lt;FileAuthenticationCB&gt;() {
     *         public void specify(FileAuthenticationCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     fileAuthenticationBhv.<span style="color: #FD4747">varyingUpdate</span>(fileAuthentication, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(FileAuthentication fileAuthentication,
            final UpdateOption<FileAuthenticationCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(fileAuthentication,
                new InternalUpdateCallback<FileAuthentication>() {
                    public int callbackDelegateUpdate(FileAuthentication entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * UpdateOption&lt;FileAuthenticationCB&gt; option = new UpdateOption&lt;FileAuthenticationCB&gt;();
     * option.self(new SpecifyQuery&lt;FileAuthenticationCB&gt;() {
     *     public void specify(FileAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(fileAuthentication, option);
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(FileAuthentication fileAuthentication,
            final UpdateOption<FileAuthenticationCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(fileAuthentication,
                new InternalUpdateNonstrictCallback<FileAuthentication>() {
                    public int callbackDelegateUpdateNonstrict(
                            FileAuthentication entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setPK...(value);</span>
     * fileAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FileAuthenticationCB&gt; option = new UpdateOption&lt;FileAuthenticationCB&gt;();
     * option.self(new SpecifyQuery&lt;FileAuthenticationCB&gt;() {
     *     public void specify(FileAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(fileAuthentication, cb, option);
     * </pre>
     * @param fileAuthentication The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(FileAuthentication fileAuthentication,
            FileAuthenticationCB cb,
            final UpdateOption<FileAuthenticationCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(fileAuthentication, cb, option);
    }

    protected void processVaryingUpdate(
            UpdateOption<FileAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        FileAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FileAuthenticationCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends FileAuthentication> void delegateSelectCursor(
            FileAuthenticationCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends FileAuthentication> List<ENTITY> delegateSelectList(
            FileAuthenticationCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileAuthentication e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(FileAuthentication e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(FileAuthentication e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(FileAuthentication e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(FileAuthentication e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<FileAuthentication> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FileAuthentication> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<FileAuthentication> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<FileAuthentication> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<FileAuthentication> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(FileAuthentication e,
            FileAuthenticationCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(FileAuthenticationCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(FileAuthentication e,
            UpdateOption<FileAuthenticationCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(FileAuthentication e,
            UpdateOption<FileAuthenticationCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(FileAuthentication e,
            FileAuthenticationCB cb, UpdateOption<FileAuthenticationCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FileAuthentication downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, FileAuthentication.class);
    }

    protected FileAuthenticationCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                FileAuthenticationCB.class);
    }
}
