/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.action;

import java.text.NumberFormat;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.form.MobileForm;
import jp.sf.fess.service.SearchService;

import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.RequestUtil;

public class MobileAction {

    private static final long serialVersionUID = 1L;

    public static final int DEFAULT_PAGE_SIZE = 10;

    public static final long DEFAULT_START_COUNT = 0;

    @ActionForm
    @Resource
    protected MobileForm mobileForm;

    @Resource
    protected SearchService searchService;

    public List<Map<String, Object>> documentItems;

    public String pageSize;

    public String currentPageNumber;

    public String allRecordCount;

    public String allPageCount;

    public boolean existNextPage;

    public boolean existPrevPage;

    public String currentStartRecordNumber;

    public String currentEndRecordNumber;

    public List<String> pageNumberList;

    public String execTime;

    @Execute(validator = false)
    public String index() {
        return "index.jsp";
    }

    protected String doSearch() {
        if (StringUtil.isBlank(mobileForm.query)) {
            // redirect to index page
            mobileForm.query = null;
            return "index?redirect=true";
        }

        // init pager
        if (StringUtil.isBlank(mobileForm.start)) {
            mobileForm.start = String.valueOf(DEFAULT_START_COUNT);
        } else {
            try {
                Long.parseLong(mobileForm.start);
            } catch (NumberFormatException e) {
                mobileForm.start = String.valueOf(DEFAULT_START_COUNT);
            }
        }
        if (StringUtil.isBlank(mobileForm.num)) {
            mobileForm.num = String.valueOf(DEFAULT_PAGE_SIZE);
        } else {
            try {
                int num = Integer.parseInt(mobileForm.num);
                if (num > 100) {
                    // max page size
                    mobileForm.num = "100";
                }
            } catch (NumberFormatException e) {
                mobileForm.num = String.valueOf(DEFAULT_PAGE_SIZE);
            }
        }

        long startTime = System.currentTimeMillis();
        documentItems = searchService.selectList(mobileForm.query, Integer
                .parseInt(mobileForm.start), Integer.parseInt(mobileForm.num));
        long execTime = System.currentTimeMillis() - startTime;

        NumberFormat nf = NumberFormat.getInstance(RequestUtil.getRequest()
                .getLocale());
        nf.setMaximumIntegerDigits(2);
        nf.setMaximumFractionDigits(2);
        try {
            this.execTime = nf.format(((double) execTime) / 1000);
        } catch (Exception e) {
        }

        Beans.copy(documentItems, this).includes("pageSize",
                "currentPageNumber", "allRecordCount", "allPageCount",
                "existNextPage", "existPrevPage", "currentStartRecordNumber",
                "currentEndRecordNumber", "pageNumberList").execute();

        return "search.jsp";
    }

    @Execute(validator = false)
    public String search() {
        return doSearch();
    }

    @Execute(validator = false)
    public String prev() {
        return doMove(-1);
    }

    @Execute(validator = false)
    public String next() {
        return doMove(1);
    }

    @Execute(validator = false)
    public String move() {
        return doMove(0);
    }

    protected String doMove(int move) {
        int pageSize = DEFAULT_PAGE_SIZE;
        if (StringUtil.isBlank(mobileForm.num)) {
            mobileForm.num = String.valueOf(DEFAULT_PAGE_SIZE);
        } else {
            try {
                pageSize = Integer.parseInt(mobileForm.num);
            } catch (NumberFormatException e) {
                mobileForm.num = String.valueOf(DEFAULT_PAGE_SIZE);
            }
        }

        if (StringUtil.isBlank(mobileForm.pn)) {
            mobileForm.start = String.valueOf(DEFAULT_START_COUNT);
        } else {
            Integer pageNumber = Integer.parseInt(mobileForm.pn);
            if (pageNumber != null && pageNumber > 0) {
                pageNumber = pageNumber + move;
                if (pageNumber < 1) {
                    pageNumber = 1;
                }
                mobileForm.start = String.valueOf((pageNumber - 1) * pageSize);
            } else {
                mobileForm.start = String.valueOf(DEFAULT_START_COUNT);
            }
        }

        return doSearch();
    }
}