package jp.sf.fess.ds.impl;

import java.util.HashMap;
import java.util.Map;

import org.seasar.extension.unit.S2TestCase;

public class DatabaseDataStoreImplTest extends S2TestCase {
    public DatabaseDataStoreImpl databaseDataStore;

    @Override
    protected String getRootDicon() throws Throwable {
        return "fess_ds.dicon";
    }

    public void test_parseParameter() {
        String value;
        Map<String, String> paramMap;

        value = "a=b";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(1, paramMap.size());
        assertEquals("b", paramMap.get("a"));

        value = "a=b\n1=2";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(2, paramMap.size());
        assertEquals("b", paramMap.get("a"));
        assertEquals("2", paramMap.get("1"));

        value = "a=";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(1, paramMap.size());
        assertEquals("", paramMap.get("a"));

        value = "a";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(1, paramMap.size());
        assertEquals("", paramMap.get("a"));

        value = "a=b=c";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(1, paramMap.size());
        assertEquals("b=c", paramMap.get("a"));

        value = null;
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(0, paramMap.size());

        value = "";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(0, paramMap.size());

        value = " ";
        paramMap = databaseDataStore.parseParameter(value);
        assertEquals(0, paramMap.size());
    }

    public void test_parseScript() {
        String value;
        Map<String, String> scriptMap;

        value = "a=b";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(1, scriptMap.size());
        assertEquals("b", scriptMap.get("a"));

        value = "a=b\n1=2";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(2, scriptMap.size());
        assertEquals("b", scriptMap.get("a"));
        assertEquals("2", scriptMap.get("1"));

        value = "a=";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(1, scriptMap.size());
        assertEquals("", scriptMap.get("a"));

        value = "a";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(1, scriptMap.size());
        assertEquals("", scriptMap.get("a"));

        value = "a=b=c";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(1, scriptMap.size());
        assertEquals("b=c", scriptMap.get("a"));

        value = null;
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(0, scriptMap.size());

        value = "";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(0, scriptMap.size());

        value = " ";
        scriptMap = databaseDataStore.parseScript(value);
        assertEquals(0, scriptMap.size());
    }

    public void test_convertValue() {
        String value;
        Map<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("param1", "PARAM1");
        paramMap.put("param2", "PARAM2+");
        paramMap.put("param3", "PARAM3*");

        value = "\"abc\"";
        assertEquals("abc", databaseDataStore.convertValue(value, paramMap));

        value = "param1";
        assertEquals("PARAM1", databaseDataStore.convertValue(value, paramMap));

        value = "param2";
        assertEquals("PARAM2+", databaseDataStore.convertValue(value, paramMap));

        value = "\"123\"+param2+\",\"+param3+\"abc\"";
        assertEquals("123PARAM2+,PARAM3*abc", databaseDataStore.convertValue(
                value, paramMap));

        value = null;
        assertEquals("", databaseDataStore.convertValue(value, paramMap));

        value = "";
        assertEquals("", databaseDataStore.convertValue(value, paramMap));

        value = " ";
        assertEquals(" ", databaseDataStore.convertValue(value, paramMap));
    }

}
