/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.exentity.CrawlingSessionInfo;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of CRAWLING_SESSION_INFO. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class CrawlingSessionInfoDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final CrawlingSessionInfoDbm _instance = new CrawlingSessionInfoDbm();

    private CrawlingSessionInfoDbm() {
    }

    public static CrawlingSessionInfoDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    public String getTableDbName() {
        return "CRAWLING_SESSION_INFO";
    }

    public String getTablePropertyName() {
        return "crawlingSessionInfo";
    }

    public String getTableSqlName() {
        return "CRAWLING_SESSION_INFO";
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected ColumnInfo _columnId = cci("ID", null, "id", Long.class, true,
            true, null, null);

    protected ColumnInfo _columnCrawlingSessionId = cci("CRAWLING_SESSION_ID",
            null, "crawlingSessionId", Long.class, false, false, null, null);

    protected ColumnInfo _columnKey = cci("KEY", null, "key", String.class,
            false, false, 20, 0);

    protected ColumnInfo _columnValue = cci("VALUE", null, "value",
            String.class, false, false, 100, 0);

    protected ColumnInfo _columnCreatedTime = cci("CREATED_TIME", null,
            "createdTime", java.sql.Timestamp.class, false, false, null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnCrawlingSessionId() {
        return _columnCrawlingSessionId;
    }

    public ColumnInfo columnKey() {
        return _columnKey;
    }

    public ColumnInfo columnValue() {
        return _columnValue;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignCrawlingSession() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnCrawlingSessionId(), CrawlingSessionDbm.getInstance()
                        .columnId());
        return cfi("crawlingSession", this, CrawlingSessionDbm.getInstance(),
                map, 0, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.CrawlingSessionInfo";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.CrawlingSessionInfoCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.CrawlingSessionInfoDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.CrawlingSessionInfoBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<CrawlingSessionInfo> getEntityType() {
        return CrawlingSessionInfo.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public CrawlingSessionInfo newMyEntity() {
        return new CrawlingSessionInfo();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    // -----------------------------------------------------
    //                                                Accept
    //                                                ------
    public void acceptPrimaryKeyMap(Entity entity,
            Map<String, ? extends Object> primaryKeyMap) {
        doAcceptPrimaryKeyMap((CrawlingSessionInfo) entity, primaryKeyMap,
                _epsMap);
    }

    public void acceptPrimaryKeyMapString(Entity entity,
            String primaryKeyMapString) {
        MapStringUtil.acceptPrimaryKeyMapString(primaryKeyMapString, entity);
    }

    public void acceptColumnValueMap(Entity entity,
            Map<String, ? extends Object> columnValueMap) {
        doAcceptColumnValueMap((CrawlingSessionInfo) entity, columnValueMap,
                _epsMap);
    }

    public void acceptColumnValueMapString(Entity entity,
            String columnValueMapString) {
        MapStringUtil.acceptColumnValueMapString(columnValueMapString, entity);
    }

    // -----------------------------------------------------
    //                                               Extract
    //                                               -------
    public String extractPrimaryKeyMapString(Entity entity) {
        return MapStringUtil.extractPrimaryKeyMapString(entity);
    }

    public String extractPrimaryKeyMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractPrimaryKeyMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    public String extractColumnValueMapString(Entity entity) {
        return MapStringUtil.extractColumnValueMapString(entity);
    }

    public String extractColumnValueMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractColumnValueMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    // -----------------------------------------------------
    //                                               Convert
    //                                               -------
    public List<Object> convertToColumnValueList(Entity entity) {
        return newArrayList(convertToColumnValueMap(entity).values());
    }

    public Map<String, Object> convertToColumnValueMap(Entity entity) {
        return doConvertToColumnValueMap(entity);
    }

    public List<String> convertToColumnStringValueList(Entity entity) {
        return newArrayList(convertToColumnStringValueMap(entity).values());
    }

    public Map<String, String> convertToColumnStringValueMap(Entity entity) {
        return doConvertToColumnStringValueMap(entity);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<CrawlingSessionInfo>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsCrawlingSessionId(), columnCrawlingSessionId());
        setupEps(_epsMap, new EpsKey(), columnKey());
        setupEps(_epsMap, new EpsValue(), columnValue());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((CrawlingSessionInfo) entity,
                value);
    }

    public static class EpsId implements Eps<CrawlingSessionInfo> {
        public void setup(CrawlingSessionInfo e, Object v) {
            e.setId((Long) v);
        }
    }

    public static class EpsCrawlingSessionId implements
            Eps<CrawlingSessionInfo> {
        public void setup(CrawlingSessionInfo e, Object v) {
            e.setCrawlingSessionId((Long) v);
        }
    }

    public static class EpsKey implements Eps<CrawlingSessionInfo> {
        public void setup(CrawlingSessionInfo e, Object v) {
            e.setKey((String) v);
        }
    }

    public static class EpsValue implements Eps<CrawlingSessionInfo> {
        public void setup(CrawlingSessionInfo e, Object v) {
            e.setValue((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<CrawlingSessionInfo> {
        public void setup(CrawlingSessionInfo e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }
}
