/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import org.seasar.extension.unit.S2TestCase;

public class QueryHelperTest extends S2TestCase {

    public QueryHelper queryHelper;

    @Override
    protected String getRootDicon() throws Throwable {
        return "app.dicon";
    }

    public void test_build() {
        assertEquals("", queryHelper.buildQuery(""));

        assertEquals("(title:\"QUERY\") OR (content:\"QUERY\")", queryHelper
                .buildQuery("QUERY"));
        assertEquals("(title:\"QUERY\") OR (content:\"QUERY\")", queryHelper
                .buildQuery("QUERY "));
        assertEquals("(title:\"QUERY\") OR (content:\"QUERY\")", queryHelper
                .buildQuery(" QUERY"));

        assertEquals(
                "(title:\"QUERY1\" AND title:\"QUERY2\") OR (content:\"QUERY1\" AND content:\"QUERY2\")",
                queryHelper.buildQuery("QUERY1 QUERY2"));
        assertEquals(
                "(title:\"QUERY1\" AND title:\"QUERY2\") OR (content:\"QUERY1\" AND content:\"QUERY2\")",
                queryHelper.buildQuery("QUERY1 QUERY2 "));
        assertEquals(
                "(title:\"QUERY1\" AND title:\"QUERY2\") OR (content:\"QUERY1\" AND content:\"QUERY2\")",
                queryHelper.buildQuery(" QUERY1 QUERY2"));

        assertEquals(
                "(title:\"QUERY1 QUERY2\") OR (content:\"QUERY1 QUERY2\")",
                queryHelper.buildQuery("\"QUERY1 QUERY2\""));
        assertEquals(
                "(title:\"QUERY1 QUERY2\") OR (content:\"QUERY1 QUERY2\")",
                queryHelper.buildQuery("\"QUERY1 QUERY2\" "));
        assertEquals(
                "(title:\"QUERY1 QUERY2\") OR (content:\"QUERY1 QUERY2\")",
                queryHelper.buildQuery(" \"QUERY1 QUERY2\""));

        assertEquals(
                "(title:\"QUERY1 QUERY2\" AND title:\"QUERY3\") OR (content:\"QUERY1 QUERY2\" AND content:\"QUERY3\")",
                queryHelper.buildQuery("\"QUERY1 QUERY2\" QUERY3"));
    }
}
