/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.LabelTypeDbm;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of LABEL_TYPE that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FILE_CONFIG_TO_LABEL_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     fileConfigToLabelTypeMappingList, webConfigToLabelTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsLabelTypeBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "LABEL_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return LabelTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public LabelTypeDbm getMyDBMeta() {
        return LabelTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public LabelType newMyEntity() {
        return new LabelType();
    }

    public LabelTypeCB newMyConditionBean() {
        return new LabelTypeCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(LabelTypeCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of LabelType. (NotNull)
     * @param entityRowHandler The handler of entity row of LabelType. (NotNull)
     */
    public void selectCursor(LabelTypeCB cb,
            EntityRowHandler<LabelType> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<LabelType>", entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public LabelType selectEntity(final LabelTypeCB cb) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<LabelType, LabelTypeCB>() {
                    public List<LabelType> callbackSelectList(LabelTypeCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public LabelType selectEntityWithDeletedCheck(final LabelTypeCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<LabelType, LabelTypeCB>() {
                    public List<LabelType> callbackSelectList(LabelTypeCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public LabelType selectByPKValueWithDeletedCheck(Long id) {
        LabelType entity = new LabelType();
        entity.setId(id);
        final LabelTypeCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<LabelType> selectList(LabelTypeCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<LabelType>(getTableDbName())
                .buildListResultBean(cb, delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<LabelType> selectPage(final LabelTypeCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<LabelType> invoker = new PagingInvoker<LabelType>(
                getTableDbName());
        final PagingHandler<LabelType> handler = new PagingHandler<LabelType>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<LabelType> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * labelTypeBhv.scalarSelect(Date.class).max(new ScalarQuery(LabelTypeCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<LabelTypeCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        LabelTypeCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<LabelTypeCB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            LabelType labelType,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelType, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(labelType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToLabelTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setLabelTypeId_InScope(pkList);
     * cb.query().addOrderBy_LabelTypeId_Asc();
     * </pre>
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelTypeList, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(
                labelTypeList,
                new LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            LabelType labelType,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelType, loadReferrerOption);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(labelType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelTypeList, loadReferrerOption);
        if (labelTypeList.isEmpty()) {
            return;
        }
        final FileConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                labelTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<LabelType, Long, FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(LabelType entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(LabelType entity,
                            List<FileConfigToLabelTypeMapping> referrerList) {
                        entity
                                .setFileConfigToLabelTypeMappingList(referrerList);
                    }

                    public FileConfigToLabelTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            FileConfigToLabelTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setLabelTypeId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            FileConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_LabelTypeId_Asc();
                    }

                    public List<FileConfigToLabelTypeMapping> callbackReferrer_selectList(
                            FileConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            FileConfigToLabelTypeMapping entity) {
                        return entity.getLabelTypeId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            FileConfigToLabelTypeMapping referrerEntity,
                            LabelType baseEntity) {
                        referrerEntity.setLabelType(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            LabelType labelType,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelType, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(labelType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToLabelTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setLabelTypeId_InScope(pkList);
     * cb.query().addOrderBy_LabelTypeId_Asc();
     * </pre>
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelTypeList, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(
                labelTypeList,
                new LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            LabelType labelType,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelType, loadReferrerOption);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(labelType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelTypeList, loadReferrerOption);
        if (labelTypeList.isEmpty()) {
            return;
        }
        final WebConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                labelTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<LabelType, Long, WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(LabelType entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(LabelType entity,
                            List<WebConfigToLabelTypeMapping> referrerList) {
                        entity.setWebConfigToLabelTypeMappingList(referrerList);
                    }

                    public WebConfigToLabelTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            WebConfigToLabelTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setLabelTypeId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            WebConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_LabelTypeId_Asc();
                    }

                    public List<WebConfigToLabelTypeMapping> callbackReferrer_selectList(
                            WebConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            WebConfigToLabelTypeMapping entity) {
                        return entity.getLabelTypeId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            WebConfigToLabelTypeMapping referrerEntity,
                            LabelType baseEntity) {
                        referrerEntity.setLabelType(baseEntity);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param labelType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(LabelType labelType) {
        assertEntityNotNull(labelType);
        delegateInsert(labelType);
    }

    @Override
    protected void doCreate(Entity labelType) {
        insert((LabelType) labelType);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param labelType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final LabelType labelType) {
        helpUpdateInternally(labelType,
                new InternalUpdateCallback<LabelType>() {
                    public int callbackDelegateUpdate(LabelType entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((LabelType) entity);
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonConcurrencyControl}
     * @param labelType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final LabelType labelType) {
        helpUpdateNonstrictInternally(labelType,
                new InternalUpdateNonstrictCallback<LabelType>() {
                    public int callbackDelegateUpdateNonstrict(LabelType entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict((LabelType) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param labelType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final LabelType labelType) {
        helpInsertOrUpdateInternally(labelType,
                new InternalInsertOrUpdateCallback<LabelType, LabelTypeCB>() {
                    public void callbackInsert(LabelType entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(LabelType entity) {
                        update(entity);
                    }

                    public LabelTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(LabelTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity labelType) {
        insertOrUpdate((LabelType) labelType);
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonConcurrencyControl(when update)}
     * @param labelType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(LabelType labelType) {
        helpInsertOrUpdateInternally(labelType,
                new InternalInsertOrUpdateNonstrictCallback<LabelType>() {
                    public void callbackInsert(LabelType entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(LabelType entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict((LabelType) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param labelType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(LabelType labelType) {
        helpDeleteInternally(labelType,
                new InternalDeleteCallback<LabelType>() {
                    public int callbackDelegateDelete(LabelType entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity labelType) {
        delete((LabelType) labelType);
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonConcurrencyControl}
     * @param labelType Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(LabelType labelType) {
        helpDeleteNonstrictInternally(labelType,
                new InternalDeleteNonstrictCallback<LabelType>() {
                    public int callbackDelegateDeleteNonstrict(LabelType entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonConcurrencyControl}
     * @param labelType Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(LabelType labelType) {
        helpDeleteNonstrictIgnoreDeletedInternally(labelType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<LabelType>() {
                    public int callbackDelegateDeleteNonstrict(LabelType entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<LabelType> labelTypeList) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        return delegateInsertList(labelTypeList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<LabelType> labelTypeList) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        return delegateUpdateList(labelTypeList);
    }

    /**
     * Batch update the list non-strictly. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<LabelType> labelTypeList) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        return delegateUpdateListNonstrict(labelTypeList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<LabelType> labelTypeList) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        return delegateDeleteList(labelTypeList);
    }

    /**
     * Batch delete the list non-strictly. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<LabelType> labelTypeList) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        return delegateDeleteListNonstrict(labelTypeList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param labelType Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(LabelType labelType, LabelTypeCB cb) {
        assertObjectNotNull("labelType", labelType);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(labelType);
        filterEntityOfUpdate(labelType);
        assertEntityOfUpdate(labelType);
        return invoke(createQueryUpdateEntityCBCommand(labelType, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(LabelTypeCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(LabelTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(LabelTypeCB cb,
            EntityRowHandler<LabelType> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                LabelType.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((LabelTypeCB) cb);
    }

    protected List<LabelType> delegateSelectList(LabelTypeCB cb) {
        return invoke(createSelectListCBCommand(cb, LabelType.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((LabelTypeCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(LabelType e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(LabelType e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateUpdateNonstrict(LabelType e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(LabelType e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int delegateDeleteNonstrict(LabelType e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<LabelType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<LabelType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<LabelType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<LabelType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<LabelType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected LabelType downcast(Entity entity) {
        return helpDowncastInternally(entity, LabelType.class);
    }
}
