/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.fess.Constants;
import jp.sf.fess.crypto.FessCipher;

import org.seasar.framework.container.SingletonS2Container;

public class AuthenticationFilter implements Filter {
    public List<Pattern> urlPatternList = new ArrayList<Pattern>();

    public String cipherName;

    public String loginPath;

    protected FessCipher getFessCipher() {
        if (cipherName != null) {
            return SingletonS2Container.getComponent(cipherName);
        } else {
            return SingletonS2Container.getComponent(FessCipher.class);
        }
    }

    @Override
    public void destroy() {
        urlPatternList = null;
        cipherName = null;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse res = (HttpServletResponse) response;
        String uri = req.getRequestURI();
        FessCipher fessCipher = getFessCipher();
        for (Pattern pattern : urlPatternList) {
            Matcher matcher = pattern.matcher(uri);
            if (matcher.matches()) {
                // require authentication
                if (req.getSession().getAttribute(Constants.LOGIN_INFO) == null) {
                    StringBuilder buf = new StringBuilder(256);
                    buf.append(new Date().getTime());
                    buf.append('|');
                    buf.append(req.getRequestURL());

                    String encoding = request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }

                    StringBuilder urlBuf = new StringBuilder(1000);
                    urlBuf.append(res.encodeURL(loginPath));
                    urlBuf.append("?returnPath=");
                    urlBuf.append(URLEncoder.encode(fessCipher.encryptoText(buf
                            .toString()), encoding));

                    // redirect
                    res.sendRedirect(urlBuf.toString());
                    return;
                }
            }
        }

        request.setAttribute(Constants.AUTH_CIPHER, fessCipher);

        chain.doFilter(request, response);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String value = filterConfig.getInitParameter("urlPatterns");
        if (value != null) {
            String[] urlPatterns = value.split(",");
            for (String urlPattern : urlPatterns) {
                // TODO context name 
                urlPatternList.add(Pattern.compile(urlPattern.trim()));
            }
        }

        cipherName = filterConfig.getInitParameter("cipherName");
        loginPath = filterConfig.getInitParameter("loginPath");
    }

}
