/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.WebConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of WEB_CONFIG_TO_LABEL_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     LABEL_TYPE, WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     labelType, webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToLabelTypeMappingBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebConfigToLabelTypeMappingDbm getMyDBMeta() {
        return WebConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public WebConfigToLabelTypeMapping newMyEntity() {
        return new WebConfigToLabelTypeMapping();
    }

    public WebConfigToLabelTypeMappingCB newMyConditionBean() {
        return new WebConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of WebConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(WebConfigToLabelTypeMappingCB cb,
            EntityRowHandler<WebConfigToLabelTypeMapping> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebConfigToLabelTypeMapping>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public WebConfigToLabelTypeMapping selectEntity(
            final WebConfigToLabelTypeMappingCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB>() {
                    public List<WebConfigToLabelTypeMapping> callbackSelectList(
                            WebConfigToLabelTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public WebConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            final WebConfigToLabelTypeMappingCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB>() {
                    public List<WebConfigToLabelTypeMapping> callbackSelectList(
                            WebConfigToLabelTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public WebConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        WebConfigToLabelTypeMapping entity = new WebConfigToLabelTypeMapping();
        entity.setId(id);
        final WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<WebConfigToLabelTypeMapping> selectList(
            WebConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<WebConfigToLabelTypeMapping>(
                getTableDbName()).buildListResultBean(cb,
                delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<WebConfigToLabelTypeMapping> selectPage(
            final WebConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<WebConfigToLabelTypeMapping> invoker = new PagingInvoker<WebConfigToLabelTypeMapping>(
                getTableDbName());
        final PagingHandler<WebConfigToLabelTypeMapping> handler = new PagingHandler<WebConfigToLabelTypeMapping>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<WebConfigToLabelTypeMapping> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * webConfigToLabelTypeMappingBhv.scalarSelect(Date.class).max(new ScalarQuery(WebConfigToLabelTypeMappingCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<WebConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<WebConfigToLabelTypeMappingCB, RESULT>(cb,
                resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param webConfigToLabelTypeMappingList The list of webConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                webConfigToLabelTypeMappingList,
                new InternalPulloutCallback<WebConfigToLabelTypeMapping, LabelType>() {
                    public LabelType callbackGetForeignEntity(
                            WebConfigToLabelTypeMapping entity) {
                        return entity.getLabelType();
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webConfigToLabelTypeMappingList The list of webConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                webConfigToLabelTypeMappingList,
                new InternalPulloutCallback<WebConfigToLabelTypeMapping, WebCrawlingConfig>() {
                    public WebCrawlingConfig callbackGetForeignEntity(
                            WebConfigToLabelTypeMapping entity) {
                        return entity.getWebCrawlingConfig();
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param webConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        assertEntityNotNull(webConfigToLabelTypeMapping);
        delegateInsert(webConfigToLabelTypeMapping);
    }

    @Override
    protected void doCreate(Entity webConfigToLabelTypeMapping) {
        insert((WebConfigToLabelTypeMapping) webConfigToLabelTypeMapping);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param webConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        helpUpdateInternally(webConfigToLabelTypeMapping,
                new InternalUpdateCallback<WebConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((WebConfigToLabelTypeMapping) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((WebConfigToLabelTypeMapping) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param webConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        helpInsertOrUpdateInternally(
                webConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB>() {
                    public void callbackInsert(
                            WebConfigToLabelTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            WebConfigToLabelTypeMapping entity) {
                        update(entity);
                    }

                    public WebConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            WebConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity webConfigToLabelTypeMapping) {
        insertOrUpdate((WebConfigToLabelTypeMapping) webConfigToLabelTypeMapping);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((WebConfigToLabelTypeMapping) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param webConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        helpDeleteInternally(webConfigToLabelTypeMapping,
                new InternalDeleteCallback<WebConfigToLabelTypeMapping>() {
                    public int callbackDelegateDelete(
                            WebConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity webConfigToLabelTypeMapping) {
        delete((WebConfigToLabelTypeMapping) webConfigToLabelTypeMapping);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        return delegateInsertList(webConfigToLabelTypeMappingList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        return delegateUpdateList(webConfigToLabelTypeMappingList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        return delegateDeleteList(webConfigToLabelTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param webConfigToLabelTypeMapping Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            WebConfigToLabelTypeMappingCB cb) {
        assertObjectNotNull("webConfigToLabelTypeMapping",
                webConfigToLabelTypeMapping);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(webConfigToLabelTypeMapping);
        filterEntityOfUpdate(webConfigToLabelTypeMapping);
        assertEntityOfUpdate(webConfigToLabelTypeMapping);
        return invoke(createQueryUpdateEntityCBCommand(
                webConfigToLabelTypeMapping, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(WebConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(WebConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(WebConfigToLabelTypeMappingCB cb,
            EntityRowHandler<WebConfigToLabelTypeMapping> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                WebConfigToLabelTypeMapping.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((WebConfigToLabelTypeMappingCB) cb);
    }

    protected List<WebConfigToLabelTypeMapping> delegateSelectList(
            WebConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectListCBCommand(cb,
                WebConfigToLabelTypeMapping.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((WebConfigToLabelTypeMappingCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebConfigToLabelTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(WebConfigToLabelTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(WebConfigToLabelTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<WebConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<WebConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<WebConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected WebConfigToLabelTypeMapping downcast(Entity entity) {
        return helpDowncastInternally(entity, WebConfigToLabelTypeMapping.class);
    }
}
