/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task;

public final class TaskConstant {

	public static final String NAME_SPACE_TRIGGER_ANNOTATION_SUFFIX = "Trigger";

	public static final String PROPERTY_NAME_TASKID = "taskId";
	public static final String PROPERTY_NAME_TASKNAME = "taskName";
	public static final String PROPERTY_NAME_DESCRIPTION = "description";
	public static final String PROPERTY_NAME_TRIGGER = "trigger";
	public static final String PROPERTY_NAME_START_TASK = "startTask";
	public static final String PROPERTY_NAME_END_TASK = "endTask";
	public static final String PROPERTY_NAME_RESCHEDULE_TASK = "reScheduleTask";
	public static final String PROPERTY_NAME_SHUTDOWN_TASK = "shutdownTask";
	public static final String PROPERTY_NAME_EXECUTED = "executed";
	public static final String PROPERTY_NAME_THREADPOOL = "threadPool";
	public static final String PROPERTY_NAME_THREAD_POOL_TYPE = "threadPoolType";
	public static final String PROPERTY_NAME_THREAD_POOL_SIZE = "threadPoolSize";
	public static final String PROPERTY_NAME_EXCEPTION = "exception";

	public static final String METHOD_NAME_IS_START_TASK = "isStartTask";
	public static final String METHOD_NAME_IS_END_TASK = "isEndTask";
	public static final String METHOD_NAME_IS_RE_SCHEDULE_TASK = "isReScheduleTask";
	public static final String METHOD_NAME_IS_SHUTDOWN_TASK = "isShutdownTask";
	public static final String METHOD_NAME_GET_TASK_NAME = "getTaskName";
	public static final String METHOD_NAME_GET_THREAD_POOL_TYPE = "getThreadPoolType";
	public static final String METHOD_NAME_GET_THREAD_POOL_SIZE = "getThreadPoolSize";
	public static final String METHOD_NAME_GET_TRIGGER = "getTrigger";
	public static final String METHOD_NAME_IS_EXECUTED = "isExecuted";

	public static final String METHOD_NAME_SET_TASK_NAME = "setTaskName";
	public static final String METHOD_NAME_SET_RE_SCHEDULE_TASK = "setReScheduleTask";
	public static final String METHOD_NAME_SET_SHUTDOWN_TASK = "setShutdownTask";
	public static final String METHOD_NAME_SET_THREAD_POOL_TYPE = "setThreadPoolType";
	public static final String METHOD_NAME_SET_THREAD_POOL_SIZE = "setThreadPoolSize";
	public static final String METHOD_NAME_SET_START_TASK = "setStartTask";
	public static final String METHOD_NAME_SET_END_TASK = "setEndTask";
	public static final String METHOD_NAME_SET_TRIGGER = "setTrigger";
	public static final String METHOD_NAME_SET_EXECUTED = "setExecuted";

}
