/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.util;

import java.io.File;

import javax.servlet.ServletContext;

import org.seasar.framework.container.SingletonS2Container;

public class ResourceUtil {
    public static String getDbPath(String name) {
        return getBasePath("WEB-INF/db/", name);
    }

    public static String getConfPath(String name) {
        return getBasePath("WEB-INF/conf/", name);
    }

    public static String getClassesPath(String name) {
        return getBasePath("WEB-INF/classes/", name);
    }

    protected static String getBasePath(String baseName, String name) {

        String path = null;
        try {
            ServletContext servletContext = SingletonS2Container
                    .getComponent(ServletContext.class);
            if (servletContext != null) {
                path = servletContext.getRealPath("/" + baseName + name);
            }
        } catch (Exception e) {
        }
        if (path == null) {
            path = new File(baseName + name).getAbsolutePath();
        }
        return path;
    }
}
