/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.crud.CommonConstants;
import jp.sf.fess.db.exbhv.ClickLogBhv;
import jp.sf.fess.db.exbhv.SearchLogBhv;
import jp.sf.fess.db.exbhv.pmbean.ClickUrlRankingPmb;
import jp.sf.fess.db.exbhv.pmbean.ClientIpRankingPmb;
import jp.sf.fess.db.exbhv.pmbean.RefererRankingPmb;
import jp.sf.fess.db.exbhv.pmbean.SearchQueryRankingPmb;
import jp.sf.fess.db.exbhv.pmbean.SearchWordRankingPmb;
import jp.sf.fess.db.exbhv.pmbean.SolrQueryRankingPmb;
import jp.sf.fess.db.exbhv.pmbean.UserAgentRankingPmb;
import jp.sf.fess.db.exentity.customize.ClickUrlRanking;
import jp.sf.fess.db.exentity.customize.ClientIpRanking;
import jp.sf.fess.db.exentity.customize.RefererRanking;
import jp.sf.fess.db.exentity.customize.SearchQueryRanking;
import jp.sf.fess.db.exentity.customize.SearchWordRanking;
import jp.sf.fess.db.exentity.customize.SolrQueryRanking;
import jp.sf.fess.db.exentity.customize.UserAgentRanking;
import jp.sf.fess.pager.StatsPager;

import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.framework.beans.util.Beans;

public class StatsService implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected SearchLogBhv searchLogBhv;

    @Resource
    protected ClickLogBhv clicklogBhv;

    public List<Map<String, Object>> getStatsList(StatsPager statsPager) {
        if ("searchWord".equals(statsPager.reportType)) {
            return getSearchWordStatsList(statsPager);
        } else if ("searchQuery".equals(statsPager.reportType)) {
            return getSearchQueryStatsList(statsPager);
        } else if ("solrQuery".equals(statsPager.reportType)) {
            return getSolrQueryStatsList(statsPager);
        } else if ("userAgent".equals(statsPager.reportType)) {
            return getUserAgentStatsList(statsPager);
        } else if ("referer".equals(statsPager.reportType)) {
            return getRefererStatsList(statsPager);
        } else if ("clientIp".equals(statsPager.reportType)) {
            return getClientIpStatsList(statsPager);
        } else if ("clickUrl".equals(statsPager.reportType)) {
            return getClickUrlStatsList(statsPager);
        } else {
            return getSearchWordStatsList(statsPager);
        }
    }

    protected List<Map<String, Object>> getSearchWordStatsList(
            StatsPager statsPager) {

        SearchWordRankingPmb pmb = new SearchWordRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = SearchLogBhv.PATH_selectSearchWordRanking;
        PagingResultBean<SearchWordRanking> statsList = searchLogBhv
                .outsideSql().autoPaging()
                .selectPage(path, pmb, SearchWordRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (SearchWordRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }

    protected List<Map<String, Object>> getSearchQueryStatsList(
            StatsPager statsPager) {

        SearchQueryRankingPmb pmb = new SearchQueryRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = SearchLogBhv.PATH_selectSearchQueryRanking;
        PagingResultBean<SearchQueryRanking> statsList = searchLogBhv
                .outsideSql().autoPaging()
                .selectPage(path, pmb, SearchQueryRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (SearchQueryRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }

    protected List<Map<String, Object>> getSolrQueryStatsList(
            StatsPager statsPager) {

        SolrQueryRankingPmb pmb = new SolrQueryRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = SearchLogBhv.PATH_selectSolrQueryRanking;
        PagingResultBean<SolrQueryRanking> statsList = searchLogBhv
                .outsideSql().autoPaging()
                .selectPage(path, pmb, SolrQueryRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (SolrQueryRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }

    protected List<Map<String, Object>> getUserAgentStatsList(
            StatsPager statsPager) {

        UserAgentRankingPmb pmb = new UserAgentRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = SearchLogBhv.PATH_selectUserAgentRanking;
        PagingResultBean<UserAgentRanking> statsList = searchLogBhv
                .outsideSql().autoPaging()
                .selectPage(path, pmb, UserAgentRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (UserAgentRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }

    protected List<Map<String, Object>> getRefererStatsList(
            StatsPager statsPager) {

        RefererRankingPmb pmb = new RefererRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = SearchLogBhv.PATH_selectRefererRanking;
        PagingResultBean<RefererRanking> statsList = searchLogBhv.outsideSql()
                .autoPaging().selectPage(path, pmb, RefererRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (RefererRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }

    protected List<Map<String, Object>> getClientIpStatsList(
            StatsPager statsPager) {

        ClientIpRankingPmb pmb = new ClientIpRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = SearchLogBhv.PATH_selectClientIpRanking;
        PagingResultBean<ClientIpRanking> statsList = searchLogBhv.outsideSql()
                .autoPaging().selectPage(path, pmb, ClientIpRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (ClientIpRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }

    protected List<Map<String, Object>> getClickUrlStatsList(
            StatsPager statsPager) {

        ClickUrlRankingPmb pmb = new ClickUrlRankingPmb();

        pmb.fetchFirst(statsPager.getPageSize());
        pmb.fetchPage(statsPager.getCurrentPageNumber());

        pmb.setFromRequestedTime_FromDate(statsPager.getFromRequestedTime());
        pmb.setToRequestedTime_ToDate(statsPager.getToRequestedTime());

        String path = ClickLogBhv.PATH_selectClickUrlRanking;
        PagingResultBean<ClickUrlRanking> statsList = clicklogBhv.outsideSql()
                .autoPaging().selectPage(path, pmb, ClickUrlRanking.class);

        // update pager
        Beans.copy(statsList, statsPager)
                .includes(CommonConstants.PAGER_CONVERSION_RULE).execute();
        statsList.setPageRangeSize(5);
        statsPager.setPageNumberList(statsList.pageRange()
                .createPageNumberList());

        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (ClickUrlRanking entity : statsList) {
            Map<String, Object> map = new HashMap<String, Object>();
            Beans.copy(entity, map).execute();
            mapList.add(map);
        }

        return mapList;
    }
}
