/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.service.BsDataCrawlingConfigService;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.pager.DataCrawlingConfigPager;

import org.seasar.dbflute.bhv.ConditionBeanSetupper;

public class DataCrawlingConfigService extends BsDataCrawlingConfigService
        implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected DataConfigToBrowserTypeMappingBhv dataConfigToBrowserTypeMappingBhv;

    @Resource
    protected DataConfigToRoleTypeMappingBhv dataConfigToRoleTypeMappingBhv;

    @Resource
    protected DataConfigToLabelTypeMappingBhv dataConfigToLabelTypeMappingBhv;

    public List<DataCrawlingConfig> getAllDataCrawlingConfigList() {
        return getAllDataCrawlingConfigList(true, true, true);
    }

    public List<DataCrawlingConfig> getAllDataCrawlingConfigList(
            boolean withBrowserType, boolean withLabelType, boolean withRoleType) {
        DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
        cb.query().setDeletedBy_IsNull();
        cb.query().setAvailable_Equal(Constants.T);
        List<DataCrawlingConfig> list = dataCrawlingConfigBhv.selectList(cb);
        if (withBrowserType) {
            final ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> setupper1 = new ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB>() {
                public void setup(DataConfigToBrowserTypeMappingCB cb) {
                    cb.setupSelect_BrowserType();
                    cb.query().queryBrowserType().setDeletedBy_IsNull();
                    cb.query().queryBrowserType().addOrderBy_SortOrder_Asc();
                }

            };
            dataCrawlingConfigBhv.loadDataConfigToBrowserTypeMappingList(list,
                    setupper1);
        }
        if (withBrowserType) {
            final ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> setupper2 = new ConditionBeanSetupper<DataConfigToRoleTypeMappingCB>() {
                public void setup(DataConfigToRoleTypeMappingCB cb) {
                    cb.setupSelect_RoleType();
                    cb.query().queryRoleType().setDeletedBy_IsNull();
                    cb.query().queryRoleType().addOrderBy_SortOrder_Asc();
                }

            };
            dataCrawlingConfigBhv.loadDataConfigToRoleTypeMappingList(list,
                    setupper2);
        }
        if (withRoleType) {
            final ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> setupper3 = new ConditionBeanSetupper<DataConfigToLabelTypeMappingCB>() {
                public void setup(DataConfigToLabelTypeMappingCB cb) {
                    cb.setupSelect_LabelType();
                    cb.query().queryLabelType().setDeletedBy_IsNull();
                    cb.query().queryLabelType().addOrderBy_SortOrder_Asc();
                }

            };
            dataCrawlingConfigBhv.loadDataConfigToLabelTypeMappingList(list,
                    setupper3);
        }
        return list;
    }

    public DataCrawlingConfig getDataCrawlingConfig(Map<String, String> keys) {
        DataCrawlingConfig dataCrawlingConfig = super
                .getDataCrawlingConfig(keys);

        if (dataCrawlingConfig != null) {
            DataConfigToBrowserTypeMappingCB fctbtmCb = new DataConfigToBrowserTypeMappingCB();
            fctbtmCb.query().setDataConfigId_Equal(dataCrawlingConfig.getId());
            fctbtmCb.query().queryBrowserType().setDeletedBy_IsNull();
            fctbtmCb.query().queryDataCrawlingConfig().setDeletedBy_IsNull();
            List<DataConfigToBrowserTypeMapping> fctbtmList = dataConfigToBrowserTypeMappingBhv
                    .selectList(fctbtmCb);
            if (!fctbtmList.isEmpty()) {
                List<String> browserTypeIds = new ArrayList<String>(
                        fctbtmList.size());
                for (DataConfigToBrowserTypeMapping mapping : fctbtmList) {
                    browserTypeIds
                            .add(Long.toString(mapping.getBrowserTypeId()));
                }
                dataCrawlingConfig.setBrowserTypeIds(browserTypeIds
                        .toArray(new String[browserTypeIds.size()]));
            }

            DataConfigToRoleTypeMappingCB fctrtmCb = new DataConfigToRoleTypeMappingCB();
            fctrtmCb.query().setDataConfigId_Equal(dataCrawlingConfig.getId());
            fctrtmCb.query().queryRoleType().setDeletedBy_IsNull();
            fctrtmCb.query().queryDataCrawlingConfig().setDeletedBy_IsNull();
            List<DataConfigToRoleTypeMapping> fctrtmList = dataConfigToRoleTypeMappingBhv
                    .selectList(fctrtmCb);
            if (!fctrtmList.isEmpty()) {
                List<String> roleTypeIds = new ArrayList<String>(
                        fctrtmList.size());
                for (DataConfigToRoleTypeMapping mapping : fctrtmList) {
                    roleTypeIds.add(Long.toString(mapping.getRoleTypeId()));
                }
                dataCrawlingConfig.setRoleTypeIds(roleTypeIds
                        .toArray(new String[roleTypeIds.size()]));
            }

            DataConfigToLabelTypeMappingCB fctltmCb = new DataConfigToLabelTypeMappingCB();
            fctltmCb.query().setDataConfigId_Equal(dataCrawlingConfig.getId());
            fctltmCb.query().queryLabelType().setDeletedBy_IsNull();
            fctltmCb.query().queryDataCrawlingConfig().setDeletedBy_IsNull();
            List<DataConfigToLabelTypeMapping> fctltmList = dataConfigToLabelTypeMappingBhv
                    .selectList(fctltmCb);
            if (!fctltmList.isEmpty()) {
                List<String> labelTypeIds = new ArrayList<String>(
                        fctltmList.size());
                for (DataConfigToLabelTypeMapping mapping : fctltmList) {
                    labelTypeIds.add(Long.toString(mapping.getLabelTypeId()));
                }
                dataCrawlingConfig.setLabelTypeIds(labelTypeIds
                        .toArray(new String[labelTypeIds.size()]));
            }

        }

        return dataCrawlingConfig;
    }

    public void store(DataCrawlingConfig dataCrawlingConfig)
            throws CrudMessageException {
        boolean isNew = dataCrawlingConfig.getId() == null;
        String[] browserTypeIds = dataCrawlingConfig.getBrowserTypeIds();
        String[] labelTypeIds = dataCrawlingConfig.getLabelTypeIds();
        String[] roleTypeIds = dataCrawlingConfig.getRoleTypeIds();
        super.store(dataCrawlingConfig);
        Long DataConfigId = dataCrawlingConfig.getId();
        if (isNew) {
            // Insert
            if (browserTypeIds != null) {
                List<DataConfigToBrowserTypeMapping> fctbtmList = new ArrayList<DataConfigToBrowserTypeMapping>();
                for (String browserTypeId : browserTypeIds) {
                    DataConfigToBrowserTypeMapping mapping = new DataConfigToBrowserTypeMapping();
                    mapping.setDataConfigId(DataConfigId);
                    mapping.setBrowserTypeId(Long.parseLong(browserTypeId));
                    fctbtmList.add(mapping);
                }
                dataConfigToBrowserTypeMappingBhv.batchInsert(fctbtmList);
            }
            if (labelTypeIds != null) {
                List<DataConfigToLabelTypeMapping> fctltmList = new ArrayList<DataConfigToLabelTypeMapping>();
                for (String labelTypeId : labelTypeIds) {
                    DataConfigToLabelTypeMapping mapping = new DataConfigToLabelTypeMapping();
                    mapping.setDataConfigId(DataConfigId);
                    mapping.setLabelTypeId(Long.parseLong(labelTypeId));
                    fctltmList.add(mapping);
                }
                dataConfigToLabelTypeMappingBhv.batchInsert(fctltmList);
            }
            if (roleTypeIds != null) {
                List<DataConfigToRoleTypeMapping> fctrtmList = new ArrayList<DataConfigToRoleTypeMapping>();
                for (String roleTypeId : roleTypeIds) {
                    DataConfigToRoleTypeMapping mapping = new DataConfigToRoleTypeMapping();
                    mapping.setDataConfigId(DataConfigId);
                    mapping.setRoleTypeId(Long.parseLong(roleTypeId));
                    fctrtmList.add(mapping);
                }
                dataConfigToRoleTypeMappingBhv.batchInsert(fctrtmList);
            }
        } else {
            // Update
            if (browserTypeIds != null) {
                DataConfigToBrowserTypeMappingCB fctbtmCb = new DataConfigToBrowserTypeMappingCB();
                fctbtmCb.query().setDataConfigId_Equal(DataConfigId);
                List<DataConfigToBrowserTypeMapping> fctbtmList = dataConfigToBrowserTypeMappingBhv
                        .selectList(fctbtmCb);
                List<DataConfigToBrowserTypeMapping> newList = new ArrayList<DataConfigToBrowserTypeMapping>();
                List<DataConfigToBrowserTypeMapping> matchedList = new ArrayList<DataConfigToBrowserTypeMapping>();
                for (String id : browserTypeIds) {
                    Long browserTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (DataConfigToBrowserTypeMapping mapping : fctbtmList) {
                        if (mapping.getBrowserTypeId().equals(browserTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        DataConfigToBrowserTypeMapping mapping = new DataConfigToBrowserTypeMapping();
                        mapping.setDataConfigId(DataConfigId);
                        mapping.setBrowserTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                fctbtmList.removeAll(matchedList);
                dataConfigToBrowserTypeMappingBhv.batchInsert(newList);
                dataConfigToBrowserTypeMappingBhv.batchDelete(fctbtmList);
            }
            if (labelTypeIds != null) {
                DataConfigToLabelTypeMappingCB fctltmCb = new DataConfigToLabelTypeMappingCB();
                fctltmCb.query().setDataConfigId_Equal(DataConfigId);
                List<DataConfigToLabelTypeMapping> fctltmList = dataConfigToLabelTypeMappingBhv
                        .selectList(fctltmCb);
                List<DataConfigToLabelTypeMapping> newList = new ArrayList<DataConfigToLabelTypeMapping>();
                List<DataConfigToLabelTypeMapping> matchedList = new ArrayList<DataConfigToLabelTypeMapping>();
                for (String id : labelTypeIds) {
                    Long labelTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (DataConfigToLabelTypeMapping mapping : fctltmList) {
                        if (mapping.getLabelTypeId().equals(labelTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        DataConfigToLabelTypeMapping mapping = new DataConfigToLabelTypeMapping();
                        mapping.setDataConfigId(DataConfigId);
                        mapping.setLabelTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                fctltmList.removeAll(matchedList);
                dataConfigToLabelTypeMappingBhv.batchInsert(newList);
                dataConfigToLabelTypeMappingBhv.batchDelete(fctltmList);
            }
            if (roleTypeIds != null) {
                DataConfigToRoleTypeMappingCB fctrtmCb = new DataConfigToRoleTypeMappingCB();
                fctrtmCb.query().setDataConfigId_Equal(DataConfigId);
                List<DataConfigToRoleTypeMapping> fctrtmList = dataConfigToRoleTypeMappingBhv
                        .selectList(fctrtmCb);
                List<DataConfigToRoleTypeMapping> newList = new ArrayList<DataConfigToRoleTypeMapping>();
                List<DataConfigToRoleTypeMapping> matchedList = new ArrayList<DataConfigToRoleTypeMapping>();
                for (String id : roleTypeIds) {
                    Long roleTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (DataConfigToRoleTypeMapping mapping : fctrtmList) {
                        if (mapping.getRoleTypeId().equals(roleTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        DataConfigToRoleTypeMapping mapping = new DataConfigToRoleTypeMapping();
                        mapping.setDataConfigId(DataConfigId);
                        mapping.setRoleTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                fctrtmList.removeAll(matchedList);
                dataConfigToRoleTypeMappingBhv.batchInsert(newList);
                dataConfigToRoleTypeMappingBhv.batchDelete(fctrtmList);
            }
        }
    }

    protected void setupListCondition(DataCrawlingConfigCB cb,
            DataCrawlingConfigPager dataCrawlingConfigPager) {
        super.setupListCondition(cb, dataCrawlingConfigPager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();

        // search

    }

    protected void setupEntityCondition(DataCrawlingConfigCB cb,
            Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(DataCrawlingConfig dataCrawlingConfig) {
        super.setupStoreCondition(dataCrawlingConfig);

        // setup condition

    }

    protected void setupDeleteCondition(DataCrawlingConfig dataCrawlingConfig) {
        super.setupDeleteCondition(dataCrawlingConfig);

        // setup condition

    }

}
