/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.ciq;

import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.bs.AbstractBsCrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.bs.BsCrawlingSessionCQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The condition-query for in-line of CRAWLING_SESSION.
 * @author DBFlute(AutoGenerator)
 */
public class CrawlingSessionCIQ extends AbstractBsCrawlingSessionCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected BsCrawlingSessionCQ _myCQ;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public CrawlingSessionCIQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel, BsCrawlingSessionCQ myCQ) {
        super(childQuery, sqlClause, aliasName, nestLevel);
        _myCQ = myCQ;
        _foreignPropertyName = _myCQ.getForeignPropertyName(); // accept foreign property name
        _relationPath = _myCQ.getRelationPath(); // accept relation path
    }

    // ===================================================================================
    //                                                             Override about Register
    //                                                             =======================
    @Override
    protected void reflectRelationOnUnionQuery(ConditionQuery bq,
            ConditionQuery uq) {
        String msg = "InlineView must not need UNION method: " + bq + " : "
                + uq;
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col) {
        regIQ(k, v, cv, col);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col, ConditionOption op) {
        regIQ(k, v, cv, col, op);
    }

    @Override
    protected void registerWhereClause(String wc) {
        registerInlineWhereClause(wc);
    }

    @Override
    protected boolean isInScopeRelationSuppressLocalAliasName() {
        if (_onClauseInline) {
            throw new IllegalConditionBeanOperationException(
                    "InScopeRelation on OnClause is unsupported.");
        }
        return true;
    }

    // ===================================================================================
    //                                                                Override about Query
    //                                                                ====================
    protected ConditionValue getCValueId() {
        return _myCQ.getId();
    }

    public String keepId_ExistsReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ sq) {
        throwIICBOE("ExistsReferrer");
        return null;
    }

    public String keepId_NotExistsReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ sq) {
        throwIICBOE("NotExistsReferrer");
        return null;
    }

    public String keepId_InScopeRelation_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ sq) {
        return _myCQ.keepId_InScopeRelation_CrawlingSessionInfoList(sq);
    }

    public String keepId_NotInScopeRelation_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ sq) {
        return _myCQ.keepId_NotInScopeRelation_CrawlingSessionInfoList(sq);
    }

    public String keepId_SpecifyDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ sq) {
        throwIICBOE("(Specify)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ sq) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    public String keepId_QueryDerivedReferrer_CrawlingSessionInfoListParameter(
            Object pv) {
        throwIICBOE("(Query)DerivedReferrer");
        return null;
    }

    protected ConditionValue getCValueSessionId() {
        return _myCQ.getSessionId();
    }

    protected ConditionValue getCValueCreatedTime() {
        return _myCQ.getCreatedTime();
    }

    public String keepScalarCondition(CrawlingSessionCQ subQuery) {
        throwIICBOE("ScalarCondition");
        return null;
    }

    public String keepMyselfInScopeRelation(CrawlingSessionCQ subQuery) {
        throwIICBOE("MyselfInScopeRelation");
        return null;
    }

    protected void throwIICBOE(String name) { // throwInlineIllegalConditionBeanOperationException()
        throw new IllegalConditionBeanOperationException(name
                + " at InlineView is unsupported.");
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xinCB() {
        return CrawlingSessionCB.class.getName();
    }

    protected String xinCQ() {
        return CrawlingSessionCQ.class.getName();
    }
}
