/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.cq.DataConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.RoleTypeCQ;
import jp.sf.fess.db.cbean.cq.ciq.DataConfigToRoleTypeMappingCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The base condition-query of DATA_CONFIG_TO_ROLE_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public class BsDataConfigToRoleTypeMappingCQ extends
        AbstractBsDataConfigToRoleTypeMappingCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected DataConfigToRoleTypeMappingCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsDataConfigToRoleTypeMappingCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare InlineView query. <br />
     * {select ... from ... left outer join (select * from DATA_CONFIG_TO_ROLE_TYPE_MAPPING) where FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">inline()</span>.setFoo...;
     * </pre>
     * @return The condition-query for InlineView query. (NotNull)
     */
    public DataConfigToRoleTypeMappingCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = createInlineQuery();
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    protected DataConfigToRoleTypeMappingCIQ createInlineQuery() {
        return new DataConfigToRoleTypeMappingCIQ(getReferrerQuery(),
                getSqlClause(), getAliasName(), getNestLevel(), this);
    }

    /**
     * Prepare OnClause query. <br />
     * {select ... from ... left outer join DATA_CONFIG_TO_ROLE_TYPE_MAPPING on ... and FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">on()</span>.setFoo...;
     * </pre>
     * @return The condition-query for OnClause query. (NotNull)
     * @throws IllegalConditionBeanOperationException When this condition-query is base query.
     */
    public DataConfigToRoleTypeMappingCIQ on() {
        if (isBaseQuery()) {
            throw new IllegalConditionBeanOperationException(
                    "OnClause for local table is unavailable!");
        }
        DataConfigToRoleTypeMappingCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _dataConfigId;

    public ConditionValue getDataConfigId() {
        if (_dataConfigId == null) {
            _dataConfigId = nCV();
        }
        return _dataConfigId;
    }

    protected ConditionValue getCValueDataConfigId() {
        return getDataConfigId();
    }

    protected Map<String, DataCrawlingConfigCQ> _dataConfigId_InScopeRelation_DataCrawlingConfigMap;

    public Map<String, DataCrawlingConfigCQ> getDataConfigId_InScopeRelation_DataCrawlingConfig() {
        return _dataConfigId_InScopeRelation_DataCrawlingConfigMap;
    }

    public String keepDataConfigId_InScopeRelation_DataCrawlingConfig(
            DataCrawlingConfigCQ subQuery) {
        if (_dataConfigId_InScopeRelation_DataCrawlingConfigMap == null) {
            _dataConfigId_InScopeRelation_DataCrawlingConfigMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_dataConfigId_InScopeRelation_DataCrawlingConfigMap.size() + 1);
        _dataConfigId_InScopeRelation_DataCrawlingConfigMap.put(key, subQuery);
        return "dataConfigId_InScopeRelation_DataCrawlingConfig." + key;
    }

    protected Map<String, DataCrawlingConfigCQ> _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap;

    public Map<String, DataCrawlingConfigCQ> getDataConfigId_NotInScopeRelation_DataCrawlingConfig() {
        return _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap;
    }

    public String keepDataConfigId_NotInScopeRelation_DataCrawlingConfig(
            DataCrawlingConfigCQ subQuery) {
        if (_dataConfigId_NotInScopeRelation_DataCrawlingConfigMap == null) {
            _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_dataConfigId_NotInScopeRelation_DataCrawlingConfigMap
                        .size() + 1);
        _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap.put(key,
                subQuery);
        return "dataConfigId_NotInScopeRelation_DataCrawlingConfig." + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addOrderBy_DataConfigId_Asc() {
        regOBA("DATA_CONFIG_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addOrderBy_DataConfigId_Desc() {
        regOBD("DATA_CONFIG_ID");
        return this;
    }

    protected ConditionValue _roleTypeId;

    public ConditionValue getRoleTypeId() {
        if (_roleTypeId == null) {
            _roleTypeId = nCV();
        }
        return _roleTypeId;
    }

    protected ConditionValue getCValueRoleTypeId() {
        return getRoleTypeId();
    }

    protected Map<String, RoleTypeCQ> _roleTypeId_InScopeRelation_RoleTypeMap;

    public Map<String, RoleTypeCQ> getRoleTypeId_InScopeRelation_RoleType() {
        return _roleTypeId_InScopeRelation_RoleTypeMap;
    }

    public String keepRoleTypeId_InScopeRelation_RoleType(RoleTypeCQ subQuery) {
        if (_roleTypeId_InScopeRelation_RoleTypeMap == null) {
            _roleTypeId_InScopeRelation_RoleTypeMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_roleTypeId_InScopeRelation_RoleTypeMap.size() + 1);
        _roleTypeId_InScopeRelation_RoleTypeMap.put(key, subQuery);
        return "roleTypeId_InScopeRelation_RoleType." + key;
    }

    protected Map<String, RoleTypeCQ> _roleTypeId_NotInScopeRelation_RoleTypeMap;

    public Map<String, RoleTypeCQ> getRoleTypeId_NotInScopeRelation_RoleType() {
        return _roleTypeId_NotInScopeRelation_RoleTypeMap;
    }

    public String keepRoleTypeId_NotInScopeRelation_RoleType(RoleTypeCQ subQuery) {
        if (_roleTypeId_NotInScopeRelation_RoleTypeMap == null) {
            _roleTypeId_NotInScopeRelation_RoleTypeMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_roleTypeId_NotInScopeRelation_RoleTypeMap.size() + 1);
        _roleTypeId_NotInScopeRelation_RoleTypeMap.put(key, subQuery);
        return "roleTypeId_NotInScopeRelation_RoleType." + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addOrderBy_RoleTypeId_Asc() {
        regOBA("ROLE_TYPE_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addOrderBy_RoleTypeId_Desc() {
        regOBD("ROLE_TYPE_ID");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    /**
     * Add order-by for specified derived column as ascend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] asc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Asc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    /**
     * Add order-by for specified derived column as descend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] desc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Desc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsDataConfigToRoleTypeMappingCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        DataConfigToRoleTypeMappingCQ baseQuery = (DataConfigToRoleTypeMappingCQ) baseQueryAsSuper;
        DataConfigToRoleTypeMappingCQ unionQuery = (DataConfigToRoleTypeMappingCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryDataCrawlingConfig()) {
            unionQuery.queryDataCrawlingConfig().reflectRelationOnUnionQuery(
                    baseQuery.queryDataCrawlingConfig(),
                    unionQuery.queryDataCrawlingConfig());
        }
        if (baseQuery.hasConditionQueryRoleType()) {
            unionQuery.queryRoleType().reflectRelationOnUnionQuery(
                    baseQuery.queryRoleType(), unionQuery.queryRoleType());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    /**
     * Get the condition-query for relation table. <br />
     * DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'.
     * @return The instance of condition-query. (NotNull)
     */
    public DataCrawlingConfigCQ queryDataCrawlingConfig() {
        return getConditionQueryDataCrawlingConfig();
    }

    protected DataCrawlingConfigCQ _conditionQueryDataCrawlingConfig;

    public DataCrawlingConfigCQ getConditionQueryDataCrawlingConfig() {
        if (_conditionQueryDataCrawlingConfig == null) {
            _conditionQueryDataCrawlingConfig = xcreateQueryDataCrawlingConfig();
            xsetupOuterJoinDataCrawlingConfig();
        }
        return _conditionQueryDataCrawlingConfig;
    }

    protected DataCrawlingConfigCQ xcreateQueryDataCrawlingConfig() {
        String nrp = resolveNextRelationPath(
                "DATA_CONFIG_TO_ROLE_TYPE_MAPPING", "dataCrawlingConfig");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        DataCrawlingConfigCQ cq = new DataCrawlingConfigCQ(this,
                getSqlClause(), jan, getNextNestLevel());
        cq.xsetForeignPropertyName("dataCrawlingConfig");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinDataCrawlingConfig() {
        DataCrawlingConfigCQ cq = getConditionQueryDataCrawlingConfig();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put("DATA_CONFIG_ID", "ID");
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryDataCrawlingConfig() {
        return _conditionQueryDataCrawlingConfig != null;
    }

    /**
     * Get the condition-query for relation table. <br />
     * ROLE_TYPE as 'roleType'.
     * @return The instance of condition-query. (NotNull)
     */
    public RoleTypeCQ queryRoleType() {
        return getConditionQueryRoleType();
    }

    protected RoleTypeCQ _conditionQueryRoleType;

    public RoleTypeCQ getConditionQueryRoleType() {
        if (_conditionQueryRoleType == null) {
            _conditionQueryRoleType = xcreateQueryRoleType();
            xsetupOuterJoinRoleType();
        }
        return _conditionQueryRoleType;
    }

    protected RoleTypeCQ xcreateQueryRoleType() {
        String nrp = resolveNextRelationPath(
                "DATA_CONFIG_TO_ROLE_TYPE_MAPPING", "roleType");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        RoleTypeCQ cq = new RoleTypeCQ(this, getSqlClause(), jan,
                getNextNestLevel());
        cq.xsetForeignPropertyName("roleType");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinRoleType() {
        RoleTypeCQ cq = getConditionQueryRoleType();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put("ROLE_TYPE_ID", "ID");
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryRoleType() {
        return _conditionQueryRoleType != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, DataConfigToRoleTypeMappingCQ> _scalarConditionMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getScalarCondition() {
        return _scalarConditionMap;
    }

    public String keepScalarCondition(DataConfigToRoleTypeMappingCQ subQuery) {
        if (_scalarConditionMap == null) {
            _scalarConditionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarConditionMap.size() + 1);
        _scalarConditionMap.put(key, subQuery);
        return "scalarCondition." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, DataConfigToRoleTypeMappingCQ> _myselfInScopeRelationMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getMyselfInScopeRelation() {
        return _myselfInScopeRelationMap;
    }

    public String keepMyselfInScopeRelation(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_myselfInScopeRelationMap == null) {
            _myselfInScopeRelationMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeRelationMap.size() + 1);
        _myselfInScopeRelationMap.put(key, subQuery);
        return "myselfInScopeRelation." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xCB() {
        return DataConfigToRoleTypeMappingCB.class.getName();
    }

    protected String xCQ() {
        return DataConfigToRoleTypeMappingCQ.class.getName();
    }

    protected String xMap() {
        return Map.class.getName();
    }
}
