/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.FileAuthentication;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of FILE_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, PATHS, INCLUDED_PATHS, EXCLUDED_PATHS, INCLUDED_DOC_PATHS, EXCLUDED_DOC_PATHS, DEPTH, MAX_ACCESS_COUNT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, FILE_AUTHENTICATION, FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_LABEL_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, fileAuthenticationList, fileConfigToBrowserTypeMappingList, fileConfigToLabelTypeMappingList, fileConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileCrawlingConfig implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** NAME: {NotNull, VARCHAR(200)} */
    protected String _name;

    /** PATHS: {NotNull, VARCHAR(4000)} */
    protected String _paths;

    /** INCLUDED_PATHS: {VARCHAR(4000)} */
    protected String _includedPaths;

    /** EXCLUDED_PATHS: {VARCHAR(4000)} */
    protected String _excludedPaths;

    /** INCLUDED_DOC_PATHS: {VARCHAR(4000)} */
    protected String _includedDocPaths;

    /** EXCLUDED_DOC_PATHS: {VARCHAR(4000)} */
    protected String _excludedDocPaths;

    /** DEPTH: {INTEGER(10)} */
    protected Integer _depth;

    /** MAX_ACCESS_COUNT: {BIGINT(19)} */
    protected Long _maxAccessCount;

    /** NUM_OF_THREAD: {NotNull, INTEGER(10)} */
    protected Integer _numOfThread;

    /** INTERVAL_TIME: {NotNull, INTEGER(10)} */
    protected Integer _intervalTime;

    /** BOOST: {NotNull, DOUBLE(17)} */
    protected java.math.BigDecimal _boost;

    /** AVAILABLE: {NotNull, VARCHAR(1)} */
    protected String _available;

    /** SORT_ORDER: {NotNull, INTEGER(10)} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull, VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull, INTEGER(10)} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    public String getTableDbName() {
        return "FILE_CRAWLING_CONFIG";
    }

    /**
     * {@inheritDoc}
     */
    public String getTablePropertyName() { // according to Java Beans rule
        return "fileCrawlingConfig";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** FAILURE_URL as 'failureUrlList'. */
    protected List<FailureUrl> _failureUrlList;

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @return The entity list of referrer property 'failureUrlList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FailureUrl> getFailureUrlList() {
        if (_failureUrlList == null) {
            _failureUrlList = new ArrayList<FailureUrl>();
        }
        return _failureUrlList;
    }

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @param failureUrlList The entity list of referrer property 'failureUrlList'. (Nullable)
     */
    public void setFailureUrlList(List<FailureUrl> failureUrlList) {
        _failureUrlList = failureUrlList;
    }

    /** FILE_AUTHENTICATION as 'fileAuthenticationList'. */
    protected List<FileAuthentication> _fileAuthenticationList;

    /**
     * FILE_AUTHENTICATION as 'fileAuthenticationList'.
     * @return The entity list of referrer property 'fileAuthenticationList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileAuthentication> getFileAuthenticationList() {
        if (_fileAuthenticationList == null) {
            _fileAuthenticationList = new ArrayList<FileAuthentication>();
        }
        return _fileAuthenticationList;
    }

    /**
     * FILE_AUTHENTICATION as 'fileAuthenticationList'.
     * @param fileAuthenticationList The entity list of referrer property 'fileAuthenticationList'. (Nullable)
     */
    public void setFileAuthenticationList(
            List<FileAuthentication> fileAuthenticationList) {
        _fileAuthenticationList = fileAuthenticationList;
    }

    /** FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'. */
    protected List<FileConfigToBrowserTypeMapping> _fileConfigToBrowserTypeMappingList;

    /**
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'.
     * @return The entity list of referrer property 'fileConfigToBrowserTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToBrowserTypeMapping> getFileConfigToBrowserTypeMappingList() {
        if (_fileConfigToBrowserTypeMappingList == null) {
            _fileConfigToBrowserTypeMappingList = new ArrayList<FileConfigToBrowserTypeMapping>();
        }
        return _fileConfigToBrowserTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'.
     * @param fileConfigToBrowserTypeMappingList The entity list of referrer property 'fileConfigToBrowserTypeMappingList'. (Nullable)
     */
    public void setFileConfigToBrowserTypeMappingList(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        _fileConfigToBrowserTypeMappingList = fileConfigToBrowserTypeMappingList;
    }

    /** FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'. */
    protected List<FileConfigToLabelTypeMapping> _fileConfigToLabelTypeMappingList;

    /**
     * FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'.
     * @return The entity list of referrer property 'fileConfigToLabelTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToLabelTypeMapping> getFileConfigToLabelTypeMappingList() {
        if (_fileConfigToLabelTypeMappingList == null) {
            _fileConfigToLabelTypeMappingList = new ArrayList<FileConfigToLabelTypeMapping>();
        }
        return _fileConfigToLabelTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'.
     * @param fileConfigToLabelTypeMappingList The entity list of referrer property 'fileConfigToLabelTypeMappingList'. (Nullable)
     */
    public void setFileConfigToLabelTypeMappingList(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        _fileConfigToLabelTypeMappingList = fileConfigToLabelTypeMappingList;
    }

    /** FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'. */
    protected List<FileConfigToRoleTypeMapping> _fileConfigToRoleTypeMappingList;

    /**
     * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'.
     * @return The entity list of referrer property 'fileConfigToRoleTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToRoleTypeMapping> getFileConfigToRoleTypeMappingList() {
        if (_fileConfigToRoleTypeMappingList == null) {
            _fileConfigToRoleTypeMappingList = new ArrayList<FileConfigToRoleTypeMapping>();
        }
        return _fileConfigToRoleTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'.
     * @param fileConfigToRoleTypeMappingList The entity list of referrer property 'fileConfigToRoleTypeMappingList'. (Nullable)
     */
    public void setFileConfigToRoleTypeMappingList(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        _fileConfigToRoleTypeMappingList = fileConfigToRoleTypeMappingList;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    /**
     * {@inheritDoc}
     */
    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (Nullable)
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsFileCrawlingConfig)) {
            return false;
        }
        BsFileCrawlingConfig otherEntity = (BsFileCrawlingConfig) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(Object value1, Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    public int hashCode() {
        int result = 17;
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(int result, Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    public String toStringWithRelation() {
        StringBuilder sb = new StringBuilder();
        sb.append(toString());
        String l = "\n  ";
        if (_failureUrlList != null) {
            for (Entity e : _failureUrlList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "failureUrlList"));
                }
            }
        }
        if (_fileAuthenticationList != null) {
            for (Entity e : _fileAuthenticationList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "fileAuthenticationList"));
                }
            }
        }
        if (_fileConfigToBrowserTypeMappingList != null) {
            for (Entity e : _fileConfigToBrowserTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "fileConfigToBrowserTypeMappingList"));
                }
            }
        }
        if (_fileConfigToLabelTypeMappingList != null) {
            for (Entity e : _fileConfigToLabelTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "fileConfigToLabelTypeMappingList"));
                }
            }
        }
        if (_fileConfigToRoleTypeMappingList != null) {
            for (Entity e : _fileConfigToRoleTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "fileConfigToRoleTypeMappingList"));
                }
            }
        }
        return sb.toString();
    }

    protected String xbRDS(Entity e, String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (Nullable: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    public String buildDisplayString(String name, boolean column,
            boolean relation) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        String c = ", ";
        StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getName());
        sb.append(c).append(getPaths());
        sb.append(c).append(getIncludedPaths());
        sb.append(c).append(getExcludedPaths());
        sb.append(c).append(getIncludedDocPaths());
        sb.append(c).append(getExcludedDocPaths());
        sb.append(c).append(getDepth());
        sb.append(c).append(getMaxAccessCount());
        sb.append(c).append(getNumOfThread());
        sb.append(c).append(getIntervalTime());
        sb.append(c).append(getBoost());
        sb.append(c).append(getAvailable());
        sb.append(c).append(getSortOrder());
        sb.append(c).append(getCreatedBy());
        sb.append(c).append(getCreatedTime());
        sb.append(c).append(getUpdatedBy());
        sb.append(c).append(getUpdatedTime());
        sb.append(c).append(getDeletedBy());
        sb.append(c).append(getDeletedTime());
        sb.append(c).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        StringBuilder sb = new StringBuilder();
        String c = ",";
        if (_failureUrlList != null && !_failureUrlList.isEmpty()) {
            sb.append(c).append("failureUrlList");
        }
        if (_fileAuthenticationList != null
                && !_fileAuthenticationList.isEmpty()) {
            sb.append(c).append("fileAuthenticationList");
        }
        if (_fileConfigToBrowserTypeMappingList != null
                && !_fileConfigToBrowserTypeMappingList.isEmpty()) {
            sb.append(c).append("fileConfigToBrowserTypeMappingList");
        }
        if (_fileConfigToLabelTypeMappingList != null
                && !_fileConfigToLabelTypeMappingList.isEmpty()) {
            sb.append(c).append("fileConfigToLabelTypeMappingList");
        }
        if (_fileConfigToRoleTypeMappingList != null
                && !_fileConfigToRoleTypeMappingList.isEmpty()) {
            sb.append(c).append("fileConfigToRoleTypeMappingList");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * [get] NAME: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'NAME'. (Nullable)
     */
    public String getName() {
        return _name;
    }

    /**
     * [set] NAME: {NotNull, VARCHAR(200)} <br />
     * @param name The value of the column 'NAME'. (Nullable)
     */
    public void setName(String name) {
        _modifiedProperties.addPropertyName("name");
        this._name = name;
    }

    /**
     * [get] PATHS: {NotNull, VARCHAR(4000)} <br />
     * @return The value of the column 'PATHS'. (Nullable)
     */
    public String getPaths() {
        return _paths;
    }

    /**
     * [set] PATHS: {NotNull, VARCHAR(4000)} <br />
     * @param paths The value of the column 'PATHS'. (Nullable)
     */
    public void setPaths(String paths) {
        _modifiedProperties.addPropertyName("paths");
        this._paths = paths;
    }

    /**
     * [get] INCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_PATHS'. (Nullable)
     */
    public String getIncludedPaths() {
        return _includedPaths;
    }

    /**
     * [set] INCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @param includedPaths The value of the column 'INCLUDED_PATHS'. (Nullable)
     */
    public void setIncludedPaths(String includedPaths) {
        _modifiedProperties.addPropertyName("includedPaths");
        this._includedPaths = includedPaths;
    }

    /**
     * [get] EXCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_PATHS'. (Nullable)
     */
    public String getExcludedPaths() {
        return _excludedPaths;
    }

    /**
     * [set] EXCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @param excludedPaths The value of the column 'EXCLUDED_PATHS'. (Nullable)
     */
    public void setExcludedPaths(String excludedPaths) {
        _modifiedProperties.addPropertyName("excludedPaths");
        this._excludedPaths = excludedPaths;
    }

    /**
     * [get] INCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_DOC_PATHS'. (Nullable)
     */
    public String getIncludedDocPaths() {
        return _includedDocPaths;
    }

    /**
     * [set] INCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @param includedDocPaths The value of the column 'INCLUDED_DOC_PATHS'. (Nullable)
     */
    public void setIncludedDocPaths(String includedDocPaths) {
        _modifiedProperties.addPropertyName("includedDocPaths");
        this._includedDocPaths = includedDocPaths;
    }

    /**
     * [get] EXCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_DOC_PATHS'. (Nullable)
     */
    public String getExcludedDocPaths() {
        return _excludedDocPaths;
    }

    /**
     * [set] EXCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @param excludedDocPaths The value of the column 'EXCLUDED_DOC_PATHS'. (Nullable)
     */
    public void setExcludedDocPaths(String excludedDocPaths) {
        _modifiedProperties.addPropertyName("excludedDocPaths");
        this._excludedDocPaths = excludedDocPaths;
    }

    /**
     * [get] DEPTH: {INTEGER(10)} <br />
     * @return The value of the column 'DEPTH'. (Nullable)
     */
    public Integer getDepth() {
        return _depth;
    }

    /**
     * [set] DEPTH: {INTEGER(10)} <br />
     * @param depth The value of the column 'DEPTH'. (Nullable)
     */
    public void setDepth(Integer depth) {
        _modifiedProperties.addPropertyName("depth");
        this._depth = depth;
    }

    /**
     * [get] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @return The value of the column 'MAX_ACCESS_COUNT'. (Nullable)
     */
    public Long getMaxAccessCount() {
        return _maxAccessCount;
    }

    /**
     * [set] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @param maxAccessCount The value of the column 'MAX_ACCESS_COUNT'. (Nullable)
     */
    public void setMaxAccessCount(Long maxAccessCount) {
        _modifiedProperties.addPropertyName("maxAccessCount");
        this._maxAccessCount = maxAccessCount;
    }

    /**
     * [get] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'NUM_OF_THREAD'. (Nullable)
     */
    public Integer getNumOfThread() {
        return _numOfThread;
    }

    /**
     * [set] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @param numOfThread The value of the column 'NUM_OF_THREAD'. (Nullable)
     */
    public void setNumOfThread(Integer numOfThread) {
        _modifiedProperties.addPropertyName("numOfThread");
        this._numOfThread = numOfThread;
    }

    /**
     * [get] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'INTERVAL_TIME'. (Nullable)
     */
    public Integer getIntervalTime() {
        return _intervalTime;
    }

    /**
     * [set] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @param intervalTime The value of the column 'INTERVAL_TIME'. (Nullable)
     */
    public void setIntervalTime(Integer intervalTime) {
        _modifiedProperties.addPropertyName("intervalTime");
        this._intervalTime = intervalTime;
    }

    /**
     * [get] BOOST: {NotNull, DOUBLE(17)} <br />
     * @return The value of the column 'BOOST'. (Nullable)
     */
    public java.math.BigDecimal getBoost() {
        return _boost;
    }

    /**
     * [set] BOOST: {NotNull, DOUBLE(17)} <br />
     * @param boost The value of the column 'BOOST'. (Nullable)
     */
    public void setBoost(java.math.BigDecimal boost) {
        _modifiedProperties.addPropertyName("boost");
        this._boost = boost;
    }

    /**
     * [get] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @return The value of the column 'AVAILABLE'. (Nullable)
     */
    public String getAvailable() {
        return _available;
    }

    /**
     * [set] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @param available The value of the column 'AVAILABLE'. (Nullable)
     */
    public void setAvailable(String available) {
        _modifiedProperties.addPropertyName("available");
        this._available = available;
    }

    /**
     * [get] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'SORT_ORDER'. (Nullable)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * [set] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (Nullable)
     */
    public void setSortOrder(Integer sortOrder) {
        _modifiedProperties.addPropertyName("sortOrder");
        this._sortOrder = sortOrder;
    }

    /**
     * [get] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (Nullable)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * [set] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (Nullable)
     */
    public void setCreatedBy(String createdBy) {
        _modifiedProperties.addPropertyName("createdBy");
        this._createdBy = createdBy;
    }

    /**
     * [get] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * [set] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }

    /**
     * [get] UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (Nullable)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * [set] UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (Nullable)
     */
    public void setUpdatedBy(String updatedBy) {
        _modifiedProperties.addPropertyName("updatedBy");
        this._updatedBy = updatedBy;
    }

    /**
     * [get] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * [set] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public void setUpdatedTime(java.sql.Timestamp updatedTime) {
        _modifiedProperties.addPropertyName("updatedTime");
        this._updatedTime = updatedTime;
    }

    /**
     * [get] DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (Nullable)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * [set] DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (Nullable)
     */
    public void setDeletedBy(String deletedBy) {
        _modifiedProperties.addPropertyName("deletedBy");
        this._deletedBy = deletedBy;
    }

    /**
     * [get] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'DELETED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * [set] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (Nullable)
     */
    public void setDeletedTime(java.sql.Timestamp deletedTime) {
        _modifiedProperties.addPropertyName("deletedTime");
        this._deletedTime = deletedTime;
    }

    /**
     * [get] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'VERSION_NO'. (Nullable)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * [set] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (Nullable)
     */
    public void setVersionNo(Integer versionNo) {
        _modifiedProperties.addPropertyName("versionNo");
        this._versionNo = versionNo;
    }
}
