/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FailureUrlDbm;
import jp.sf.fess.db.cbean.FailureUrlCB;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of FAILURE_URL as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, URL, THREAD_NAME, ERROR_NAME, ERROR_LOG, ERROR_COUNT, LAST_ACCESS_TIME, WEB_CONFIG_ID, FILE_CONFIG_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     FILE_CRAWLING_CONFIG, WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     fileCrawlingConfig, webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFailureUrlBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FAILURE_URL";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FailureUrlDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FailureUrlDbm getMyDBMeta() {
        return FailureUrlDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FailureUrl newMyEntity() {
        return new FailureUrl();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FailureUrlCB newMyConditionBean() {
        return new FailureUrlCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * int count = failureUrlBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FailureUrlCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(FailureUrlCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * failureUrlBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FailureUrl&gt;() {
     *     public void handle(FailureUrl entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @param entityRowHandler The handler of entity row of FailureUrl. (NotNull)
     */
    public void selectCursor(FailureUrlCB cb,
            EntityRowHandler<FailureUrl> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> void doSelectCursor(FailureUrlCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FailureUrl>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * FailureUrl failureUrl = failureUrlBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (failureUrl != null) {
     *     ... = failureUrl.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectEntity(FailureUrlCB cb) {
        return doSelectEntity(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectEntity(
            final FailureUrlCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, FailureUrlCB>() {
                    public List<ENTITY> callbackSelectList(FailureUrlCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * FailureUrl failureUrl = failureUrlBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = failureUrl.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectEntityWithDeletedCheck(FailureUrlCB cb) {
        return doSelectEntityWithDeletedCheck(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectEntityWithDeletedCheck(
            final FailureUrlCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FailureUrlCB>() {
                    public List<ENTITY> callbackSelectList(FailureUrlCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectByPKValue(Long id) {
        return doSelectByPKValue(id, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FailureUrlCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FailureUrlCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FailureUrl&gt; failureUrlList = failureUrlBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FailureUrl failureUrl : failureUrlList) {
     *     ... = failureUrl.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FailureUrl> selectList(FailureUrlCB cb) {
        return doSelectList(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ListResultBean<ENTITY> doSelectList(
            FailureUrlCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, FailureUrlCB>() {
                    public List<ENTITY> callbackSelectList(FailureUrlCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FailureUrl&gt; page = failureUrlBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FailureUrl failureUrl : page) {
     *     ... = failureUrl.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FailureUrl> selectPage(FailureUrlCB cb) {
        return doSelectPage(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> PagingResultBean<ENTITY> doSelectPage(
            FailureUrlCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, FailureUrlCB>() {
                    public int callbackSelectCount(FailureUrlCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(FailureUrlCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * failureUrlBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FailureUrlCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FailureUrlCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FailureUrlCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param failureUrlList The list of failureUrl. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FailureUrl> failureUrlList) {
        return helpPulloutInternally(failureUrlList,
                new InternalPulloutCallback<FailureUrl, FileCrawlingConfig>() {
                    public FileCrawlingConfig getFr(FailureUrl e) {
                        return e.getFileCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param failureUrlList The list of failureUrl. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<FailureUrl> failureUrlList) {
        return helpPulloutInternally(failureUrlList,
                new InternalPulloutCallback<FailureUrl, WebCrawlingConfig>() {
                    public WebCrawlingConfig getFr(FailureUrl e) {
                        return e.getWebCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(WebCrawlingConfig e, List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * failureUrl.setFoo...(value);
     * failureUrl.setBar...(value);
     * failureUrlBhv.<span style="color: #FD4747">insert</span>(failureUrl);
     * ... = failureUrl.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param failureUrl The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FailureUrl failureUrl) {
        assertEntityNotNull(failureUrl);
        delegateInsert(failureUrl);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * failureUrl.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * failureUrl.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * failureUrl.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     failureUrlBhv.<span style="color: #FD4747">update</span>(failureUrl);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param failureUrl The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final FailureUrl failureUrl) {
        helpUpdateInternally(failureUrl,
                new InternalUpdateCallback<FailureUrl>() {
                    public int callbackDelegateUpdate(FailureUrl entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param failureUrl The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final FailureUrl failureUrl) {
        helpInsertOrUpdateInternally(failureUrl,
                new InternalInsertOrUpdateCallback<FailureUrl, FailureUrlCB>() {
                    public void callbackInsert(FailureUrl entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(FailureUrl entity) {
                        update(entity);
                    }

                    public FailureUrlCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(FailureUrlCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * failureUrl.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * failureUrl.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     failureUrlBhv.<span style="color: #FD4747">delete</span>(failureUrl);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param failureUrl The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FailureUrl failureUrl) {
        helpDeleteInternally(failureUrl,
                new InternalDeleteCallback<FailureUrl>() {
                    public int callbackDelegateDelete(FailureUrl entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param failureUrlList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<FailureUrl> failureUrlList) {
        assertObjectNotNull("failureUrlList", failureUrlList);
        return delegateInsertList(failureUrlList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param failureUrlList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<FailureUrl> failureUrlList) {
        assertObjectNotNull("failureUrlList", failureUrlList);
        return delegateUpdateList(failureUrlList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param failureUrlList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<FailureUrl> failureUrlList) {
        assertObjectNotNull("failureUrlList", failureUrlList);
        return delegateDeleteList(failureUrlList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//failureUrl.setPK...(value);</span>
     * failureUrl.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//failureUrl.setVersionNo(value);</span>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * failureUrlBhv.<span style="color: #FD4747">queryUpdate</span>(failureUrl, cb);
     * </pre>
     * @param failureUrl The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(FailureUrl failureUrl, FailureUrlCB cb) {
        return delegateQueryUpdate(failureUrl, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * failureUrlBhv.<span style="color: #FD4747">queryDelete</span>(failureUrl, cb);
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FailureUrlCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * failureUrl.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * failureUrl.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * failureUrl.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;FailureUrlCB&gt; option = new UpdateOption&lt;FailureUrlCB&gt;();
     *     option.self(new SpecifyQuery&lt;FailureUrlCB&gt;() {
     *         public void specify(FailureUrlCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     failureUrlBhv.<span style="color: #FD4747">varyingUpdate</span>(failureUrl, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param failureUrl The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(FailureUrl failureUrl,
            final UpdateOption<FailureUrlCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(failureUrl,
                new InternalUpdateCallback<FailureUrl>() {
                    public int callbackDelegateUpdate(FailureUrl entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//failureUrl.setPK...(value);</span>
     * failureUrl.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//failureUrl.setVersionNo(value);</span>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FailureUrlCB&gt; option = new UpdateOption&lt;FailureUrlCB&gt;();
     * option.self(new SpecifyQuery&lt;FailureUrlCB&gt;() {
     *     public void specify(FailureUrlCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * failureUrlBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(failureUrl, cb, option);
     * </pre>
     * @param failureUrl The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(FailureUrl failureUrl, FailureUrlCB cb,
            final UpdateOption<FailureUrlCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(failureUrl, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<FailureUrlCB> option) {
        assertUpdateOptionNotNull(option);
        FailureUrlCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FailureUrlCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends FailureUrl> void delegateSelectCursor(
            FailureUrlCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends FailureUrl> List<ENTITY> delegateSelectList(
            FailureUrlCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FailureUrl e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(FailureUrl e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(FailureUrl e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<FailureUrl> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FailureUrl> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<FailureUrl> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(FailureUrl e, FailureUrlCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(FailureUrlCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(FailureUrl e,
            UpdateOption<FailureUrlCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(FailureUrl e, FailureUrlCB cb,
            UpdateOption<FailureUrlCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FailureUrl downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, FailureUrl.class);
    }

    protected FailureUrlCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, FailureUrlCB.class);
    }
}
