/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.crud.form.admin;

import java.util.HashMap;
import java.util.Map;

import org.seasar.struts.annotation.DateType;
import org.seasar.struts.annotation.IntegerType;
import org.seasar.struts.annotation.LongType;
import org.seasar.struts.annotation.Required;

public abstract class BsFailureUrlForm {
    @IntegerType
    public String pageNumber;

    public Map<String, String> searchParams = new HashMap<String, String>();

    @IntegerType
    public int crudMode;

    public String getCurrentPageNumber() {
        return pageNumber;
    }

    @Required(target = "confirmfromupdate,update,delete")
    @LongType
    public String id;

    @Required(target = "confirmfromcreate,create,confirmfromupdate,update,delete")
    public String url;

    @Required(target = "confirmfromcreate,create,confirmfromupdate,update,delete")
    public String threadName;

    public String errorName;

    public String errorLog;

    @Required(target = "confirmfromcreate,create,confirmfromupdate,update,delete")
    @IntegerType
    public String errorCount;

    @Required(target = "confirmfromcreate,create,confirmfromupdate,update,delete")
    @DateType
    public String lastAccessTime;

    @LongType
    public String webConfigId;

    @LongType
    public String fileConfigId;

    public void initialize() {

        id = null;
        url = null;
        threadName = null;
        errorName = null;
        errorLog = null;
        errorCount = null;
        lastAccessTime = null;
        webConfigId = null;
        fileConfigId = null;

    }

}
