/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of WEB_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, URLS, INCLUDED_URLS, EXCLUDED_URLS, INCLUDED_DOC_URLS, EXCLUDED_DOC_URLS, DEPTH, MAX_ACCESS_COUNT, USER_AGENT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, REQUEST_HEADER, WEB_AUTHENTICATION, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, requestHeaderList, webAuthenticationList, webConfigToBrowserTypeMappingList, webConfigToLabelTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebCrawlingConfig implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** NAME: {NotNull, VARCHAR(200)} */
    protected String _name;

    /** URLS: {NotNull, VARCHAR(4000)} */
    protected String _urls;

    /** INCLUDED_URLS: {VARCHAR(4000)} */
    protected String _includedUrls;

    /** EXCLUDED_URLS: {VARCHAR(4000)} */
    protected String _excludedUrls;

    /** INCLUDED_DOC_URLS: {VARCHAR(4000)} */
    protected String _includedDocUrls;

    /** EXCLUDED_DOC_URLS: {VARCHAR(4000)} */
    protected String _excludedDocUrls;

    /** DEPTH: {INTEGER(10)} */
    protected Integer _depth;

    /** MAX_ACCESS_COUNT: {BIGINT(19)} */
    protected Long _maxAccessCount;

    /** USER_AGENT: {NotNull, VARCHAR(200)} */
    protected String _userAgent;

    /** NUM_OF_THREAD: {NotNull, INTEGER(10)} */
    protected Integer _numOfThread;

    /** INTERVAL_TIME: {NotNull, INTEGER(10)} */
    protected Integer _intervalTime;

    /** BOOST: {NotNull, DOUBLE(17)} */
    protected java.math.BigDecimal _boost;

    /** AVAILABLE: {NotNull, VARCHAR(1)} */
    protected String _available;

    /** SORT_ORDER: {NotNull, INTEGER(10)} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull, VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull, INTEGER(10)} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    /**
     * {@inheritDoc}
     */
    public String getTablePropertyName() { // according to Java Beans rule
        return "webCrawlingConfig";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** FAILURE_URL as 'failureUrlList'. */
    protected List<FailureUrl> _failureUrlList;

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @return The entity list of referrer property 'failureUrlList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FailureUrl> getFailureUrlList() {
        if (_failureUrlList == null) {
            _failureUrlList = new ArrayList<FailureUrl>();
        }
        return _failureUrlList;
    }

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @param failureUrlList The entity list of referrer property 'failureUrlList'. (Nullable)
     */
    public void setFailureUrlList(List<FailureUrl> failureUrlList) {
        _failureUrlList = failureUrlList;
    }

    /** REQUEST_HEADER as 'requestHeaderList'. */
    protected List<RequestHeader> _requestHeaderList;

    /**
     * REQUEST_HEADER as 'requestHeaderList'.
     * @return The entity list of referrer property 'requestHeaderList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<RequestHeader> getRequestHeaderList() {
        if (_requestHeaderList == null) {
            _requestHeaderList = new ArrayList<RequestHeader>();
        }
        return _requestHeaderList;
    }

    /**
     * REQUEST_HEADER as 'requestHeaderList'.
     * @param requestHeaderList The entity list of referrer property 'requestHeaderList'. (Nullable)
     */
    public void setRequestHeaderList(List<RequestHeader> requestHeaderList) {
        _requestHeaderList = requestHeaderList;
    }

    /** WEB_AUTHENTICATION as 'webAuthenticationList'. */
    protected List<WebAuthentication> _webAuthenticationList;

    /**
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @return The entity list of referrer property 'webAuthenticationList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebAuthentication> getWebAuthenticationList() {
        if (_webAuthenticationList == null) {
            _webAuthenticationList = new ArrayList<WebAuthentication>();
        }
        return _webAuthenticationList;
    }

    /**
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @param webAuthenticationList The entity list of referrer property 'webAuthenticationList'. (Nullable)
     */
    public void setWebAuthenticationList(
            List<WebAuthentication> webAuthenticationList) {
        _webAuthenticationList = webAuthenticationList;
    }

    /** WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'. */
    protected List<WebConfigToBrowserTypeMapping> _webConfigToBrowserTypeMappingList;

    /**
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @return The entity list of referrer property 'webConfigToBrowserTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebConfigToBrowserTypeMapping> getWebConfigToBrowserTypeMappingList() {
        if (_webConfigToBrowserTypeMappingList == null) {
            _webConfigToBrowserTypeMappingList = new ArrayList<WebConfigToBrowserTypeMapping>();
        }
        return _webConfigToBrowserTypeMappingList;
    }

    /**
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @param webConfigToBrowserTypeMappingList The entity list of referrer property 'webConfigToBrowserTypeMappingList'. (Nullable)
     */
    public void setWebConfigToBrowserTypeMappingList(
            List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        _webConfigToBrowserTypeMappingList = webConfigToBrowserTypeMappingList;
    }

    /** WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'. */
    protected List<WebConfigToLabelTypeMapping> _webConfigToLabelTypeMappingList;

    /**
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @return The entity list of referrer property 'webConfigToLabelTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebConfigToLabelTypeMapping> getWebConfigToLabelTypeMappingList() {
        if (_webConfigToLabelTypeMappingList == null) {
            _webConfigToLabelTypeMappingList = new ArrayList<WebConfigToLabelTypeMapping>();
        }
        return _webConfigToLabelTypeMappingList;
    }

    /**
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @param webConfigToLabelTypeMappingList The entity list of referrer property 'webConfigToLabelTypeMappingList'. (Nullable)
     */
    public void setWebConfigToLabelTypeMappingList(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        _webConfigToLabelTypeMappingList = webConfigToLabelTypeMappingList;
    }

    /** WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'. */
    protected List<WebConfigToRoleTypeMapping> _webConfigToRoleTypeMappingList;

    /**
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @return The entity list of referrer property 'webConfigToRoleTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebConfigToRoleTypeMapping> getWebConfigToRoleTypeMappingList() {
        if (_webConfigToRoleTypeMappingList == null) {
            _webConfigToRoleTypeMappingList = new ArrayList<WebConfigToRoleTypeMapping>();
        }
        return _webConfigToRoleTypeMappingList;
    }

    /**
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @param webConfigToRoleTypeMappingList The entity list of referrer property 'webConfigToRoleTypeMappingList'. (Nullable)
     */
    public void setWebConfigToRoleTypeMappingList(
            List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        _webConfigToRoleTypeMappingList = webConfigToRoleTypeMappingList;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    /**
     * {@inheritDoc}
     */
    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (Nullable)
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsWebCrawlingConfig)) {
            return false;
        }
        BsWebCrawlingConfig otherEntity = (BsWebCrawlingConfig) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(Object value1, Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    public int hashCode() {
        int result = 17;
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(int result, Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    public String toStringWithRelation() {
        StringBuilder sb = new StringBuilder();
        sb.append(toString());
        String l = "\n  ";
        if (_failureUrlList != null) {
            for (Entity e : _failureUrlList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "failureUrlList"));
                }
            }
        }
        if (_requestHeaderList != null) {
            for (Entity e : _requestHeaderList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "requestHeaderList"));
                }
            }
        }
        if (_webAuthenticationList != null) {
            for (Entity e : _webAuthenticationList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "webAuthenticationList"));
                }
            }
        }
        if (_webConfigToBrowserTypeMappingList != null) {
            for (Entity e : _webConfigToBrowserTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "webConfigToBrowserTypeMappingList"));
                }
            }
        }
        if (_webConfigToLabelTypeMappingList != null) {
            for (Entity e : _webConfigToLabelTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "webConfigToLabelTypeMappingList"));
                }
            }
        }
        if (_webConfigToRoleTypeMappingList != null) {
            for (Entity e : _webConfigToRoleTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "webConfigToRoleTypeMappingList"));
                }
            }
        }
        return sb.toString();
    }

    protected String xbRDS(Entity e, String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (Nullable: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    public String buildDisplayString(String name, boolean column,
            boolean relation) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        String c = ", ";
        StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getName());
        sb.append(c).append(getUrls());
        sb.append(c).append(getIncludedUrls());
        sb.append(c).append(getExcludedUrls());
        sb.append(c).append(getIncludedDocUrls());
        sb.append(c).append(getExcludedDocUrls());
        sb.append(c).append(getDepth());
        sb.append(c).append(getMaxAccessCount());
        sb.append(c).append(getUserAgent());
        sb.append(c).append(getNumOfThread());
        sb.append(c).append(getIntervalTime());
        sb.append(c).append(getBoost());
        sb.append(c).append(getAvailable());
        sb.append(c).append(getSortOrder());
        sb.append(c).append(getCreatedBy());
        sb.append(c).append(getCreatedTime());
        sb.append(c).append(getUpdatedBy());
        sb.append(c).append(getUpdatedTime());
        sb.append(c).append(getDeletedBy());
        sb.append(c).append(getDeletedTime());
        sb.append(c).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        StringBuilder sb = new StringBuilder();
        String c = ",";
        if (_failureUrlList != null && !_failureUrlList.isEmpty()) {
            sb.append(c).append("failureUrlList");
        }
        if (_requestHeaderList != null && !_requestHeaderList.isEmpty()) {
            sb.append(c).append("requestHeaderList");
        }
        if (_webAuthenticationList != null && !_webAuthenticationList.isEmpty()) {
            sb.append(c).append("webAuthenticationList");
        }
        if (_webConfigToBrowserTypeMappingList != null
                && !_webConfigToBrowserTypeMappingList.isEmpty()) {
            sb.append(c).append("webConfigToBrowserTypeMappingList");
        }
        if (_webConfigToLabelTypeMappingList != null
                && !_webConfigToLabelTypeMappingList.isEmpty()) {
            sb.append(c).append("webConfigToLabelTypeMappingList");
        }
        if (_webConfigToRoleTypeMappingList != null
                && !_webConfigToRoleTypeMappingList.isEmpty()) {
            sb.append(c).append("webConfigToRoleTypeMappingList");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * [get] NAME: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'NAME'. (Nullable)
     */
    public String getName() {
        return _name;
    }

    /**
     * [set] NAME: {NotNull, VARCHAR(200)} <br />
     * @param name The value of the column 'NAME'. (Nullable)
     */
    public void setName(String name) {
        _modifiedProperties.addPropertyName("name");
        this._name = name;
    }

    /**
     * [get] URLS: {NotNull, VARCHAR(4000)} <br />
     * @return The value of the column 'URLS'. (Nullable)
     */
    public String getUrls() {
        return _urls;
    }

    /**
     * [set] URLS: {NotNull, VARCHAR(4000)} <br />
     * @param urls The value of the column 'URLS'. (Nullable)
     */
    public void setUrls(String urls) {
        _modifiedProperties.addPropertyName("urls");
        this._urls = urls;
    }

    /**
     * [get] INCLUDED_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_URLS'. (Nullable)
     */
    public String getIncludedUrls() {
        return _includedUrls;
    }

    /**
     * [set] INCLUDED_URLS: {VARCHAR(4000)} <br />
     * @param includedUrls The value of the column 'INCLUDED_URLS'. (Nullable)
     */
    public void setIncludedUrls(String includedUrls) {
        _modifiedProperties.addPropertyName("includedUrls");
        this._includedUrls = includedUrls;
    }

    /**
     * [get] EXCLUDED_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_URLS'. (Nullable)
     */
    public String getExcludedUrls() {
        return _excludedUrls;
    }

    /**
     * [set] EXCLUDED_URLS: {VARCHAR(4000)} <br />
     * @param excludedUrls The value of the column 'EXCLUDED_URLS'. (Nullable)
     */
    public void setExcludedUrls(String excludedUrls) {
        _modifiedProperties.addPropertyName("excludedUrls");
        this._excludedUrls = excludedUrls;
    }

    /**
     * [get] INCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_DOC_URLS'. (Nullable)
     */
    public String getIncludedDocUrls() {
        return _includedDocUrls;
    }

    /**
     * [set] INCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @param includedDocUrls The value of the column 'INCLUDED_DOC_URLS'. (Nullable)
     */
    public void setIncludedDocUrls(String includedDocUrls) {
        _modifiedProperties.addPropertyName("includedDocUrls");
        this._includedDocUrls = includedDocUrls;
    }

    /**
     * [get] EXCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_DOC_URLS'. (Nullable)
     */
    public String getExcludedDocUrls() {
        return _excludedDocUrls;
    }

    /**
     * [set] EXCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @param excludedDocUrls The value of the column 'EXCLUDED_DOC_URLS'. (Nullable)
     */
    public void setExcludedDocUrls(String excludedDocUrls) {
        _modifiedProperties.addPropertyName("excludedDocUrls");
        this._excludedDocUrls = excludedDocUrls;
    }

    /**
     * [get] DEPTH: {INTEGER(10)} <br />
     * @return The value of the column 'DEPTH'. (Nullable)
     */
    public Integer getDepth() {
        return _depth;
    }

    /**
     * [set] DEPTH: {INTEGER(10)} <br />
     * @param depth The value of the column 'DEPTH'. (Nullable)
     */
    public void setDepth(Integer depth) {
        _modifiedProperties.addPropertyName("depth");
        this._depth = depth;
    }

    /**
     * [get] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @return The value of the column 'MAX_ACCESS_COUNT'. (Nullable)
     */
    public Long getMaxAccessCount() {
        return _maxAccessCount;
    }

    /**
     * [set] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @param maxAccessCount The value of the column 'MAX_ACCESS_COUNT'. (Nullable)
     */
    public void setMaxAccessCount(Long maxAccessCount) {
        _modifiedProperties.addPropertyName("maxAccessCount");
        this._maxAccessCount = maxAccessCount;
    }

    /**
     * [get] USER_AGENT: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'USER_AGENT'. (Nullable)
     */
    public String getUserAgent() {
        return _userAgent;
    }

    /**
     * [set] USER_AGENT: {NotNull, VARCHAR(200)} <br />
     * @param userAgent The value of the column 'USER_AGENT'. (Nullable)
     */
    public void setUserAgent(String userAgent) {
        _modifiedProperties.addPropertyName("userAgent");
        this._userAgent = userAgent;
    }

    /**
     * [get] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'NUM_OF_THREAD'. (Nullable)
     */
    public Integer getNumOfThread() {
        return _numOfThread;
    }

    /**
     * [set] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @param numOfThread The value of the column 'NUM_OF_THREAD'. (Nullable)
     */
    public void setNumOfThread(Integer numOfThread) {
        _modifiedProperties.addPropertyName("numOfThread");
        this._numOfThread = numOfThread;
    }

    /**
     * [get] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'INTERVAL_TIME'. (Nullable)
     */
    public Integer getIntervalTime() {
        return _intervalTime;
    }

    /**
     * [set] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @param intervalTime The value of the column 'INTERVAL_TIME'. (Nullable)
     */
    public void setIntervalTime(Integer intervalTime) {
        _modifiedProperties.addPropertyName("intervalTime");
        this._intervalTime = intervalTime;
    }

    /**
     * [get] BOOST: {NotNull, DOUBLE(17)} <br />
     * @return The value of the column 'BOOST'. (Nullable)
     */
    public java.math.BigDecimal getBoost() {
        return _boost;
    }

    /**
     * [set] BOOST: {NotNull, DOUBLE(17)} <br />
     * @param boost The value of the column 'BOOST'. (Nullable)
     */
    public void setBoost(java.math.BigDecimal boost) {
        _modifiedProperties.addPropertyName("boost");
        this._boost = boost;
    }

    /**
     * [get] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @return The value of the column 'AVAILABLE'. (Nullable)
     */
    public String getAvailable() {
        return _available;
    }

    /**
     * [set] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @param available The value of the column 'AVAILABLE'. (Nullable)
     */
    public void setAvailable(String available) {
        _modifiedProperties.addPropertyName("available");
        this._available = available;
    }

    /**
     * [get] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'SORT_ORDER'. (Nullable)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * [set] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (Nullable)
     */
    public void setSortOrder(Integer sortOrder) {
        _modifiedProperties.addPropertyName("sortOrder");
        this._sortOrder = sortOrder;
    }

    /**
     * [get] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (Nullable)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * [set] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (Nullable)
     */
    public void setCreatedBy(String createdBy) {
        _modifiedProperties.addPropertyName("createdBy");
        this._createdBy = createdBy;
    }

    /**
     * [get] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * [set] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }

    /**
     * [get] UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (Nullable)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * [set] UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (Nullable)
     */
    public void setUpdatedBy(String updatedBy) {
        _modifiedProperties.addPropertyName("updatedBy");
        this._updatedBy = updatedBy;
    }

    /**
     * [get] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * [set] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public void setUpdatedTime(java.sql.Timestamp updatedTime) {
        _modifiedProperties.addPropertyName("updatedTime");
        this._updatedTime = updatedTime;
    }

    /**
     * [get] DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (Nullable)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * [set] DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (Nullable)
     */
    public void setDeletedBy(String deletedBy) {
        _modifiedProperties.addPropertyName("deletedBy");
        this._deletedBy = deletedBy;
    }

    /**
     * [get] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'DELETED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * [set] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (Nullable)
     */
    public void setDeletedTime(java.sql.Timestamp deletedTime) {
        _modifiedProperties.addPropertyName("deletedTime");
        this._deletedTime = deletedTime;
    }

    /**
     * [get] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'VERSION_NO'. (Nullable)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * [set] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (Nullable)
     */
    public void setVersionNo(Integer versionNo) {
        _modifiedProperties.addPropertyName("versionNo");
        this._versionNo = versionNo;
    }
}
