/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.LabelTypeToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.LabelTypeToRoleTypeMappingCB;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping;
import jp.sf.fess.db.exentity.RoleType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of LABEL_TYPE_TO_ROLE_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, LABEL_TYPE_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     LABEL_TYPE, ROLE_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     labelType, roleType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsLabelTypeToRoleTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "LABEL_TYPE_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return LabelTypeToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public LabelTypeToRoleTypeMappingDbm getMyDBMeta() {
        return LabelTypeToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public LabelTypeToRoleTypeMapping newMyEntity() {
        return new LabelTypeToRoleTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public LabelTypeToRoleTypeMappingCB newMyConditionBean() {
        return new LabelTypeToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(LabelTypeToRoleTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(LabelTypeToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;LabelTypeToRoleTypeMapping&gt;() {
     *     public void handle(LabelTypeToRoleTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of LabelTypeToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(LabelTypeToRoleTypeMappingCB cb,
            EntityRowHandler<LabelTypeToRoleTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> void doSelectCursor(
            LabelTypeToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<LabelTypeToRoleTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (labelTypeToRoleTypeMapping != null) {
     *     ... = labelTypeToRoleTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectEntity(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectEntity(cb, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectEntity(
            final LabelTypeToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = labelTypeToRoleTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectEntityWithDeletedCheck(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final LabelTypeToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private LabelTypeToRoleTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        LabelTypeToRoleTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;LabelTypeToRoleTypeMapping&gt; labelTypeToRoleTypeMappingList = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping : labelTypeToRoleTypeMappingList) {
     *     ... = labelTypeToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<LabelTypeToRoleTypeMapping> selectList(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectList(cb, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ListResultBean<ENTITY> doSelectList(
            LabelTypeToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;LabelTypeToRoleTypeMapping&gt; page = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping : page) {
     *     ... = labelTypeToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<LabelTypeToRoleTypeMapping> selectPage(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectPage(cb, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            LabelTypeToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public int callbackSelectCount(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<LabelTypeToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends LabelTypeToRoleTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param labelTypeToRoleTypeMappingList The list of labelTypeToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return helpPulloutInternally(
                labelTypeToRoleTypeMappingList,
                new InternalPulloutCallback<LabelTypeToRoleTypeMapping, LabelType>() {
                    public LabelType getFr(LabelTypeToRoleTypeMapping e) {
                        return e.getLabelType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(LabelType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param labelTypeToRoleTypeMappingList The list of labelTypeToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return helpPulloutInternally(
                labelTypeToRoleTypeMappingList,
                new InternalPulloutCallback<LabelTypeToRoleTypeMapping, RoleType>() {
                    public RoleType getFr(LabelTypeToRoleTypeMapping e) {
                        return e.getRoleType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(RoleType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * labelTypeToRoleTypeMapping.setFoo...(value);
     * labelTypeToRoleTypeMapping.setBar...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">insert</span>(labelTypeToRoleTypeMapping);
     * ... = labelTypeToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        assertEntityNotNull(labelTypeToRoleTypeMapping);
        delegateInsert(labelTypeToRoleTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * labelTypeToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelTypeToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelTypeToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">update</span>(labelTypeToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        helpUpdateInternally(labelTypeToRoleTypeMapping,
                new InternalUpdateCallback<LabelTypeToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            LabelTypeToRoleTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param labelTypeToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        helpInsertOrUpdateInternally(
                labelTypeToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<LabelTypeToRoleTypeMapping, LabelTypeToRoleTypeMappingCB>() {
                    public void callbackInsert(LabelTypeToRoleTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(LabelTypeToRoleTypeMapping entity) {
                        update(entity);
                    }

                    public LabelTypeToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * labelTypeToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelTypeToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">delete</span>(labelTypeToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        helpDeleteInternally(labelTypeToRoleTypeMapping,
                new InternalDeleteCallback<LabelTypeToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            LabelTypeToRoleTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        assertObjectNotNull("labelTypeToRoleTypeMappingList",
                labelTypeToRoleTypeMappingList);
        return delegateInsertList(labelTypeToRoleTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        assertObjectNotNull("labelTypeToRoleTypeMappingList",
                labelTypeToRoleTypeMappingList);
        return delegateUpdateList(labelTypeToRoleTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        assertObjectNotNull("labelTypeToRoleTypeMappingList",
                labelTypeToRoleTypeMappingList);
        return delegateDeleteList(labelTypeToRoleTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setPK...(value);</span>
     * labelTypeToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setVersionNo(value);</span>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(labelTypeToRoleTypeMapping, cb);
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            LabelTypeToRoleTypeMappingCB cb) {
        return delegateQueryUpdate(labelTypeToRoleTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(labelTypeToRoleTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(LabelTypeToRoleTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * labelTypeToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelTypeToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelTypeToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt; option = new UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *         public void specify(LabelTypeToRoleTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(labelTypeToRoleTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            final UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(labelTypeToRoleTypeMapping,
                new InternalUpdateCallback<LabelTypeToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            LabelTypeToRoleTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setPK...(value);</span>
     * labelTypeToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setVersionNo(value);</span>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt; option = new UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *     public void specify(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(labelTypeToRoleTypeMapping, cb, option);
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            LabelTypeToRoleTypeMappingCB cb,
            final UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(labelTypeToRoleTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        LabelTypeToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(LabelTypeToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> void delegateSelectCursor(
            LabelTypeToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> List<ENTITY> delegateSelectList(
            LabelTypeToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(LabelTypeToRoleTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(LabelTypeToRoleTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(LabelTypeToRoleTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<LabelTypeToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<LabelTypeToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<LabelTypeToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(LabelTypeToRoleTypeMapping e,
            LabelTypeToRoleTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(LabelTypeToRoleTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(LabelTypeToRoleTypeMapping e,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(LabelTypeToRoleTypeMapping e,
            LabelTypeToRoleTypeMappingCB cb,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected LabelTypeToRoleTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                LabelTypeToRoleTypeMapping.class);
    }

    protected LabelTypeToRoleTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                LabelTypeToRoleTypeMappingCB.class);
    }
}
