/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.DataConfigToBrowserTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of DATA_CONFIG_TO_BROWSER_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, BROWSER_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     BROWSER_TYPE, DATA_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     browserType, dataCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToBrowserTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToBrowserTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToBrowserTypeMappingDbm getMyDBMeta() {
        return DataConfigToBrowserTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public DataConfigToBrowserTypeMapping newMyEntity() {
        return new DataConfigToBrowserTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public DataConfigToBrowserTypeMappingCB newMyConditionBean() {
        return new DataConfigToBrowserTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToBrowserTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(DataConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;DataConfigToBrowserTypeMapping&gt;() {
     *     public void handle(DataConfigToBrowserTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToBrowserTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<DataConfigToBrowserTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler,
                DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> void doSelectCursor(
            DataConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToBrowserTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (dataConfigToBrowserTypeMapping != null) {
     *     ... = dataConfigToBrowserTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToBrowserTypeMapping selectEntity(
            DataConfigToBrowserTypeMappingCB cb) {
        return doSelectEntity(cb, DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> ENTITY doSelectEntity(
            final DataConfigToBrowserTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, DataConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = dataConfigToBrowserTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToBrowserTypeMapping selectEntityWithDeletedCheck(
            DataConfigToBrowserTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final DataConfigToBrowserTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, DataConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToBrowserTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToBrowserTypeMapping selectByPKValueWithDeletedCheck(
            Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private DataConfigToBrowserTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        DataConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;DataConfigToBrowserTypeMapping&gt; dataConfigToBrowserTypeMappingList = dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping : dataConfigToBrowserTypeMappingList) {
     *     ... = dataConfigToBrowserTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<DataConfigToBrowserTypeMapping> selectList(
            DataConfigToBrowserTypeMappingCB cb) {
        return doSelectList(cb, DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> ListResultBean<ENTITY> doSelectList(
            DataConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, DataConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToBrowserTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;DataConfigToBrowserTypeMapping&gt; page = dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping : page) {
     *     ... = dataConfigToBrowserTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<DataConfigToBrowserTypeMapping> selectPage(
            DataConfigToBrowserTypeMappingCB cb) {
        return doSelectPage(cb, DataConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            DataConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, DataConfigToBrowserTypeMappingCB>() {
                    public int callbackSelectCount(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            DataConfigToBrowserTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataConfigToBrowserTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends DataConfigToBrowserTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'BrowserType'.
     * @param dataConfigToBrowserTypeMappingList The list of dataConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<BrowserType> pulloutBrowserType(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<DataConfigToBrowserTypeMapping, BrowserType>() {
                    public BrowserType getFr(DataConfigToBrowserTypeMapping e) {
                        return e.getBrowserType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(BrowserType e,
                            List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToBrowserTypeMappingList The list of dataConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<DataConfigToBrowserTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig getFr(
                            DataConfigToBrowserTypeMapping e) {
                        return e.getDataCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataConfigToBrowserTypeMapping.setFoo...(value);
     * dataConfigToBrowserTypeMapping.setBar...(value);
     * dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">insert</span>(dataConfigToBrowserTypeMapping);
     * ... = dataConfigToBrowserTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataConfigToBrowserTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        assertEntityNotNull(dataConfigToBrowserTypeMapping);
        delegateInsert(dataConfigToBrowserTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
     * dataConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToBrowserTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">update</span>(dataConfigToBrowserTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        helpUpdateInternally(dataConfigToBrowserTypeMapping,
                new InternalUpdateCallback<DataConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToBrowserTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param dataConfigToBrowserTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        helpInsertOrUpdateInternally(
                dataConfigToBrowserTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToBrowserTypeMapping, DataConfigToBrowserTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToBrowserTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            DataConfigToBrowserTypeMapping entity) {
                        update(entity);
                    }

                    public DataConfigToBrowserTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
     * dataConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">delete</span>(dataConfigToBrowserTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToBrowserTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        helpDeleteInternally(dataConfigToBrowserTypeMapping,
                new InternalDeleteCallback<DataConfigToBrowserTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToBrowserTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        assertObjectNotNull("dataConfigToBrowserTypeMappingList",
                dataConfigToBrowserTypeMappingList);
        return delegateInsertList(dataConfigToBrowserTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        assertObjectNotNull("dataConfigToBrowserTypeMappingList",
                dataConfigToBrowserTypeMappingList);
        return delegateUpdateList(dataConfigToBrowserTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        assertObjectNotNull("dataConfigToBrowserTypeMappingList",
                dataConfigToBrowserTypeMappingList);
        return delegateDeleteList(dataConfigToBrowserTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToBrowserTypeMapping.setPK...(value);</span>
     * dataConfigToBrowserTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToBrowserTypeMapping.setVersionNo(value);</span>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(dataConfigToBrowserTypeMapping, cb);
     * </pre>
     * @param dataConfigToBrowserTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping,
            DataConfigToBrowserTypeMappingCB cb) {
        return delegateQueryUpdate(dataConfigToBrowserTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(dataConfigToBrowserTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataConfigToBrowserTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
     * dataConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToBrowserTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;DataConfigToBrowserTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToBrowserTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *         public void specify(DataConfigToBrowserTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(dataConfigToBrowserTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param dataConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping,
            final UpdateOption<DataConfigToBrowserTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(dataConfigToBrowserTypeMapping,
                new InternalUpdateCallback<DataConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToBrowserTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToBrowserTypeMapping.setPK...(value);</span>
     * dataConfigToBrowserTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToBrowserTypeMapping.setVersionNo(value);</span>
     * DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;DataConfigToBrowserTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToBrowserTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *     public void specify(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(dataConfigToBrowserTypeMapping, cb, option);
     * </pre>
     * @param dataConfigToBrowserTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping,
            DataConfigToBrowserTypeMappingCB cb,
            final UpdateOption<DataConfigToBrowserTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(dataConfigToBrowserTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<DataConfigToBrowserTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        DataConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataConfigToBrowserTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> void delegateSelectCursor(
            DataConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends DataConfigToBrowserTypeMapping> List<ENTITY> delegateSelectList(
            DataConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToBrowserTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(DataConfigToBrowserTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(DataConfigToBrowserTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<DataConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<DataConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(DataConfigToBrowserTypeMapping e,
            DataConfigToBrowserTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(DataConfigToBrowserTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(DataConfigToBrowserTypeMapping e,
            UpdateOption<DataConfigToBrowserTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(DataConfigToBrowserTypeMapping e,
            DataConfigToBrowserTypeMappingCB cb,
            UpdateOption<DataConfigToBrowserTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected DataConfigToBrowserTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                DataConfigToBrowserTypeMapping.class);
    }

    protected DataConfigToBrowserTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                DataConfigToBrowserTypeMappingCB.class);
    }
}
