/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.RequestHeaderCQ;
import jp.sf.fess.db.cbean.cq.WebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebCrawlingConfigCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of WEB_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsWebCrawlingConfigCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsWebCrawlingConfigCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    public String getTableSqlName() {
        return "WEB_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {PK : ID : NotNull : BIGINT}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        regId(CK_NE, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    public void inScopeRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeSubQuery_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery);

    public void inScopeWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeSubQuery_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    public void inScopeWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeSubQuery_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    public void notInScopeRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeSubQuery_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerNotInScopeSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery);

    public void notInScopeWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeSubQuery_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerNotInScopeSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    public void notInScopeWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeSubQuery_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotInScopeSubQuery(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    /**
     * Set up 'exists' sub-query. {exists (select WEB_CRAWLING_CONFIG_ID from REQUEST_HEADER where ...)}
     * @param subQuery The sub-query of Id_ExistsSubQuery_RequestHeaderList for 'exists'. (NotNull)
     */
    public void existsRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsSubQuery_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerExistsSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery);

    /**
     * Set up 'exists' sub-query. {exists (select WEB_CRAWLING_CONFIG_ID from WEB_AUTHENTICATION where ...)}
     * @param subQuery The sub-query of Id_ExistsSubQuery_WebAuthenticationList for 'exists'. (NotNull)
     */
    public void existsWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsSubQuery_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerExistsSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    /**
     * Set up 'exists' sub-query. {exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)}
     * @param subQuery The sub-query of Id_ExistsSubQuery_WebConfigToBrowserTypeMappingList for 'exists'. (NotNull)
     */
    public void existsWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsSubQuery_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerExistsSubQuery(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    /**
     * Set up 'not exists' sub-query. {not exists (select WEB_CRAWLING_CONFIG_ID from REQUEST_HEADER where ...)}
     * @param subQuery The sub-query of Id_NotExistsSubQuery_RequestHeaderList for 'not exists'. (NotNull)
     */
    public void notExistsRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsSubQuery_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerNotExistsSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery);

    /**
     * Set up 'not exists' sub-query. {not exists (select WEB_CRAWLING_CONFIG_ID from WEB_AUTHENTICATION where ...)}
     * @param subQuery The sub-query of Id_NotExistsSubQuery_WebAuthenticationList for 'not exists'. (NotNull)
     */
    public void notExistsWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsSubQuery_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerNotExistsSubQuery(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    /**
     * Set up 'not exists' sub-query. {not exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)}
     * @param subQuery The sub-query of Id_NotExistsSubQuery_WebConfigToBrowserTypeMappingList for 'not exists'. (NotNull)
     */
    public void notExistsWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsSubQuery_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotExistsSubQuery(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    public void xsderiveRequestHeaderList(String function,
            SubQuery<RequestHeaderCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery);

    public void xsderiveWebAuthenticationList(String function,
            SubQuery<WebAuthenticationCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    public void xsderiveWebConfigToBrowserTypeMappingList(String function,
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    public QDRFunction<RequestHeaderCB> derivedRequestHeaderList() {
        return xcreateQDRFunctionRequestHeaderList();
    }

    protected QDRFunction<RequestHeaderCB> xcreateQDRFunctionRequestHeaderList() {
        return new QDRFunction<RequestHeaderCB>(
                new QDRSetupper<RequestHeaderCB>() {
                    public void setup(String function,
                            SubQuery<RequestHeaderCB> subQuery, String operand,
                            Object value) {
                        xqderiveRequestHeaderList(function, subQuery, operand,
                                value);
                    }
                });
    }

    public void xqderiveRequestHeaderList(String function,
            SubQuery<RequestHeaderCB> subQuery, String operand, Object value) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_RequestHeaderList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_RequestHeaderListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_RequestHeaderListParameter(
            Object parameterValue);

    public QDRFunction<WebAuthenticationCB> derivedWebAuthenticationList() {
        return xcreateQDRFunctionWebAuthenticationList();
    }

    protected QDRFunction<WebAuthenticationCB> xcreateQDRFunctionWebAuthenticationList() {
        return new QDRFunction<WebAuthenticationCB>(
                new QDRSetupper<WebAuthenticationCB>() {
                    public void setup(String function,
                            SubQuery<WebAuthenticationCB> subQuery,
                            String operand, Object value) {
                        xqderiveWebAuthenticationList(function, subQuery,
                                operand, value);
                    }
                });
    }

    public void xqderiveWebAuthenticationList(String function,
            SubQuery<WebAuthenticationCB> subQuery, String operand, Object value) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_WebAuthenticationList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_WebAuthenticationListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_WebAuthenticationListParameter(
            Object parameterValue);

    public QDRFunction<WebConfigToBrowserTypeMappingCB> derivedWebConfigToBrowserTypeMappingList() {
        return xcreateQDRFunctionWebConfigToBrowserTypeMappingList();
    }

    protected QDRFunction<WebConfigToBrowserTypeMappingCB> xcreateQDRFunctionWebConfigToBrowserTypeMappingList() {
        return new QDRFunction<WebConfigToBrowserTypeMappingCB>(
                new QDRSetupper<WebConfigToBrowserTypeMappingCB>() {
                    public void setup(String function,
                            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery,
                            String operand, Object value) {
                        xqderiveWebConfigToBrowserTypeMappingList(function,
                                subQuery, operand, value);
                    }
                });
    }

    public void xqderiveWebConfigToBrowserTypeMappingList(String function,
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery, String operand,
            Object value) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter(
            Object parameterValue);

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(200)}
     * @param name The value of name as equal.
     */
    public void setName_Equal(String name) {
        regName(CK_EQ, fRES(name));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as notEqual.
     */
    public void setName_NotEqual(String name) {
        regName(CK_NE, fRES(name));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as greaterThan.
     */
    public void setName_GreaterThan(String name) {
        regName(CK_GT, fRES(name));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as lessThan.
     */
    public void setName_LessThan(String name) {
        regName(CK_LT, fRES(name));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as greaterEqual.
     */
    public void setName_GreaterEqual(String name) {
        regName(CK_GE, fRES(name));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as lessEqual.
     */
    public void setName_LessEqual(String name) {
        regName(CK_LE, fRES(name));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param name The value of name as prefixSearch.
     */
    public void setName_PrefixSearch(String name) {
        setName_LikeSearch(name, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param nameList The collection of name as inScope.
     */
    public void setName_InScope(Collection<String> nameList) {
        regINS(CK_INS, cTL(nameList), getCValueName(), "NAME");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param nameList The collection of name as notInScope.
     */
    public void setName_NotInScope(Collection<String> nameList) {
        regINS(CK_NINS, cTL(nameList), getCValueName(), "NAME");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param name The value of name as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setName_LikeSearch(String name,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(name), getCValueName(), "NAME", likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param name The value of name as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setName_NotLikeSearch(String name,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(name), getCValueName(), "NAME", likeSearchOption);
    }

    protected void regName(ConditionKey k, Object v) {
        regQ(k, v, getCValueName(), "NAME");
    }

    abstract protected ConditionValue getCValueName();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(4000)}
     * @param urls The value of urls as equal.
     */
    public void setUrls_Equal(String urls) {
        regUrls(CK_EQ, fRES(urls));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as notEqual.
     */
    public void setUrls_NotEqual(String urls) {
        regUrls(CK_NE, fRES(urls));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as greaterThan.
     */
    public void setUrls_GreaterThan(String urls) {
        regUrls(CK_GT, fRES(urls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as lessThan.
     */
    public void setUrls_LessThan(String urls) {
        regUrls(CK_LT, fRES(urls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as greaterEqual.
     */
    public void setUrls_GreaterEqual(String urls) {
        regUrls(CK_GE, fRES(urls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as lessEqual.
     */
    public void setUrls_LessEqual(String urls) {
        regUrls(CK_LE, fRES(urls));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param urls The value of urls as prefixSearch.
     */
    public void setUrls_PrefixSearch(String urls) {
        setUrls_LikeSearch(urls, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param urlsList The collection of urls as inScope.
     */
    public void setUrls_InScope(Collection<String> urlsList) {
        regINS(CK_INS, cTL(urlsList), getCValueUrls(), "URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param urlsList The collection of urls as notInScope.
     */
    public void setUrls_NotInScope(Collection<String> urlsList) {
        regINS(CK_NINS, cTL(urlsList), getCValueUrls(), "URLS");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param urls The value of urls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUrls_LikeSearch(String urls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(urls), getCValueUrls(), "URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param urls The value of urls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUrls_NotLikeSearch(String urls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(urls), getCValueUrls(), "URLS", likeSearchOption);
    }

    protected void regUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueUrls(), "URLS");
    }

    abstract protected ConditionValue getCValueUrls();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {VARCHAR(4000)}
     * @param includedUrls The value of includedUrls as equal.
     */
    public void setIncludedUrls_Equal(String includedUrls) {
        regIncludedUrls(CK_EQ, fRES(includedUrls));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as notEqual.
     */
    public void setIncludedUrls_NotEqual(String includedUrls) {
        regIncludedUrls(CK_NE, fRES(includedUrls));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as greaterThan.
     */
    public void setIncludedUrls_GreaterThan(String includedUrls) {
        regIncludedUrls(CK_GT, fRES(includedUrls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as lessThan.
     */
    public void setIncludedUrls_LessThan(String includedUrls) {
        regIncludedUrls(CK_LT, fRES(includedUrls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as greaterEqual.
     */
    public void setIncludedUrls_GreaterEqual(String includedUrls) {
        regIncludedUrls(CK_GE, fRES(includedUrls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as lessEqual.
     */
    public void setIncludedUrls_LessEqual(String includedUrls) {
        regIncludedUrls(CK_LE, fRES(includedUrls));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedUrls The value of includedUrls as prefixSearch.
     */
    public void setIncludedUrls_PrefixSearch(String includedUrls) {
        setIncludedUrls_LikeSearch(includedUrls, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param includedUrlsList The collection of includedUrls as inScope.
     */
    public void setIncludedUrls_InScope(Collection<String> includedUrlsList) {
        regINS(CK_INS, cTL(includedUrlsList), getCValueIncludedUrls(),
                "INCLUDED_URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param includedUrlsList The collection of includedUrls as notInScope.
     */
    public void setIncludedUrls_NotInScope(Collection<String> includedUrlsList) {
        regINS(CK_NINS, cTL(includedUrlsList), getCValueIncludedUrls(),
                "INCLUDED_URLS");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedUrls The value of includedUrls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setIncludedUrls_LikeSearch(String includedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(includedUrls), getCValueIncludedUrls(),
                "INCLUDED_URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedUrls The value of includedUrls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setIncludedUrls_NotLikeSearch(String includedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(includedUrls), getCValueIncludedUrls(),
                "INCLUDED_URLS", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setIncludedUrls_IsNull() {
        regIncludedUrls(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setIncludedUrls_IsNotNull() {
        regIncludedUrls(CK_ISNN, DOBJ);
    }

    protected void regIncludedUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueIncludedUrls(), "INCLUDED_URLS");
    }

    abstract protected ConditionValue getCValueIncludedUrls();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {VARCHAR(4000)}
     * @param excludedUrls The value of excludedUrls as equal.
     */
    public void setExcludedUrls_Equal(String excludedUrls) {
        regExcludedUrls(CK_EQ, fRES(excludedUrls));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as notEqual.
     */
    public void setExcludedUrls_NotEqual(String excludedUrls) {
        regExcludedUrls(CK_NE, fRES(excludedUrls));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as greaterThan.
     */
    public void setExcludedUrls_GreaterThan(String excludedUrls) {
        regExcludedUrls(CK_GT, fRES(excludedUrls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as lessThan.
     */
    public void setExcludedUrls_LessThan(String excludedUrls) {
        regExcludedUrls(CK_LT, fRES(excludedUrls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as greaterEqual.
     */
    public void setExcludedUrls_GreaterEqual(String excludedUrls) {
        regExcludedUrls(CK_GE, fRES(excludedUrls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as lessEqual.
     */
    public void setExcludedUrls_LessEqual(String excludedUrls) {
        regExcludedUrls(CK_LE, fRES(excludedUrls));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedUrls The value of excludedUrls as prefixSearch.
     */
    public void setExcludedUrls_PrefixSearch(String excludedUrls) {
        setExcludedUrls_LikeSearch(excludedUrls, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param excludedUrlsList The collection of excludedUrls as inScope.
     */
    public void setExcludedUrls_InScope(Collection<String> excludedUrlsList) {
        regINS(CK_INS, cTL(excludedUrlsList), getCValueExcludedUrls(),
                "EXCLUDED_URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param excludedUrlsList The collection of excludedUrls as notInScope.
     */
    public void setExcludedUrls_NotInScope(Collection<String> excludedUrlsList) {
        regINS(CK_NINS, cTL(excludedUrlsList), getCValueExcludedUrls(),
                "EXCLUDED_URLS");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedUrls The value of excludedUrls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setExcludedUrls_LikeSearch(String excludedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(excludedUrls), getCValueExcludedUrls(),
                "EXCLUDED_URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedUrls The value of excludedUrls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setExcludedUrls_NotLikeSearch(String excludedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(excludedUrls), getCValueExcludedUrls(),
                "EXCLUDED_URLS", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setExcludedUrls_IsNull() {
        regExcludedUrls(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setExcludedUrls_IsNotNull() {
        regExcludedUrls(CK_ISNN, DOBJ);
    }

    protected void regExcludedUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueExcludedUrls(), "EXCLUDED_URLS");
    }

    abstract protected ConditionValue getCValueExcludedUrls();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {INTEGER}
     * @param depth The value of depth as equal.
     */
    public void setDepth_Equal(Integer depth) {
        regDepth(CK_EQ, depth);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as notEqual.
     */
    public void setDepth_NotEqual(Integer depth) {
        regDepth(CK_NE, depth);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as greaterThan.
     */
    public void setDepth_GreaterThan(Integer depth) {
        regDepth(CK_GT, depth);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as lessThan.
     */
    public void setDepth_LessThan(Integer depth) {
        regDepth(CK_LT, depth);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as greaterEqual.
     */
    public void setDepth_GreaterEqual(Integer depth) {
        regDepth(CK_GE, depth);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as lessEqual.
     */
    public void setDepth_LessEqual(Integer depth) {
        regDepth(CK_LE, depth);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param depthList The collection of depth as inScope.
     */
    public void setDepth_InScope(Collection<Integer> depthList) {
        regINS(CK_INS, cTL(depthList), getCValueDepth(), "DEPTH");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param depthList The collection of depth as notInScope.
     */
    public void setDepth_NotInScope(Collection<Integer> depthList) {
        regINS(CK_NINS, cTL(depthList), getCValueDepth(), "DEPTH");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDepth_IsNull() {
        regDepth(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDepth_IsNotNull() {
        regDepth(CK_ISNN, DOBJ);
    }

    protected void regDepth(ConditionKey k, Object v) {
        regQ(k, v, getCValueDepth(), "DEPTH");
    }

    abstract protected ConditionValue getCValueDepth();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {BIGINT}
     * @param maxAccessCount The value of maxAccessCount as equal.
     */
    public void setMaxAccessCount_Equal(Long maxAccessCount) {
        regMaxAccessCount(CK_EQ, maxAccessCount);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as notEqual.
     */
    public void setMaxAccessCount_NotEqual(Long maxAccessCount) {
        regMaxAccessCount(CK_NE, maxAccessCount);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as greaterThan.
     */
    public void setMaxAccessCount_GreaterThan(Long maxAccessCount) {
        regMaxAccessCount(CK_GT, maxAccessCount);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as lessThan.
     */
    public void setMaxAccessCount_LessThan(Long maxAccessCount) {
        regMaxAccessCount(CK_LT, maxAccessCount);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as greaterEqual.
     */
    public void setMaxAccessCount_GreaterEqual(Long maxAccessCount) {
        regMaxAccessCount(CK_GE, maxAccessCount);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as lessEqual.
     */
    public void setMaxAccessCount_LessEqual(Long maxAccessCount) {
        regMaxAccessCount(CK_LE, maxAccessCount);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param maxAccessCountList The collection of maxAccessCount as inScope.
     */
    public void setMaxAccessCount_InScope(Collection<Long> maxAccessCountList) {
        regINS(CK_INS, cTL(maxAccessCountList), getCValueMaxAccessCount(),
                "MAX_ACCESS_COUNT");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param maxAccessCountList The collection of maxAccessCount as notInScope.
     */
    public void setMaxAccessCount_NotInScope(Collection<Long> maxAccessCountList) {
        regINS(CK_NINS, cTL(maxAccessCountList), getCValueMaxAccessCount(),
                "MAX_ACCESS_COUNT");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setMaxAccessCount_IsNull() {
        regMaxAccessCount(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setMaxAccessCount_IsNotNull() {
        regMaxAccessCount(CK_ISNN, DOBJ);
    }

    protected void regMaxAccessCount(ConditionKey k, Object v) {
        regQ(k, v, getCValueMaxAccessCount(), "MAX_ACCESS_COUNT");
    }

    abstract protected ConditionValue getCValueMaxAccessCount();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(200)}
     * @param userAgent The value of userAgent as equal.
     */
    public void setUserAgent_Equal(String userAgent) {
        regUserAgent(CK_EQ, fRES(userAgent));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as notEqual.
     */
    public void setUserAgent_NotEqual(String userAgent) {
        regUserAgent(CK_NE, fRES(userAgent));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as greaterThan.
     */
    public void setUserAgent_GreaterThan(String userAgent) {
        regUserAgent(CK_GT, fRES(userAgent));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as lessThan.
     */
    public void setUserAgent_LessThan(String userAgent) {
        regUserAgent(CK_LT, fRES(userAgent));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as greaterEqual.
     */
    public void setUserAgent_GreaterEqual(String userAgent) {
        regUserAgent(CK_GE, fRES(userAgent));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as lessEqual.
     */
    public void setUserAgent_LessEqual(String userAgent) {
        regUserAgent(CK_LE, fRES(userAgent));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as prefixSearch.
     */
    public void setUserAgent_PrefixSearch(String userAgent) {
        setUserAgent_LikeSearch(userAgent, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userAgentList The collection of userAgent as inScope.
     */
    public void setUserAgent_InScope(Collection<String> userAgentList) {
        regINS(CK_INS, cTL(userAgentList), getCValueUserAgent(), "USER_AGENT");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userAgentList The collection of userAgent as notInScope.
     */
    public void setUserAgent_NotInScope(Collection<String> userAgentList) {
        regINS(CK_NINS, cTL(userAgentList), getCValueUserAgent(), "USER_AGENT");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUserAgent_LikeSearch(String userAgent,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(userAgent), getCValueUserAgent(), "USER_AGENT",
                likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUserAgent_NotLikeSearch(String userAgent,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(userAgent), getCValueUserAgent(), "USER_AGENT",
                likeSearchOption);
    }

    protected void regUserAgent(ConditionKey k, Object v) {
        regQ(k, v, getCValueUserAgent(), "USER_AGENT");
    }

    abstract protected ConditionValue getCValueUserAgent();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : INTEGER}
     * @param numOfThread The value of numOfThread as equal.
     */
    public void setNumOfThread_Equal(Integer numOfThread) {
        regNumOfThread(CK_EQ, numOfThread);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as notEqual.
     */
    public void setNumOfThread_NotEqual(Integer numOfThread) {
        regNumOfThread(CK_NE, numOfThread);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as greaterThan.
     */
    public void setNumOfThread_GreaterThan(Integer numOfThread) {
        regNumOfThread(CK_GT, numOfThread);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as lessThan.
     */
    public void setNumOfThread_LessThan(Integer numOfThread) {
        regNumOfThread(CK_LT, numOfThread);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as greaterEqual.
     */
    public void setNumOfThread_GreaterEqual(Integer numOfThread) {
        regNumOfThread(CK_GE, numOfThread);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as lessEqual.
     */
    public void setNumOfThread_LessEqual(Integer numOfThread) {
        regNumOfThread(CK_LE, numOfThread);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param numOfThreadList The collection of numOfThread as inScope.
     */
    public void setNumOfThread_InScope(Collection<Integer> numOfThreadList) {
        regINS(CK_INS, cTL(numOfThreadList), getCValueNumOfThread(),
                "NUM_OF_THREAD");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param numOfThreadList The collection of numOfThread as notInScope.
     */
    public void setNumOfThread_NotInScope(Collection<Integer> numOfThreadList) {
        regINS(CK_NINS, cTL(numOfThreadList), getCValueNumOfThread(),
                "NUM_OF_THREAD");
    }

    protected void regNumOfThread(ConditionKey k, Object v) {
        regQ(k, v, getCValueNumOfThread(), "NUM_OF_THREAD");
    }

    abstract protected ConditionValue getCValueNumOfThread();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : INTEGER}
     * @param intervalTime The value of intervalTime as equal.
     */
    public void setIntervalTime_Equal(Integer intervalTime) {
        regIntervalTime(CK_EQ, intervalTime);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as notEqual.
     */
    public void setIntervalTime_NotEqual(Integer intervalTime) {
        regIntervalTime(CK_NE, intervalTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as greaterThan.
     */
    public void setIntervalTime_GreaterThan(Integer intervalTime) {
        regIntervalTime(CK_GT, intervalTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as lessThan.
     */
    public void setIntervalTime_LessThan(Integer intervalTime) {
        regIntervalTime(CK_LT, intervalTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as greaterEqual.
     */
    public void setIntervalTime_GreaterEqual(Integer intervalTime) {
        regIntervalTime(CK_GE, intervalTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as lessEqual.
     */
    public void setIntervalTime_LessEqual(Integer intervalTime) {
        regIntervalTime(CK_LE, intervalTime);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param intervalTimeList The collection of intervalTime as inScope.
     */
    public void setIntervalTime_InScope(Collection<Integer> intervalTimeList) {
        regINS(CK_INS, cTL(intervalTimeList), getCValueIntervalTime(),
                "INTERVAL_TIME");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param intervalTimeList The collection of intervalTime as notInScope.
     */
    public void setIntervalTime_NotInScope(Collection<Integer> intervalTimeList) {
        regINS(CK_NINS, cTL(intervalTimeList), getCValueIntervalTime(),
                "INTERVAL_TIME");
    }

    protected void regIntervalTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueIntervalTime(), "INTERVAL_TIME");
    }

    abstract protected ConditionValue getCValueIntervalTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(1)}
     * @param available The value of available as equal.
     */
    public void setAvailable_Equal(String available) {
        regAvailable(CK_EQ, fRES(available));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as notEqual.
     */
    public void setAvailable_NotEqual(String available) {
        regAvailable(CK_NE, fRES(available));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as greaterThan.
     */
    public void setAvailable_GreaterThan(String available) {
        regAvailable(CK_GT, fRES(available));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as lessThan.
     */
    public void setAvailable_LessThan(String available) {
        regAvailable(CK_LT, fRES(available));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as greaterEqual.
     */
    public void setAvailable_GreaterEqual(String available) {
        regAvailable(CK_GE, fRES(available));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as lessEqual.
     */
    public void setAvailable_LessEqual(String available) {
        regAvailable(CK_LE, fRES(available));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param available The value of available as prefixSearch.
     */
    public void setAvailable_PrefixSearch(String available) {
        setAvailable_LikeSearch(available, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param availableList The collection of available as inScope.
     */
    public void setAvailable_InScope(Collection<String> availableList) {
        regINS(CK_INS, cTL(availableList), getCValueAvailable(), "AVAILABLE");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param availableList The collection of available as notInScope.
     */
    public void setAvailable_NotInScope(Collection<String> availableList) {
        regINS(CK_NINS, cTL(availableList), getCValueAvailable(), "AVAILABLE");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param available The value of available as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setAvailable_LikeSearch(String available,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(available), getCValueAvailable(), "AVAILABLE",
                likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param available The value of available as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setAvailable_NotLikeSearch(String available,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(available), getCValueAvailable(), "AVAILABLE",
                likeSearchOption);
    }

    protected void regAvailable(ConditionKey k, Object v) {
        regQ(k, v, getCValueAvailable(), "AVAILABLE");
    }

    abstract protected ConditionValue getCValueAvailable();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : INTEGER}
     * @param sortOrder The value of sortOrder as equal.
     */
    public void setSortOrder_Equal(Integer sortOrder) {
        regSortOrder(CK_EQ, sortOrder);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as notEqual.
     */
    public void setSortOrder_NotEqual(Integer sortOrder) {
        regSortOrder(CK_NE, sortOrder);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as greaterThan.
     */
    public void setSortOrder_GreaterThan(Integer sortOrder) {
        regSortOrder(CK_GT, sortOrder);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as lessThan.
     */
    public void setSortOrder_LessThan(Integer sortOrder) {
        regSortOrder(CK_LT, sortOrder);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as greaterEqual.
     */
    public void setSortOrder_GreaterEqual(Integer sortOrder) {
        regSortOrder(CK_GE, sortOrder);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as lessEqual.
     */
    public void setSortOrder_LessEqual(Integer sortOrder) {
        regSortOrder(CK_LE, sortOrder);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param sortOrderList The collection of sortOrder as inScope.
     */
    public void setSortOrder_InScope(Collection<Integer> sortOrderList) {
        regINS(CK_INS, cTL(sortOrderList), getCValueSortOrder(), "SORT_ORDER");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param sortOrderList The collection of sortOrder as notInScope.
     */
    public void setSortOrder_NotInScope(Collection<Integer> sortOrderList) {
        regINS(CK_NINS, cTL(sortOrderList), getCValueSortOrder(), "SORT_ORDER");
    }

    protected void regSortOrder(ConditionKey k, Object v) {
        regQ(k, v, getCValueSortOrder(), "SORT_ORDER");
    }

    abstract protected ConditionValue getCValueSortOrder();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(255)}
     * @param createdBy The value of createdBy as equal.
     */
    public void setCreatedBy_Equal(String createdBy) {
        regCreatedBy(CK_EQ, fRES(createdBy));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as notEqual.
     */
    public void setCreatedBy_NotEqual(String createdBy) {
        regCreatedBy(CK_NE, fRES(createdBy));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as greaterThan.
     */
    public void setCreatedBy_GreaterThan(String createdBy) {
        regCreatedBy(CK_GT, fRES(createdBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as lessThan.
     */
    public void setCreatedBy_LessThan(String createdBy) {
        regCreatedBy(CK_LT, fRES(createdBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as greaterEqual.
     */
    public void setCreatedBy_GreaterEqual(String createdBy) {
        regCreatedBy(CK_GE, fRES(createdBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as lessEqual.
     */
    public void setCreatedBy_LessEqual(String createdBy) {
        regCreatedBy(CK_LE, fRES(createdBy));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as prefixSearch.
     */
    public void setCreatedBy_PrefixSearch(String createdBy) {
        setCreatedBy_LikeSearch(createdBy, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param createdByList The collection of createdBy as inScope.
     */
    public void setCreatedBy_InScope(Collection<String> createdByList) {
        regINS(CK_INS, cTL(createdByList), getCValueCreatedBy(), "CREATED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param createdByList The collection of createdBy as notInScope.
     */
    public void setCreatedBy_NotInScope(Collection<String> createdByList) {
        regINS(CK_NINS, cTL(createdByList), getCValueCreatedBy(), "CREATED_BY");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setCreatedBy_LikeSearch(String createdBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(createdBy), getCValueCreatedBy(), "CREATED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setCreatedBy_NotLikeSearch(String createdBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(createdBy), getCValueCreatedBy(), "CREATED_BY",
                likeSearchOption);
    }

    protected void regCreatedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedBy(), "CREATED_BY");
    }

    abstract protected ConditionValue getCValueCreatedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param createdTime The value of createdTime as equal.
     */
    public void setCreatedTime_Equal(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_EQ, createdTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterThan.
     */
    public void setCreatedTime_GreaterThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GT, createdTime);
    }

    /**
     * LessThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessThan.
     */
    public void setCreatedTime_LessThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LT, createdTime);
    }

    /**
     * GreaterEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterEqual.
     */
    public void setCreatedTime_GreaterEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GE, createdTime);
    }

    /**
     * LessEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessEqual.
     */
    public void setCreatedTime_LessEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LE, createdTime);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt;= toDate). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param fromDate The from-date of createdTime. (Nullable)
     * @param toDate The to-date of createdTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setCreatedTime_FromTo(java.util.Date fromDate,
            java.util.Date toDate, FromToOption fromToOption) {
        regFTQ((fromDate != null ? new java.sql.Timestamp(fromDate.getTime())
                : null), (toDate != null ? new java.sql.Timestamp(toDate
                .getTime()) : null), getCValueCreatedTime(), "CREATED_TIME",
                fromToOption);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt; toDate + 1). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param fromDate The from-date of createdTime. (Nullable)
     * @param toDate The to-date of createdTime. (Nullable)
     */
    public void setCreatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setCreatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected void regCreatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedTime(), "CREATED_TIME");
    }

    abstract protected ConditionValue getCValueCreatedTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {VARCHAR(255)}
     * @param updatedBy The value of updatedBy as equal.
     */
    public void setUpdatedBy_Equal(String updatedBy) {
        regUpdatedBy(CK_EQ, fRES(updatedBy));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as notEqual.
     */
    public void setUpdatedBy_NotEqual(String updatedBy) {
        regUpdatedBy(CK_NE, fRES(updatedBy));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as greaterThan.
     */
    public void setUpdatedBy_GreaterThan(String updatedBy) {
        regUpdatedBy(CK_GT, fRES(updatedBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as lessThan.
     */
    public void setUpdatedBy_LessThan(String updatedBy) {
        regUpdatedBy(CK_LT, fRES(updatedBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as greaterEqual.
     */
    public void setUpdatedBy_GreaterEqual(String updatedBy) {
        regUpdatedBy(CK_GE, fRES(updatedBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as lessEqual.
     */
    public void setUpdatedBy_LessEqual(String updatedBy) {
        regUpdatedBy(CK_LE, fRES(updatedBy));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as prefixSearch.
     */
    public void setUpdatedBy_PrefixSearch(String updatedBy) {
        setUpdatedBy_LikeSearch(updatedBy, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param updatedByList The collection of updatedBy as inScope.
     */
    public void setUpdatedBy_InScope(Collection<String> updatedByList) {
        regINS(CK_INS, cTL(updatedByList), getCValueUpdatedBy(), "UPDATED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param updatedByList The collection of updatedBy as notInScope.
     */
    public void setUpdatedBy_NotInScope(Collection<String> updatedByList) {
        regINS(CK_NINS, cTL(updatedByList), getCValueUpdatedBy(), "UPDATED_BY");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUpdatedBy_LikeSearch(String updatedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(updatedBy), getCValueUpdatedBy(), "UPDATED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUpdatedBy_NotLikeSearch(String updatedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(updatedBy), getCValueUpdatedBy(), "UPDATED_BY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUpdatedBy_IsNull() {
        regUpdatedBy(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUpdatedBy_IsNotNull() {
        regUpdatedBy(CK_ISNN, DOBJ);
    }

    protected void regUpdatedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueUpdatedBy(), "UPDATED_BY");
    }

    abstract protected ConditionValue getCValueUpdatedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {TIMESTAMP}
     * @param updatedTime The value of updatedTime as equal.
     */
    public void setUpdatedTime_Equal(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_EQ, updatedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as greaterThan.
     */
    public void setUpdatedTime_GreaterThan(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_GT, updatedTime);
    }

    /**
     * LessThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as lessThan.
     */
    public void setUpdatedTime_LessThan(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_LT, updatedTime);
    }

    /**
     * GreaterEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as greaterEqual.
     */
    public void setUpdatedTime_GreaterEqual(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_GE, updatedTime);
    }

    /**
     * LessEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as lessEqual.
     */
    public void setUpdatedTime_LessEqual(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_LE, updatedTime);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt;= toDate). And NullIgnored, OnlyOnceRegistered. {TIMESTAMP}
     * @param fromDate The from-date of updatedTime. (Nullable)
     * @param toDate The to-date of updatedTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setUpdatedTime_FromTo(java.util.Date fromDate,
            java.util.Date toDate, FromToOption fromToOption) {
        regFTQ((fromDate != null ? new java.sql.Timestamp(fromDate.getTime())
                : null), (toDate != null ? new java.sql.Timestamp(toDate
                .getTime()) : null), getCValueUpdatedTime(), "UPDATED_TIME",
                fromToOption);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt; toDate + 1). And NullIgnored, OnlyOnceRegistered. {TIMESTAMP}
     * @param fromDate The from-date of updatedTime. (Nullable)
     * @param toDate The to-date of updatedTime. (Nullable)
     */
    public void setUpdatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setUpdatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUpdatedTime_IsNull() {
        regUpdatedTime(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUpdatedTime_IsNotNull() {
        regUpdatedTime(CK_ISNN, DOBJ);
    }

    protected void regUpdatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueUpdatedTime(), "UPDATED_TIME");
    }

    abstract protected ConditionValue getCValueUpdatedTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {VARCHAR(255)}
     * @param deletedBy The value of deletedBy as equal.
     */
    public void setDeletedBy_Equal(String deletedBy) {
        regDeletedBy(CK_EQ, fRES(deletedBy));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as notEqual.
     */
    public void setDeletedBy_NotEqual(String deletedBy) {
        regDeletedBy(CK_NE, fRES(deletedBy));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as greaterThan.
     */
    public void setDeletedBy_GreaterThan(String deletedBy) {
        regDeletedBy(CK_GT, fRES(deletedBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as lessThan.
     */
    public void setDeletedBy_LessThan(String deletedBy) {
        regDeletedBy(CK_LT, fRES(deletedBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as greaterEqual.
     */
    public void setDeletedBy_GreaterEqual(String deletedBy) {
        regDeletedBy(CK_GE, fRES(deletedBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as lessEqual.
     */
    public void setDeletedBy_LessEqual(String deletedBy) {
        regDeletedBy(CK_LE, fRES(deletedBy));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as prefixSearch.
     */
    public void setDeletedBy_PrefixSearch(String deletedBy) {
        setDeletedBy_LikeSearch(deletedBy, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param deletedByList The collection of deletedBy as inScope.
     */
    public void setDeletedBy_InScope(Collection<String> deletedByList) {
        regINS(CK_INS, cTL(deletedByList), getCValueDeletedBy(), "DELETED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param deletedByList The collection of deletedBy as notInScope.
     */
    public void setDeletedBy_NotInScope(Collection<String> deletedByList) {
        regINS(CK_NINS, cTL(deletedByList), getCValueDeletedBy(), "DELETED_BY");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setDeletedBy_LikeSearch(String deletedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(deletedBy), getCValueDeletedBy(), "DELETED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setDeletedBy_NotLikeSearch(String deletedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(deletedBy), getCValueDeletedBy(), "DELETED_BY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDeletedBy_IsNull() {
        regDeletedBy(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDeletedBy_IsNotNull() {
        regDeletedBy(CK_ISNN, DOBJ);
    }

    protected void regDeletedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueDeletedBy(), "DELETED_BY");
    }

    abstract protected ConditionValue getCValueDeletedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {TIMESTAMP}
     * @param deletedTime The value of deletedTime as equal.
     */
    public void setDeletedTime_Equal(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_EQ, deletedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as greaterThan.
     */
    public void setDeletedTime_GreaterThan(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_GT, deletedTime);
    }

    /**
     * LessThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as lessThan.
     */
    public void setDeletedTime_LessThan(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_LT, deletedTime);
    }

    /**
     * GreaterEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as greaterEqual.
     */
    public void setDeletedTime_GreaterEqual(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_GE, deletedTime);
    }

    /**
     * LessEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as lessEqual.
     */
    public void setDeletedTime_LessEqual(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_LE, deletedTime);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt;= toDate). And NullIgnored, OnlyOnceRegistered. {TIMESTAMP}
     * @param fromDate The from-date of deletedTime. (Nullable)
     * @param toDate The to-date of deletedTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setDeletedTime_FromTo(java.util.Date fromDate,
            java.util.Date toDate, FromToOption fromToOption) {
        regFTQ((fromDate != null ? new java.sql.Timestamp(fromDate.getTime())
                : null), (toDate != null ? new java.sql.Timestamp(toDate
                .getTime()) : null), getCValueDeletedTime(), "DELETED_TIME",
                fromToOption);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt; toDate + 1). And NullIgnored, OnlyOnceRegistered. {TIMESTAMP}
     * @param fromDate The from-date of deletedTime. (Nullable)
     * @param toDate The to-date of deletedTime. (Nullable)
     */
    public void setDeletedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setDeletedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDeletedTime_IsNull() {
        regDeletedTime(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDeletedTime_IsNotNull() {
        regDeletedTime(CK_ISNN, DOBJ);
    }

    protected void regDeletedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueDeletedTime(), "DELETED_TIME");
    }

    abstract protected ConditionValue getCValueDeletedTime();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : INTEGER}
     * @param versionNo The value of versionNo as equal.
     */
    public void setVersionNo_Equal(Integer versionNo) {
        regVersionNo(CK_EQ, versionNo);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as notEqual.
     */
    public void setVersionNo_NotEqual(Integer versionNo) {
        regVersionNo(CK_NE, versionNo);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as greaterThan.
     */
    public void setVersionNo_GreaterThan(Integer versionNo) {
        regVersionNo(CK_GT, versionNo);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as lessThan.
     */
    public void setVersionNo_LessThan(Integer versionNo) {
        regVersionNo(CK_LT, versionNo);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as greaterEqual.
     */
    public void setVersionNo_GreaterEqual(Integer versionNo) {
        regVersionNo(CK_GE, versionNo);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as lessEqual.
     */
    public void setVersionNo_LessEqual(Integer versionNo) {
        regVersionNo(CK_LE, versionNo);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param versionNoList The collection of versionNo as inScope.
     */
    public void setVersionNo_InScope(Collection<Integer> versionNoList) {
        regINS(CK_INS, cTL(versionNoList), getCValueVersionNo(), "VERSION_NO");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param versionNoList The collection of versionNo as notInScope.
     */
    public void setVersionNo_NotInScope(Collection<Integer> versionNoList) {
        regINS(CK_NINS, cTL(versionNoList), getCValueVersionNo(), "VERSION_NO");
    }

    protected void regVersionNo(ConditionKey k, Object v) {
        regQ(k, v, getCValueVersionNo(), "VERSION_NO");
    }

    abstract protected ConditionValue getCValueVersionNo();

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    public SSQFunction<WebCrawlingConfigCB> scalar_Equal() {
        return xcreateSSQFunction("=");
    }

    public SSQFunction<WebCrawlingConfigCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(">=");
    }

    public SSQFunction<WebCrawlingConfigCB> scalar_GreaterThan() {
        return xcreateSSQFunction(">");
    }

    public SSQFunction<WebCrawlingConfigCB> scalar_LessEqual() {
        return xcreateSSQFunction("<=");
    }

    public SSQFunction<WebCrawlingConfigCB> scalar_LessThan() {
        return xcreateSSQFunction("<");
    }

    protected SSQFunction<WebCrawlingConfigCB> xcreateSSQFunction(
            final String operand) {
        return new SSQFunction<WebCrawlingConfigCB>(
                new SSQSetupper<WebCrawlingConfigCB>() {
                    public void setup(String function,
                            SubQuery<WebCrawlingConfigCB> subQuery) {
                        xscalarSubQuery(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarSubQuery(String function,
            SubQuery<WebCrawlingConfigCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<WebCrawlingConfigCB>", subQuery);
        WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
        cb.xsetupForScalarSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarSubQuery(cb.query()); // for saving query-value.
        registerScalarSubQuery(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarSubQuery(WebCrawlingConfigCQ subQuery);

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    /**
     * Myself InScope SubQuery. {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<WebCrawlingConfigCB> subQuery) {
        assertObjectNotNull("subQuery<WebCrawlingConfigCB>", subQuery);
        WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeSubQuery(cb.query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeSubQuery(
            WebCrawlingConfigCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return WebCrawlingConfigCB.class.getName();
    }

    String xCQ() {
        return WebCrawlingConfigCQ.class.getName();
    }

    String xLSO() {
        return LikeSearchOption.class.getName();
    }
}
