package jp.sf.fess.entity;

import org.seasar.framework.util.StringUtil;

public class GeoInfo {
    public String latitude;

    public String longitude;

    public double distance;

    private boolean isInit = false;

    private double lat;

    private double lon;

    private synchronized void init() {
        if (!isInit) {
            isInit = true;

            if (StringUtil.isBlank(latitude) || StringUtil.isBlank(longitude)) {
                latitude = null;
                longitude = null;
                return;
            }

            try {
                lat = Double.parseDouble(latitude);
                lon = Double.parseDouble(longitude);

                if (lat > 90) {
                    lat = 90;
                } else if (lat < -90) {
                    lat = -90;
                }

                if (lon > 180) {
                    lon = lon % 360;
                    if (lon > 180) {
                        lon -= 360;
                    }
                } else if (lon < -180) {
                    lon = lon % 360;
                    if (lon < -180) {
                        lon += 360;
                    }
                }

                latitude = Double.toString(lat);
                longitude = Double.toString(lon);
            } catch (final NumberFormatException e) {
                latitude = null;
                longitude = null;
            }
        }
    }

    public boolean isAvailable() {
        init();
        return StringUtil.isNotBlank(latitude)
                && StringUtil.isNotBlank(longitude) && distance > 0;
    }

    public String toGeoQueryString() {
        init();
        return "{!geofilt pt=" + latitude + "," + longitude
                + " sfield=location d=" + Double.toString(distance) + "}";
    }
}
