/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of REQUEST_HEADER that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, WEB_CRAWLING_CONFIG_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsRequestHeader implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK : ID : NotNull : BIGINT} */
    protected Long _id;

    /** NAME: {NotNull : VARCHAR(100)} */
    protected String _name;

    /** VALUE: {NotNull : VARCHAR(1000)} */
    protected String _value;

    /** WEB_CRAWLING_CONFIG_ID: {NotNull : BIGINT : FK to WEB_CRAWLING_CONFIG} */
    protected Long _webCrawlingConfigId;

    /** CREATED_BY: {NotNull : VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull : TIMESTAMP} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull : INTEGER} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The attribute of entity modified properties. (for S2Dao) */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "REQUEST_HEADER";
    }

    public String getTablePropertyName() { // as JavaBeansRule
        return "requestHeader";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                          Classification Classifying
    //                                                          ==========================
    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    /** WEB_CRAWLING_CONFIG as 'webCrawlingConfig'. */
    protected WebCrawlingConfig _parentWebCrawlingConfig;

    /**
     * WEB_CRAWLING_CONFIG as 'webCrawlingConfig'. {without lazy-load}
     * @return The entity of foreign property 'webCrawlingConfig'. (Nullable: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public WebCrawlingConfig getWebCrawlingConfig() {
        return _parentWebCrawlingConfig;
    }

    /**
     * WEB_CRAWLING_CONFIG as 'webCrawlingConfig'.
     * @param webCrawlingConfig The entity of foreign property 'webCrawlingConfig'. (Nullable)
     */
    public void setWebCrawlingConfig(WebCrawlingConfig webCrawlingConfig) {
        _parentWebCrawlingConfig = webCrawlingConfig;
    }

    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    // ===================================================================================
    //                                                                       Determination
    //                                                                       =============
    public boolean hasPrimaryKeyValue() {
        if (_id == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If the primary-key of the other is same as this one, returns true.
     * @param other Other entity.
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsRequestHeader)) {
            return false;
        }
        BsRequestHeader otherEntity = (BsRequestHeader) other;
        if (!helpComparingValue(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean helpComparingValue(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.equals(value2);
    }

    /**
     * Calculates hash-code from primary-key.
     * @return Hash-code from primary-key.
     */
    public int hashCode() {
        int result = 17;
        if (getId() != null) {
            result = (31 * result) + getId().hashCode();
        }
        return result;
    }

    /**
     * @return The view string of all columns. (NotNull)
     */
    public String toString() {
        String delimiter = ",";
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter).append(getId());
        sb.append(delimiter).append(getName());
        sb.append(delimiter).append(getValue());
        sb.append(delimiter).append(getWebCrawlingConfigId());
        sb.append(delimiter).append(getCreatedBy());
        sb.append(delimiter).append(getCreatedTime());
        sb.append(delimiter).append(getUpdatedBy());
        sb.append(delimiter).append(getUpdatedTime());
        sb.append(delimiter).append(getDeletedBy());
        sb.append(delimiter).append(getDeletedTime());
        sb.append(delimiter).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, delimiter.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * NAME: {NotNull : VARCHAR(100)} <br />
     * @return The value of the column 'NAME'. (Nullable)
     */
    public String getName() {
        return _name;
    }

    /**
     * NAME: {NotNull : VARCHAR(100)} <br />
     * @param name The value of the column 'NAME'. (Nullable)
     */
    public void setName(String name) {
        _modifiedProperties.addPropertyName("name");
        this._name = name;
    }

    /**
     * VALUE: {NotNull : VARCHAR(1000)} <br />
     * @return The value of the column 'VALUE'. (Nullable)
     */
    public String getValue() {
        return _value;
    }

    /**
     * VALUE: {NotNull : VARCHAR(1000)} <br />
     * @param value The value of the column 'VALUE'. (Nullable)
     */
    public void setValue(String value) {
        _modifiedProperties.addPropertyName("value");
        this._value = value;
    }

    /**
     * WEB_CRAWLING_CONFIG_ID: {NotNull : BIGINT : FK to WEB_CRAWLING_CONFIG} <br />
     * @return The value of the column 'WEB_CRAWLING_CONFIG_ID'. (Nullable)
     */
    public Long getWebCrawlingConfigId() {
        return _webCrawlingConfigId;
    }

    /**
     * WEB_CRAWLING_CONFIG_ID: {NotNull : BIGINT : FK to WEB_CRAWLING_CONFIG} <br />
     * @param webCrawlingConfigId The value of the column 'WEB_CRAWLING_CONFIG_ID'. (Nullable)
     */
    public void setWebCrawlingConfigId(Long webCrawlingConfigId) {
        _modifiedProperties.addPropertyName("webCrawlingConfigId");
        this._webCrawlingConfigId = webCrawlingConfigId;
    }

    /**
     * CREATED_BY: {NotNull : VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (Nullable)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * CREATED_BY: {NotNull : VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (Nullable)
     */
    public void setCreatedBy(String createdBy) {
        _modifiedProperties.addPropertyName("createdBy");
        this._createdBy = createdBy;
    }

    /**
     * CREATED_TIME: {NotNull : TIMESTAMP} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * CREATED_TIME: {NotNull : TIMESTAMP} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }

    /**
     * UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (Nullable)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (Nullable)
     */
    public void setUpdatedBy(String updatedBy) {
        _modifiedProperties.addPropertyName("updatedBy");
        this._updatedBy = updatedBy;
    }

    /**
     * UPDATED_TIME: {TIMESTAMP} <br />
     * @return The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * UPDATED_TIME: {TIMESTAMP} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public void setUpdatedTime(java.sql.Timestamp updatedTime) {
        _modifiedProperties.addPropertyName("updatedTime");
        this._updatedTime = updatedTime;
    }

    /**
     * DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (Nullable)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (Nullable)
     */
    public void setDeletedBy(String deletedBy) {
        _modifiedProperties.addPropertyName("deletedBy");
        this._deletedBy = deletedBy;
    }

    /**
     * DELETED_TIME: {TIMESTAMP} <br />
     * @return The value of the column 'DELETED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * DELETED_TIME: {TIMESTAMP} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (Nullable)
     */
    public void setDeletedTime(java.sql.Timestamp deletedTime) {
        _modifiedProperties.addPropertyName("deletedTime");
        this._deletedTime = deletedTime;
    }

    /**
     * VERSION_NO: {NotNull : INTEGER} <br />
     * @return The value of the column 'VERSION_NO'. (Nullable)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * VERSION_NO: {NotNull : INTEGER} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (Nullable)
     */
    public void setVersionNo(Integer versionNo) {
        _modifiedProperties.addPropertyName("versionNo");
        this._versionNo = versionNo;
    }
}
