/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of WEB_CRAWLING_CONFIG. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class WebCrawlingConfigDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final WebCrawlingConfigDbm _instance = new WebCrawlingConfigDbm();

    private WebCrawlingConfigDbm() {
    }

    public static WebCrawlingConfigDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    public String getTablePropertyName() {
        return "webCrawlingConfig";
    }

    public String getTableSqlName() {
        return "WEB_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected ColumnInfo _columnId = cci("ID", null, "id", Long.class, true,
            true, null, null);

    protected ColumnInfo _columnName = cci("NAME", null, "name", String.class,
            false, false, 200, 0);

    protected ColumnInfo _columnUrls = cci("URLS", null, "urls", String.class,
            false, false, 4000, 0);

    protected ColumnInfo _columnIncludedUrls = cci("INCLUDED_URLS", null,
            "includedUrls", String.class, false, false, 4000, 0);

    protected ColumnInfo _columnExcludedUrls = cci("EXCLUDED_URLS", null,
            "excludedUrls", String.class, false, false, 4000, 0);

    protected ColumnInfo _columnIncludedDocUrls = cci("INCLUDED_DOC_URLS",
            null, "includedDocUrls", String.class, false, false, 4000, 0);

    protected ColumnInfo _columnExcludedDocUrls = cci("EXCLUDED_DOC_URLS",
            null, "excludedDocUrls", String.class, false, false, 4000, 0);

    protected ColumnInfo _columnDepth = cci("DEPTH", null, "depth",
            Integer.class, false, false, null, null);

    protected ColumnInfo _columnMaxAccessCount = cci("MAX_ACCESS_COUNT", null,
            "maxAccessCount", Long.class, false, false, null, null);

    protected ColumnInfo _columnUserAgent = cci("USER_AGENT", null,
            "userAgent", String.class, false, false, 200, 0);

    protected ColumnInfo _columnNumOfThread = cci("NUM_OF_THREAD", null,
            "numOfThread", Integer.class, false, false, null, null);

    protected ColumnInfo _columnIntervalTime = cci("INTERVAL_TIME", null,
            "intervalTime", Integer.class, false, false, null, null);

    protected ColumnInfo _columnBoost = cci("BOOST", null, "boost",
            java.math.BigDecimal.class, false, false, null, null);

    protected ColumnInfo _columnAvailable = cci("AVAILABLE", null, "available",
            String.class, false, false, 1, 0);

    protected ColumnInfo _columnSortOrder = cci("SORT_ORDER", null,
            "sortOrder", Integer.class, false, false, null, null);

    protected ColumnInfo _columnCreatedBy = cci("CREATED_BY", null,
            "createdBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnCreatedTime = cci("CREATED_TIME", null,
            "createdTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnUpdatedBy = cci("UPDATED_BY", null,
            "updatedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME", null,
            "updatedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnDeletedBy = cci("DELETED_BY", null,
            "deletedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnDeletedTime = cci("DELETED_TIME", null,
            "deletedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnVersionNo = cci("VERSION_NO", null,
            "versionNo", Integer.class, false, false, null, null,
            OptimisticLockType.VERSION_NO);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnName() {
        return _columnName;
    }

    public ColumnInfo columnUrls() {
        return _columnUrls;
    }

    public ColumnInfo columnIncludedUrls() {
        return _columnIncludedUrls;
    }

    public ColumnInfo columnExcludedUrls() {
        return _columnExcludedUrls;
    }

    public ColumnInfo columnIncludedDocUrls() {
        return _columnIncludedDocUrls;
    }

    public ColumnInfo columnExcludedDocUrls() {
        return _columnExcludedDocUrls;
    }

    public ColumnInfo columnDepth() {
        return _columnDepth;
    }

    public ColumnInfo columnMaxAccessCount() {
        return _columnMaxAccessCount;
    }

    public ColumnInfo columnUserAgent() {
        return _columnUserAgent;
    }

    public ColumnInfo columnNumOfThread() {
        return _columnNumOfThread;
    }

    public ColumnInfo columnIntervalTime() {
        return _columnIntervalTime;
    }

    public ColumnInfo columnBoost() {
        return _columnBoost;
    }

    public ColumnInfo columnAvailable() {
        return _columnAvailable;
    }

    public ColumnInfo columnSortOrder() {
        return _columnSortOrder;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------
    public ReferrerInfo referrerRequestHeaderList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                RequestHeaderDbm.getInstance().columnWebCrawlingConfigId());
        return cri("requestHeaderList", this, RequestHeaderDbm.getInstance(),
                map, false);
    }

    public ReferrerInfo referrerWebAuthenticationList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                WebAuthenticationDbm.getInstance().columnWebCrawlingConfigId());
        return cri("webAuthenticationList", this, WebAuthenticationDbm
                .getInstance(), map, false);
    }

    public ReferrerInfo referrerWebConfigToBrowserTypeMappingList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                WebConfigToBrowserTypeMappingDbm.getInstance()
                        .columnWebConfigId());
        return cri("webConfigToBrowserTypeMappingList", this,
                WebConfigToBrowserTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerWebConfigToLabelTypeMappingList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                WebConfigToLabelTypeMappingDbm.getInstance()
                        .columnWebConfigId());
        return cri("webConfigToLabelTypeMappingList", this,
                WebConfigToLabelTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerWebConfigToRoleTypeMappingList() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                WebConfigToRoleTypeMappingDbm.getInstance().columnWebConfigId());
        return cri("webConfigToRoleTypeMappingList", this,
                WebConfigToRoleTypeMappingDbm.getInstance(), map, false);
    }

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    public boolean hasVersionNo() {
        return true;
    }

    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.WebCrawlingConfig";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.WebCrawlingConfigCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.WebCrawlingConfigDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.WebCrawlingConfigBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<WebCrawlingConfig> getEntityType() {
        return WebCrawlingConfig.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public WebCrawlingConfig newMyEntity() {
        return new WebCrawlingConfig();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    // -----------------------------------------------------
    //                                                Accept
    //                                                ------
    public void acceptPrimaryKeyMap(Entity entity,
            Map<String, ? extends Object> primaryKeyMap) {
        doAcceptPrimaryKeyMap((WebCrawlingConfig) entity, primaryKeyMap,
                _epsMap);
    }

    public void acceptPrimaryKeyMapString(Entity entity,
            String primaryKeyMapString) {
        MapStringUtil.acceptPrimaryKeyMapString(primaryKeyMapString, entity);
    }

    public void acceptColumnValueMap(Entity entity,
            Map<String, ? extends Object> columnValueMap) {
        doAcceptColumnValueMap((WebCrawlingConfig) entity, columnValueMap,
                _epsMap);
    }

    public void acceptColumnValueMapString(Entity entity,
            String columnValueMapString) {
        MapStringUtil.acceptColumnValueMapString(columnValueMapString, entity);
    }

    // -----------------------------------------------------
    //                                               Extract
    //                                               -------
    public String extractPrimaryKeyMapString(Entity entity) {
        return MapStringUtil.extractPrimaryKeyMapString(entity);
    }

    public String extractPrimaryKeyMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractPrimaryKeyMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    public String extractColumnValueMapString(Entity entity) {
        return MapStringUtil.extractColumnValueMapString(entity);
    }

    public String extractColumnValueMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractColumnValueMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    // -----------------------------------------------------
    //                                               Convert
    //                                               -------
    public List<Object> convertToColumnValueList(Entity entity) {
        return newArrayList(convertToColumnValueMap(entity).values());
    }

    public Map<String, Object> convertToColumnValueMap(Entity entity) {
        return doConvertToColumnValueMap(entity);
    }

    public List<String> convertToColumnStringValueList(Entity entity) {
        return newArrayList(convertToColumnStringValueMap(entity).values());
    }

    public Map<String, String> convertToColumnStringValueMap(Entity entity) {
        return doConvertToColumnStringValueMap(entity);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<WebCrawlingConfig>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsName(), columnName());
        setupEps(_epsMap, new EpsUrls(), columnUrls());
        setupEps(_epsMap, new EpsIncludedUrls(), columnIncludedUrls());
        setupEps(_epsMap, new EpsExcludedUrls(), columnExcludedUrls());
        setupEps(_epsMap, new EpsIncludedDocUrls(), columnIncludedDocUrls());
        setupEps(_epsMap, new EpsExcludedDocUrls(), columnExcludedDocUrls());
        setupEps(_epsMap, new EpsDepth(), columnDepth());
        setupEps(_epsMap, new EpsMaxAccessCount(), columnMaxAccessCount());
        setupEps(_epsMap, new EpsUserAgent(), columnUserAgent());
        setupEps(_epsMap, new EpsNumOfThread(), columnNumOfThread());
        setupEps(_epsMap, new EpsIntervalTime(), columnIntervalTime());
        setupEps(_epsMap, new EpsBoost(), columnBoost());
        setupEps(_epsMap, new EpsAvailable(), columnAvailable());
        setupEps(_epsMap, new EpsSortOrder(), columnSortOrder());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((WebCrawlingConfig) entity, value);
    }

    public static class EpsId implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setId((Long) v);
        }
    }

    public static class EpsName implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setName((String) v);
        }
    }

    public static class EpsUrls implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setUrls((String) v);
        }
    }

    public static class EpsIncludedUrls implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setIncludedUrls((String) v);
        }
    }

    public static class EpsExcludedUrls implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setExcludedUrls((String) v);
        }
    }

    public static class EpsIncludedDocUrls implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setIncludedDocUrls((String) v);
        }
    }

    public static class EpsExcludedDocUrls implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setExcludedDocUrls((String) v);
        }
    }

    public static class EpsDepth implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setDepth((Integer) v);
        }
    }

    public static class EpsMaxAccessCount implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setMaxAccessCount((Long) v);
        }
    }

    public static class EpsUserAgent implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setUserAgent((String) v);
        }
    }

    public static class EpsNumOfThread implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setNumOfThread((Integer) v);
        }
    }

    public static class EpsIntervalTime implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setIntervalTime((Integer) v);
        }
    }

    public static class EpsBoost implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setBoost((java.math.BigDecimal) v);
        }
    }

    public static class EpsAvailable implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setAvailable((String) v);
        }
    }

    public static class EpsSortOrder implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setSortOrder((Integer) v);
        }
    }

    public static class EpsCreatedBy implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsVersionNo implements Eps<WebCrawlingConfig> {
        public void setup(WebCrawlingConfig e, Object v) {
            e.setVersionNo((Integer) v);
        }
    }
}
