#!/bin/bash

cd `dirname $0`
cd ..
BASE_DIR=`pwd`

SUBCMD=$1
SOLR_PORT=$2
NUM_SHARDS=$3
CONFIG_NAME=collection1
LOG_DIR=$BASE_DIR/logs/
PID_FILE=$BASE_DIR/bin/pid

if [ x$SUBCMD = "x" ] ; then
    echo "A kind of sub-command is leader, replica, solr, stop or clean."
    exit 1;
fi

if [ x$SUBCMD = "xstop" ] ; then
    if [ -f $PID_FILE ] ; then
        kill `cat $PID_FILE`
        exit;
    else
        echo "No process."
        exit 1;
    fi
elif [ -f $PID_FILE ] ; then
    pid=`cat $PID_FILE`
    echo "Stop a process $pid before running other sub-command."
    exit 1;
fi

if [ x$SUBCMD = "xclean" ] ; then
    echo "removing $BASE_DIR/zoo_data $LOG_DIR $PID_FILE"
    rm -rf $BASE_DIR/zoo_data $LOG_DIR $PID_FILE
    exit;
fi

if [ x$SOLR_PORT = "x" ] ; then
    echo "A port of solr is required"
    exit 1;
fi

mkdir -p $LOG_DIR

ZK_HOSTS="__FESS_ZK_HOSTS__"
JAVA_OPTS="$JAVA_OPTS -Djava.awt.headless=true -server -Xmx512m -XX:MaxPermSize=128m -XX:-UseGCOverheadLimit -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=75 -XX:+CMSIncrementalMode -XX:+CMSIncrementalPacing -XX:CMSIncrementalDutyCycleMin=0 -XX:+UseParNewGC -XX:+UseStringCache -XX:+UseTLAB -XX:+DisableExplicitGC"

echo "Zookeeper Hosts: $ZK_HOSTS"
echo "Solr Port:       $SOLR_PORT"
if [ x$SUBCMD = "xleader" ] ; then
    if [ x$NUM_SHARDS = "x" ] ; then
        echo "The number of shards is required"
        exit 1;
    fi
    ZK_PORT=`expr $SOLR_PORT + 1000`
    echo "ZooKeeper Port:  $ZK_PORT"
    SOLR_OPTS="-Djetty.port=$SOLR_PORT -Dbootstrap_confdir=$BASE_DIR/solr/$CONFIG_NAME/conf -Dcollection.configName=$CONFIG_NAME -DzkRun -DzkHost=$ZK_HOSTS -DnumShards=$NUM_SHARDS -Dsolr.solr.home=$BASE_DIR/solr -Dsolr.core.name=$CONFIG_NAME"
    echo "Start ZooKeeper and Solr server."
elif [ x$SUBCMD = "xreplica" ] ; then
    ZK_PORT=`expr $SOLR_PORT + 1000`
    echo "ZooKeeper Port:  $ZK_PORT"
    SOLR_OPTS="-Djetty.port=$SOLR_PORT -DzkRun -DzkHost=$ZK_HOSTS -Dsolr.solr.home=$BASE_DIR/solr -Dsolr.core.name=$CONFIG_NAME"
    echo "Start ZooKeeper and Solr server."
elif [ x$SUBCMD = "xsolr" ] ; then
    SOLR_OPTS="-Djetty.port=$SOLR_PORT -DzkHost=$ZK_HOSTS -Dsolr.solr.home=$BASE_DIR/solr -Dsolr.core.name=$CONFIG_NAME"
    echo "Start Solr server."
else 
    echo "Unknown sub-command."
    exit 1;
fi

java $JAVA_OPTS $SOLR_OPTS -jar start.jar > $LOG_DIR/solrcloud.log 2>&1 &
echo $! > $PID_FILE

