//
// Copyright 2009-2010 Fess Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import "ConfigServerController.h"

@implementation ConfigServerController

- (id)init {
	if (self = [super init]) {
		self.title = NSLocalizedString(@"ConfigServerTitle", nil);
		self.tableViewStyle = UITableViewStyleGrouped;
		self.navigationItem.rightBarButtonItem = [[[UIBarButtonItem alloc]
												   initWithTitle:NSLocalizedString(@"ConfigSetDefault", nil) 
												   style:UIBarButtonItemStylePlain
												   target:self
												   action:@selector(confirmRestoreDefault)] autorelease];
		
		
	}
	return self;
}

- (void)createModel {
	NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];

	UITextField* serverUrlField = [[[UITextField alloc] init] autorelease];
	serverUrlField.delegate = self;
	serverUrlField.tag = 1;
	serverUrlField.autocapitalizationType = UITextAutocapitalizationTypeNone;
	NSString *fessUrlStr = [defaults stringForKey:FESS_URL_KEY];
	if (fessUrlStr != nil) {
		serverUrlField.text = fessUrlStr;
	} else {
		serverUrlField.text = DEFAULT_FESS_URL;
	}
	UITextField* pageSizeField = [[[UITextField alloc] init] autorelease];
	pageSizeField.delegate = self;
	pageSizeField.tag = 2;
	pageSizeField.autocapitalizationType = UITextAutocapitalizationTypeNone;
	pageSizeField.keyboardType = UIKeyboardTypeNumberPad;
	NSString *pageSizeStr = [defaults stringForKey:FESS_PAGE_SIZE_KEY];
	if (pageSizeStr != nil) {
		pageSizeField.text = pageSizeStr;
	} else {
		pageSizeField.text = [NSString stringWithFormat:@"%d", DEFAULT_PAGE_SIZE];
	}
	
	self.dataSource = [TTSectionedDataSource dataSourceWithObjects:
					   NSLocalizedString(@"ConfigServerUrl",nil),
					   [TTTableControlItem itemWithCaption:@"" control:serverUrlField],

					   NSLocalizedString(@"ConfigPageSizeForRequest",nil),
					   [TTTableControlItem itemWithCaption:@"" control:pageSizeField],

					   nil];
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
	TTDPRINT(@"text=%@", textField.text);
	NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];
	if (textField.tag == 1) {
		// Fess URL
		[defaults setValue:textField.text forKey:FESS_URL_KEY];
	} else if (textField.tag == 2) {
		// Page Size
		int size = [textField.text intValue];
		if (size <= 0 || size > 100) {
			size = DEFAULT_PAGE_SIZE;
		}
		textField.text = [NSString stringWithFormat:@"%d", size];
		[defaults setValue:[NSString stringWithFormat:@"%d", size]
					forKey:FESS_PAGE_SIZE_KEY];
	}
	[defaults synchronize];
}

-(void)confirmRestoreDefault {
	UIAlertView *alert = [[UIAlertView alloc]
						  initWithTitle:nil
						  message:NSLocalizedString(@"ConfigRestoreDefaultConfirmation", nil)
						  delegate:self
						  cancelButtonTitle:NSLocalizedString(@"ConfigRestoreDefaultCancel", nil)
						  otherButtonTitles:NSLocalizedString(@"ConfigRestoreDefaultOK", nil), 
						  nil];
	[alert show];
	[alert release];	
}

- (void)alertView:(UIAlertView*)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
	if (buttonIndex == 1) {
		NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];
		NSString *fessUrl = DEFAULT_FESS_URL;
		[defaults setValue:fessUrl forKey:FESS_URL_KEY];
		[defaults setValue:[NSString stringWithFormat:@"%d", DEFAULT_PAGE_SIZE]
					forKey:FESS_PAGE_SIZE_KEY];
		[defaults synchronize];
	
		[self.navigationController popViewControllerAnimated:YES];
	}
 }

@end