/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task.impl;

import java.util.concurrent.TimeUnit;

import org.seasar.chronos.core.Scheduler;
import org.seasar.chronos.core.TaskThreadPool;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.task.TaskExecutorService;
import org.seasar.chronos.core.task.TaskPropertyReader;
import org.seasar.chronos.core.task.TaskPropertyWriter;
import org.seasar.chronos.core.task.state.TaskExecuteContext;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

public class TaskExecutorServiceImpl implements TaskExecutorService {

    private final TaskExecuteContext taskExecuteContext;

    public TaskExecutorServiceImpl(final TaskExecuteContext taskExecuteContext) {
        this.taskExecuteContext = taskExecuteContext;
    }

    public boolean isReScheduleTask() {
        return taskExecuteContext.getTaskExecuteStrategy().isReScheduleTask();
    }

    public boolean await(final long time, final TimeUnit timeUnit)
            throws InterruptedException {
        return taskExecuteContext.await(time, timeUnit);
    }

    public boolean cancel() {
        return taskExecuteContext.cancel();
    }

    public void destroy() throws InterruptedException {
        taskExecuteContext.destroy();
    }

    public String end() throws InterruptedException {
        return taskExecuteContext.finish();
    }

    public void execute(final String startTaskName) throws InterruptedException {
        taskExecuteContext.execute(startTaskName);
    }

    public String getDescription() {
        final String result = taskExecuteContext.getTaskExecuteStrategy()
                .getDescription();
        return result;
    }

    public boolean isEndTask() {
        return taskExecuteContext.getTaskExecuteStrategy().isEndTask();
    }

    public Scheduler getScheduler() {
        return taskExecuteContext.getTaskExecuteStrategy().getScheduler();
    }

    public boolean isShutdownTask() {
        return taskExecuteContext.getTaskExecuteStrategy().isShutdownTask();
    }

    public boolean isStartTask() {
        return taskExecuteContext.getTaskExecuteStrategy().isStartTask();
    }

    public Object getTask() {
        return taskExecuteContext.getTaskExecuteStrategy().getTask();
    }

    public Class<?> getTaskClass() {
        return taskExecuteContext.getTaskExecuteStrategy().getTaskClass();
    }

    public long getTaskId() {
        return taskExecuteContext.getTaskExecuteStrategy().getTaskId();
    }

    public String getTaskName() {
        return taskExecuteContext.getTaskExecuteStrategy().getTaskName();
    }

    public TaskThreadPool getThreadPool() {
        return taskExecuteContext.getTaskExecuteStrategy().getThreadPool();
    }

    public int getThreadPoolSize() {
        return taskExecuteContext.getTaskExecuteStrategy().getThreadPoolSize();
    }

    public ThreadPoolType getThreadPoolType() {
        return taskExecuteContext.getTaskExecuteStrategy().getThreadPoolType();
    }

    public TaskTrigger getTrigger() {
        return taskExecuteContext.getTaskExecuteStrategy().getTrigger();
    }

    public void initialize() throws InterruptedException {
        taskExecuteContext.initialize();
    }

    public String start() throws InterruptedException {
        return taskExecuteContext.start();
    }

    public boolean isExecuted() {
        return taskExecuteContext.getTaskExecuteStrategy().isExecuted();
    }

    public void setEndTask(final boolean endTask) {
        taskExecuteContext.getTaskExecuteStrategy().setEndTask(endTask);
    }

    public void setExecuted(final boolean executed) {
        taskExecuteContext.getTaskExecuteStrategy().setExecuted(executed);
    }

    @Binding(bindingType = BindingType.NONE)
    public void setGetterSignal(final Object getterSignal) {
        taskExecuteContext.setGetterSignal(getterSignal);
    }

    public void setScheduler(final Scheduler scheduler) {
        taskExecuteContext.getTaskExecuteStrategy().setScheduler(scheduler);
    }

    public void setShutdownTask(final boolean shutdownTask) {
        taskExecuteContext.getTaskExecuteStrategy().setShutdownTask(
                shutdownTask);
    }

    public void setStartTask(final boolean startTask) {
        taskExecuteContext.getTaskExecuteStrategy().setStartTask(startTask);
    }

    public void setTask(final Object task) {
        taskExecuteContext.getTaskExecuteStrategy().setTask(task);
    }

    public void setTaskClass(final Class<?> taskClass) {
        taskExecuteContext.getTaskExecuteStrategy().setTaskClass(taskClass);
    }

    public void setTaskId(final long taskId) {
        taskExecuteContext.getTaskExecuteStrategy().setTaskId(taskId);
    }

    public void setThreadPool(final TaskThreadPool taskThreadPool) {
        taskExecuteContext.getTaskExecuteStrategy().setThreadPool(
                taskThreadPool);
    }

    @Binding(bindingType = BindingType.NONE)
    public void setTrigger(final TaskTrigger taskTrigger) {
        taskExecuteContext.getTaskExecuteStrategy().setTrigger(taskTrigger);
    }

    public void waitOne() throws InterruptedException {
        taskExecuteContext.waitOne();
    }

    public void setComponentDef(final ComponentDef componentDef) {
        taskExecuteContext.getTaskExecuteStrategy().setComponentDef(
                componentDef);
    }

    public boolean isPrepared() {
        return taskExecuteContext.getTaskExecuteStrategy().isPrepared();
    }

    public void prepare() {
        taskExecuteContext.getTaskExecuteStrategy().prepare();
    }

    public void unprepare() {
        taskExecuteContext.getTaskExecuteStrategy().unprepare();
    }

    public TaskPropertyReader getTaskPropertyReader() {
        return taskExecuteContext.getTaskExecuteStrategy()
                .getTaskPropertyReader();
    }

    public TaskPropertyWriter getTaskPropertyWriter() {
        return taskExecuteContext.getTaskExecuteStrategy()
                .getTaskPropertyWriter();
    }

    public void hotdeployStart() {
        taskExecuteContext.getTaskExecuteStrategy().hotdeployStart();
    }

    public void hotdeployStop() {
        taskExecuteContext.getTaskExecuteStrategy().hotdeployStop();
    }

    public Exception getException() {
        return taskExecuteContext.getTaskExecuteStrategy().getException();
    }

    public void setException(final Exception exception) {
        taskExecuteContext.getTaskExecuteStrategy().setException(exception);
    }

    public boolean isHotdeployDisable() {
        return taskExecuteContext.getTaskExecuteStrategy().isHotdeployDisable();
    }

    public void setHotdeployDisable(final boolean hotdeployDisable) {
        taskExecuteContext.getTaskExecuteStrategy().setHotdeployDisable(
                hotdeployDisable);
    }

    public void catchException(final Exception exception) {
        taskExecuteContext.getTaskExecuteStrategy().catchException(exception);
    }
}
