package jp.sf.fess.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FacetField.Count;

public class FacetResponse {
    protected Map<String, Long> queryCountMap;

    protected List<Field> fieldList;

    public FacetResponse(List<FacetField> facetFields,
            Map<String, Integer> facetQueryMap) {
        if (facetFields != null && !facetFields.isEmpty()) {
            fieldList = new ArrayList<FacetResponse.Field>();
            for (FacetField facetField : facetFields) {
                fieldList.add(new Field(facetField));
            }
        }
        if (facetQueryMap != null && !facetQueryMap.isEmpty()) {
            queryCountMap = new LinkedHashMap<String, Long>();
            for (Map.Entry<String, Integer> entry : facetQueryMap.entrySet()) {
                queryCountMap.put(entry.getKey(), entry.getValue().longValue());
            }
        }
    }

    public boolean hasFacetResponse() {
        return queryCountMap != null || fieldList != null;
    }

    public static class Field {
        protected Map<String, Long> valueCountMap;

        protected String name;

        public Field(FacetField facetField) {
            name = facetField.getName();
            valueCountMap = new LinkedHashMap<String, Long>();
            for (Count count : facetField.getValues()) {
                valueCountMap.put(count.getName(), count.getCount());
            }
        }

        /**
         * @return the valueCountMap
         */
        public Map<String, Long> getValueCountMap() {
            return valueCountMap;
        }

        /**
         * @return the name
         */
        public String getName() {
            return name;
        }

    }

    /**
     * @return the queryCountMap
     */
    public Map<String, Long> getQueryCountMap() {
        return queryCountMap;
    }

    /**
     * @return the fieldList
     */
    public List<Field> getFieldList() {
        return fieldList;
    }

}
