/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.LabelTypeToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.LabelTypeToRoleTypeMappingCB;
import jp.sf.fess.db.exbhv.LabelTypeToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping;
import jp.sf.fess.db.exentity.RoleType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of LABEL_TYPE_TO_ROLE_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, LABEL_TYPE_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     LABEL_TYPE, ROLE_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     labelType, roleType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsLabelTypeToRoleTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "LABEL_TYPE_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return LabelTypeToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public LabelTypeToRoleTypeMappingDbm getMyDBMeta() {
        return LabelTypeToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public LabelTypeToRoleTypeMapping newMyEntity() {
        return new LabelTypeToRoleTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public LabelTypeToRoleTypeMappingCB newMyConditionBean() {
        return new LabelTypeToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(LabelTypeToRoleTypeMappingCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(LabelTypeToRoleTypeMappingCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(LabelTypeToRoleTypeMappingCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;LabelTypeToRoleTypeMapping&gt;() {
     *     public void handle(LabelTypeToRoleTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of LabelTypeToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(LabelTypeToRoleTypeMappingCB cb,
            EntityRowHandler<LabelTypeToRoleTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> void doSelectCursor(
            LabelTypeToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<LabelTypeToRoleTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (labelTypeToRoleTypeMapping != null) {
     *     ... = labelTypeToRoleTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectEntity(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectEntity(cb, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectEntity(
            final LabelTypeToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = labelTypeToRoleTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectEntityWithDeletedCheck(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final LabelTypeToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelTypeToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private LabelTypeToRoleTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        LabelTypeToRoleTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;LabelTypeToRoleTypeMapping&gt; labelTypeToRoleTypeMappingList = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping : labelTypeToRoleTypeMappingList) {
     *     ... = labelTypeToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<LabelTypeToRoleTypeMapping> selectList(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectList(cb, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> ListResultBean<ENTITY> doSelectList(
            LabelTypeToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;LabelTypeToRoleTypeMapping&gt; page = labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping : page) {
     *     ... = labelTypeToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<LabelTypeToRoleTypeMapping> selectPage(
            LabelTypeToRoleTypeMappingCB cb) {
        return doSelectPage(cb, LabelTypeToRoleTypeMapping.class);
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            LabelTypeToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, LabelTypeToRoleTypeMappingCB>() {
                    public int callbackSelectCount(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            LabelTypeToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<LabelTypeToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends LabelTypeToRoleTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param labelTypeToRoleTypeMappingList The list of labelTypeToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return helpPulloutInternally(
                labelTypeToRoleTypeMappingList,
                new InternalPulloutCallback<LabelTypeToRoleTypeMapping, LabelType>() {
                    public LabelType getFr(LabelTypeToRoleTypeMapping e) {
                        return e.getLabelType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(LabelType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param labelTypeToRoleTypeMappingList The list of labelTypeToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return helpPulloutInternally(
                labelTypeToRoleTypeMappingList,
                new InternalPulloutCallback<LabelTypeToRoleTypeMapping, RoleType>() {
                    public RoleType getFr(LabelTypeToRoleTypeMapping e) {
                        return e.getRoleType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(RoleType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * labelTypeToRoleTypeMapping.setFoo...(value);
     * labelTypeToRoleTypeMapping.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.set...;</span>
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">insert</span>(labelTypeToRoleTypeMapping);
     * ... = labelTypeToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        doInsert(labelTypeToRoleTypeMapping, null);
    }

    protected void doInsert(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMapping",
                labelTypeToRoleTypeMapping);
        prepareInsertOption(option);
        delegateInsert(labelTypeToRoleTypeMapping, option);
    }

    protected void prepareInsertOption(
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * labelTypeToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelTypeToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelTypeToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">update</span>(labelTypeToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        doUpdate(labelTypeToRoleTypeMapping, null);
    }

    protected void doUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            final UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMapping",
                labelTypeToRoleTypeMapping);
        prepareUpdateOption(option);
        helpUpdateInternally(labelTypeToRoleTypeMapping,
                new InternalUpdateCallback<LabelTypeToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            LabelTypeToRoleTypeMapping entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected LabelTypeToRoleTypeMappingCB createCBForVaryingUpdate() {
        LabelTypeToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected LabelTypeToRoleTypeMappingCB createCBForSpecifiedUpdate() {
        LabelTypeToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    @Override
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        doModify(entity, option);
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param labelTypeToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        doInesrtOrUpdate(labelTypeToRoleTypeMapping, null, null);
    }

    protected void doInesrtOrUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            final InsertOption<LabelTypeToRoleTypeMappingCB> insertOption,
            final UpdateOption<LabelTypeToRoleTypeMappingCB> updateOption) {
        helpInsertOrUpdateInternally(
                labelTypeToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<LabelTypeToRoleTypeMapping, LabelTypeToRoleTypeMappingCB>() {
                    public void callbackInsert(LabelTypeToRoleTypeMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(LabelTypeToRoleTypeMapping entity) {
                        doUpdate(entity, updateOption);
                    }

                    public LabelTypeToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    @Override
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        doCreateOrModify(entity, insertOption, updateOption);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * labelTypeToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelTypeToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">delete</span>(labelTypeToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping) {
        doDelete(labelTypeToRoleTypeMapping, null);
    }

    protected void doDelete(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            final DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMapping",
                labelTypeToRoleTypeMapping);
        prepareDeleteOption(option);
        helpDeleteInternally(labelTypeToRoleTypeMapping,
                new InternalDeleteCallback<LabelTypeToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            LabelTypeToRoleTypeMapping entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(
            DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    @Override
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        doRemove(entity, option);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return doBatchInsert(labelTypeToRoleTypeMappingList, null);
    }

    protected int[] doBatchInsert(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMappingList",
                labelTypeToRoleTypeMappingList);
        prepareInsertOption(option);
        return delegateBatchInsert(labelTypeToRoleTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return doBatchUpdate(labelTypeToRoleTypeMappingList, null);
    }

    protected int[] doBatchUpdate(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMappingList",
                labelTypeToRoleTypeMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(labelTypeToRoleTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            SpecifyQuery<LabelTypeToRoleTypeMappingCB> updateColumnSpec) {
        return doBatchUpdate(labelTypeToRoleTypeMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        return doLumpModify(ls, option);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList) {
        return doBatchDelete(labelTypeToRoleTypeMappingList, null);
    }

    protected int[] doBatchDelete(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMappingList",
                labelTypeToRoleTypeMappingList);
        prepareDeleteOption(option);
        return delegateBatchDelete(labelTypeToRoleTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    @Override
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        return doLumpRemove(ls, option);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;labelTypeToRoleTypeMapping, LabelTypeToRoleTypeMappingCB&gt;() {
     *     public ConditionBean setup(labelTypeToRoleTypeMapping entity, LabelTypeToRoleTypeMappingCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<LabelTypeToRoleTypeMapping, LabelTypeToRoleTypeMappingCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<LabelTypeToRoleTypeMapping, LabelTypeToRoleTypeMappingCB> setupper,
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        LabelTypeToRoleTypeMapping entity = new LabelTypeToRoleTypeMapping();
        LabelTypeToRoleTypeMappingCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected LabelTypeToRoleTypeMappingCB createCBForQueryInsert() {
        LabelTypeToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setPK...(value);</span>
     * labelTypeToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setVersionNo(value);</span>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(labelTypeToRoleTypeMapping, cb);
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            LabelTypeToRoleTypeMappingCB cb) {
        return doQueryUpdate(labelTypeToRoleTypeMapping, cb, null);
    }

    protected int doQueryUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            LabelTypeToRoleTypeMappingCB cb,
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertObjectNotNull("labelTypeToRoleTypeMapping",
                labelTypeToRoleTypeMapping);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(labelTypeToRoleTypeMapping, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity),
                    (LabelTypeToRoleTypeMappingCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (LabelTypeToRoleTypeMappingCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(labelTypeToRoleTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(LabelTypeToRoleTypeMappingCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(LabelTypeToRoleTypeMappingCB cb,
            DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((LabelTypeToRoleTypeMappingCB) cb);
        } else {
            return varyingQueryDelete((LabelTypeToRoleTypeMappingCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * labelTypeToRoleTypeMapping.setFoo...(value);
     * labelTypeToRoleTypeMapping.setBar...(value);
     * InsertOption<LabelTypeToRoleTypeMappingCB> option = new InsertOption<LabelTypeToRoleTypeMappingCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">varyingInsert</span>(labelTypeToRoleTypeMapping, option);
     * ... = labelTypeToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(labelTypeToRoleTypeMapping, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * labelTypeToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelTypeToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelTypeToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt; option = new UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *         public void specify(LabelTypeToRoleTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(labelTypeToRoleTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(labelTypeToRoleTypeMapping, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param labelTypeToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            InsertOption<LabelTypeToRoleTypeMappingCB> insertOption,
            UpdateOption<LabelTypeToRoleTypeMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(labelTypeToRoleTypeMapping, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param labelTypeToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(labelTypeToRoleTypeMapping, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(labelTypeToRoleTypeMappingList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(labelTypeToRoleTypeMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param labelTypeToRoleTypeMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<LabelTypeToRoleTypeMapping> labelTypeToRoleTypeMappingList,
            DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(labelTypeToRoleTypeMappingList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<LabelTypeToRoleTypeMapping, LabelTypeToRoleTypeMappingCB> setupper,
            InsertOption<LabelTypeToRoleTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping = new LabelTypeToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setPK...(value);</span>
     * labelTypeToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelTypeToRoleTypeMapping.setVersionNo(value);</span>
     * LabelTypeToRoleTypeMappingCB cb = new LabelTypeToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt; option = new UpdateOption&lt;LabelTypeToRoleTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *     public void specify(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * labelTypeToRoleTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(labelTypeToRoleTypeMapping, cb, option);
     * </pre>
     * @param labelTypeToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(
            LabelTypeToRoleTypeMapping labelTypeToRoleTypeMapping,
            LabelTypeToRoleTypeMappingCB cb,
            UpdateOption<LabelTypeToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(labelTypeToRoleTypeMapping, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of LabelTypeToRoleTypeMapping. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(LabelTypeToRoleTypeMappingCB cb,
            DeleteOption<LabelTypeToRoleTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<LabelTypeToRoleTypeMappingBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(LabelTypeToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(LabelTypeToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> void delegateSelectCursor(
            LabelTypeToRoleTypeMappingCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends LabelTypeToRoleTypeMapping> List<ENTITY> delegateSelectList(
            LabelTypeToRoleTypeMappingCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(LabelTypeToRoleTypeMapping e,
            InsertOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(LabelTypeToRoleTypeMapping e,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return delegateUpdateNonstrict(e, op);
    }

    protected int delegateUpdateNonstrict(LabelTypeToRoleTypeMapping e,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(LabelTypeToRoleTypeMapping e,
            DeleteOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return delegateDeleteNonstrict(e, op);
    }

    protected int delegateDeleteNonstrict(LabelTypeToRoleTypeMapping e,
            DeleteOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<LabelTypeToRoleTypeMapping> ls,
            InsertOption<LabelTypeToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<LabelTypeToRoleTypeMapping> ls,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchUpdateNonstrict(ls, op);
    }

    protected int[] delegateBatchUpdateNonstrict(
            List<LabelTypeToRoleTypeMapping> ls,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<LabelTypeToRoleTypeMapping> ls,
            DeleteOption<LabelTypeToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchDeleteNonstrict(ls, op);
    }

    protected int[] delegateBatchDeleteNonstrict(
            List<LabelTypeToRoleTypeMapping> ls,
            DeleteOption<LabelTypeToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(LabelTypeToRoleTypeMapping e,
            LabelTypeToRoleTypeMappingCB inCB, ConditionBean resCB,
            InsertOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(LabelTypeToRoleTypeMapping e,
            LabelTypeToRoleTypeMappingCB cb,
            UpdateOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(LabelTypeToRoleTypeMappingCB cb,
            DeleteOption<LabelTypeToRoleTypeMappingCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected LabelTypeToRoleTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                LabelTypeToRoleTypeMapping.class);
    }

    protected LabelTypeToRoleTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                LabelTypeToRoleTypeMappingCB.class);
    }
}
