/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.util;

import java.util.HashMap;
import java.util.Map;

import org.seasar.framework.util.StringUtil;

public class ParameterUtil {
    public static Map<String, String> convertParameterMap(String parameters) {
        Map<String, String> map = new HashMap<String, String>();
        if (parameters != null) {
            String[] lines = parameters.split("\n");
            for (String line : lines) {
                if (StringUtil.isNotBlank(line)) {
                    int pos = line.indexOf('=');
                    String key;
                    String value;
                    if (pos >= 0) {
                        key = line.substring(0, pos);
                        if (pos + 1 < line.length()) {
                            value = line.substring(pos + 1);
                        } else {
                            value = "";
                        }
                    } else {
                        key = line.trim();
                        value = "";
                    }
                    map.put(key, value);
                }
            }
        }
        return map;
    }
}
