package jp.sf.fess.solr;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class FessSolrQueryException extends FessSolrException {

    private static final long serialVersionUID = 1L;

    private List<Exception> exceptionList = new ArrayList<Exception>();

    public FessSolrQueryException(String message) {
        super(message);
    }

    public void addException(Exception e) {
        exceptionList.add(e);
    }

    @Override
    public String getMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.getMessage());
        buf.append(String.format("\nThis exception has %d child exceptions.",
                exceptionList.size()));
        int count = 1;
        for (Exception e : exceptionList) {
            buf.append("\n===> Exception ");
            buf.append(count);
            buf.append(": ");
            buf.append(e.getMessage());
            buf.append('\n');
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            buf.append(sw.toString());
            count++;
        }
        return buf.toString();
    }
}
