/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.DataCrawlingConfigDbm;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of DATA_CRAWLING_CONFIG that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, HANDLER_NAME, HANDLER_PARAMETER, HANDLER_SCRIPT, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, DATA_CONFIG_TO_LABEL_TYPE_MAPPING, DATA_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToBrowserTypeMappingList, dataConfigToLabelTypeMappingList, dataConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataCrawlingConfigBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataCrawlingConfigDbm getMyDBMeta() {
        return DataCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public DataCrawlingConfig newMyEntity() {
        return new DataCrawlingConfig();
    }

    public DataCrawlingConfigCB newMyConditionBean() {
        return new DataCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of DataCrawlingConfig. (NotNull)
     */
    public void selectCursor(DataCrawlingConfigCB cb,
            EntityRowHandler<DataCrawlingConfig> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataCrawlingConfig>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataCrawlingConfig selectEntity(final DataCrawlingConfigCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<DataCrawlingConfig, DataCrawlingConfigCB>() {
                    public List<DataCrawlingConfig> callbackSelectList(
                            DataCrawlingConfigCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataCrawlingConfig selectEntityWithDeletedCheck(
            final DataCrawlingConfigCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<DataCrawlingConfig, DataCrawlingConfigCB>() {
                    public List<DataCrawlingConfig> callbackSelectList(
                            DataCrawlingConfigCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        DataCrawlingConfig entity = new DataCrawlingConfig();
        entity.setId(id);
        final DataCrawlingConfigCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<DataCrawlingConfig> selectList(DataCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<DataCrawlingConfig>(getTableDbName())
                .buildListResultBean(cb, delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<DataCrawlingConfig> selectPage(
            final DataCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<DataCrawlingConfig> invoker = new PagingInvoker<DataCrawlingConfig>(
                getTableDbName());
        final PagingHandler<DataCrawlingConfig> handler = new PagingHandler<DataCrawlingConfig>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<DataCrawlingConfig> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * dataCrawlingConfigBhv.scalarSelect(Date.class).max(new ScalarQuery(DataCrawlingConfigCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<DataCrawlingConfigCB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToBrowserTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(DataConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            DataCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            DataCrawlingConfig entity,
                            List<DataConfigToBrowserTypeMapping> referrerList) {
                        entity
                                .setDataConfigToBrowserTypeMappingList(referrerList);
                    }

                    public DataConfigToBrowserTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            DataConfigToBrowserTypeMappingCB cb,
                            List<Long> pkList) {
                        cb.query().setDataConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            DataConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public List<DataConfigToBrowserTypeMapping> callbackReferrer_selectList(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            DataConfigToBrowserTypeMapping entity) {
                        return entity.getDataConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            DataConfigToBrowserTypeMapping referrerEntity,
                            DataCrawlingConfig baseEntity) {
                        referrerEntity.setDataCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToLabelTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            DataCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            DataCrawlingConfig entity,
                            List<DataConfigToLabelTypeMapping> referrerList) {
                        entity
                                .setDataConfigToLabelTypeMappingList(referrerList);
                    }

                    public DataConfigToLabelTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            DataConfigToLabelTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setDataConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            DataConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public List<DataConfigToLabelTypeMapping> callbackReferrer_selectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            DataConfigToLabelTypeMapping entity) {
                        return entity.getDataConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            DataConfigToLabelTypeMapping referrerEntity,
                            DataCrawlingConfig baseEntity) {
                        referrerEntity.setDataCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToRoleTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            DataCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            DataCrawlingConfig entity,
                            List<DataConfigToRoleTypeMapping> referrerList) {
                        entity.setDataConfigToRoleTypeMappingList(referrerList);
                    }

                    public DataConfigToRoleTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            DataConfigToRoleTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setDataConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            DataConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public List<DataConfigToRoleTypeMapping> callbackReferrer_selectList(
                            DataConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            DataConfigToRoleTypeMapping entity) {
                        return entity.getDataConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            DataConfigToRoleTypeMapping referrerEntity,
                            DataCrawlingConfig baseEntity) {
                        referrerEntity.setDataCrawlingConfig(baseEntity);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param dataCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataCrawlingConfig dataCrawlingConfig) {
        assertEntityNotNull(dataCrawlingConfig);
        delegateInsert(dataCrawlingConfig);
    }

    @Override
    protected void doCreate(Entity dataCrawlingConfig) {
        insert((DataCrawlingConfig) dataCrawlingConfig);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final DataCrawlingConfig dataCrawlingConfig) {
        helpUpdateInternally(dataCrawlingConfig,
                new InternalUpdateCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdate(DataCrawlingConfig entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((DataCrawlingConfig) entity);
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonConcurrencyControl}
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final DataCrawlingConfig dataCrawlingConfig) {
        helpUpdateNonstrictInternally(dataCrawlingConfig,
                new InternalUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict((DataCrawlingConfig) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final DataCrawlingConfig dataCrawlingConfig) {
        helpInsertOrUpdateInternally(
                dataCrawlingConfig,
                new InternalInsertOrUpdateCallback<DataCrawlingConfig, DataCrawlingConfigCB>() {
                    public void callbackInsert(DataCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(DataCrawlingConfig entity) {
                        update(entity);
                    }

                    public DataCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(DataCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity dataCrawlingConfig) {
        insertOrUpdate((DataCrawlingConfig) dataCrawlingConfig);
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonConcurrencyControl(when update)}
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(DataCrawlingConfig dataCrawlingConfig) {
        helpInsertOrUpdateInternally(
                dataCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public void callbackInsert(DataCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict((DataCrawlingConfig) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataCrawlingConfig dataCrawlingConfig) {
        helpDeleteInternally(dataCrawlingConfig,
                new InternalDeleteCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDelete(DataCrawlingConfig entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity dataCrawlingConfig) {
        delete((DataCrawlingConfig) dataCrawlingConfig);
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonConcurrencyControl}
     * @param dataCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(DataCrawlingConfig dataCrawlingConfig) {
        helpDeleteNonstrictInternally(dataCrawlingConfig,
                new InternalDeleteNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonConcurrencyControl}
     * @param dataCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            DataCrawlingConfig dataCrawlingConfig) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                dataCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateInsertList(dataCrawlingConfigList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateUpdateList(dataCrawlingConfigList);
    }

    /**
     * Batch update the list non-strictly. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateUpdateListNonstrict(dataCrawlingConfigList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateDeleteList(dataCrawlingConfigList);
    }

    /**
     * Batch delete the list non-strictly. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateDeleteListNonstrict(dataCrawlingConfigList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param dataCrawlingConfig Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(DataCrawlingConfig dataCrawlingConfig,
            DataCrawlingConfigCB cb) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(dataCrawlingConfig);
        filterEntityOfUpdate(dataCrawlingConfig);
        assertEntityOfUpdate(dataCrawlingConfig);
        return invoke(createQueryUpdateEntityCBCommand(dataCrawlingConfig, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(DataCrawlingConfigCB cb,
            EntityRowHandler<DataCrawlingConfig> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                DataCrawlingConfig.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((DataCrawlingConfigCB) cb);
    }

    protected List<DataCrawlingConfig> delegateSelectList(
            DataCrawlingConfigCB cb) {
        return invoke(createSelectListCBCommand(cb, DataCrawlingConfig.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((DataCrawlingConfigCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataCrawlingConfig e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(DataCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateUpdateNonstrict(DataCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(DataCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int delegateDeleteNonstrict(DataCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected DataCrawlingConfig downcast(Entity entity) {
        return helpDowncastInternally(entity, DataCrawlingConfig.class);
    }
}
