/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.DataConfigToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.RoleType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of DATA_CONFIG_TO_ROLE_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     DATA_CRAWLING_CONFIG, ROLE_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     dataCrawlingConfig, roleType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToRoleTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToRoleTypeMappingDbm getMyDBMeta() {
        return DataConfigToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public DataConfigToRoleTypeMapping newMyEntity() {
        return new DataConfigToRoleTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public DataConfigToRoleTypeMappingCB newMyConditionBean() {
        return new DataConfigToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToRoleTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(DataConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;DataConfigToRoleTypeMapping&gt;() {
     *     public void handle(DataConfigToRoleTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToRoleTypeMappingCB cb,
            EntityRowHandler<DataConfigToRoleTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> void doSelectCursor(
            DataConfigToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToRoleTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (dataConfigToRoleTypeMapping != null) {
     *     ... = dataConfigToRoleTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToRoleTypeMapping selectEntity(
            DataConfigToRoleTypeMappingCB cb) {
        return doSelectEntity(cb, DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> ENTITY doSelectEntity(
            final DataConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, DataConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = dataConfigToRoleTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToRoleTypeMapping selectEntityWithDeletedCheck(
            DataConfigToRoleTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final DataConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, DataConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToRoleTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private DataConfigToRoleTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        DataConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;DataConfigToRoleTypeMapping&gt; dataConfigToRoleTypeMappingList = dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping : dataConfigToRoleTypeMappingList) {
     *     ... = dataConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<DataConfigToRoleTypeMapping> selectList(
            DataConfigToRoleTypeMappingCB cb) {
        return doSelectList(cb, DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> ListResultBean<ENTITY> doSelectList(
            DataConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, DataConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;DataConfigToRoleTypeMapping&gt; page = dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping : page) {
     *     ... = dataConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<DataConfigToRoleTypeMapping> selectPage(
            DataConfigToRoleTypeMappingCB cb) {
        return doSelectPage(cb, DataConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            DataConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, DataConfigToRoleTypeMappingCB>() {
                    public int callbackSelectCount(
                            DataConfigToRoleTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            DataConfigToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(DataConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataConfigToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends DataConfigToRoleTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToRoleTypeMappingList The list of dataConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToRoleTypeMappingList,
                new InternalPulloutCallback<DataConfigToRoleTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig getFr(
                            DataConfigToRoleTypeMapping e) {
                        return e.getDataCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToRoleTypeMapping> ls) {
                        e.setDataConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param dataConfigToRoleTypeMappingList The list of dataConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToRoleTypeMappingList,
                new InternalPulloutCallback<DataConfigToRoleTypeMapping, RoleType>() {
                    public RoleType getFr(DataConfigToRoleTypeMapping e) {
                        return e.getRoleType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(RoleType e,
                            List<DataConfigToRoleTypeMapping> ls) {
                        e.setDataConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataConfigToRoleTypeMapping.setFoo...(value);
     * dataConfigToRoleTypeMapping.setBar...(value);
     * dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">insert</span>(dataConfigToRoleTypeMapping);
     * ... = dataConfigToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        assertEntityNotNull(dataConfigToRoleTypeMapping);
        delegateInsert(dataConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
     * dataConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">update</span>(dataConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        helpUpdateInternally(dataConfigToRoleTypeMapping,
                new InternalUpdateCallback<DataConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToRoleTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param dataConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        helpInsertOrUpdateInternally(
                dataConfigToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToRoleTypeMapping, DataConfigToRoleTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToRoleTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            DataConfigToRoleTypeMapping entity) {
                        update(entity);
                    }

                    public DataConfigToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
     * dataConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">delete</span>(dataConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        helpDeleteInternally(dataConfigToRoleTypeMapping,
                new InternalDeleteCallback<DataConfigToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToRoleTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        assertObjectNotNull("dataConfigToRoleTypeMappingList",
                dataConfigToRoleTypeMappingList);
        return delegateInsertList(dataConfigToRoleTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        assertObjectNotNull("dataConfigToRoleTypeMappingList",
                dataConfigToRoleTypeMappingList);
        return delegateUpdateList(dataConfigToRoleTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        assertObjectNotNull("dataConfigToRoleTypeMappingList",
                dataConfigToRoleTypeMappingList);
        return delegateDeleteList(dataConfigToRoleTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToRoleTypeMapping.setPK...(value);</span>
     * dataConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToRoleTypeMapping.setVersionNo(value);</span>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(dataConfigToRoleTypeMapping, cb);
     * </pre>
     * @param dataConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping,
            DataConfigToRoleTypeMappingCB cb) {
        return delegateQueryUpdate(dataConfigToRoleTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(dataConfigToRoleTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataConfigToRoleTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
     * dataConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;DataConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToRoleTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;DataConfigToRoleTypeMappingCB&gt;() {
     *         public void specify(DataConfigToRoleTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(dataConfigToRoleTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param dataConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping,
            final UpdateOption<DataConfigToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(dataConfigToRoleTypeMapping,
                new InternalUpdateCallback<DataConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToRoleTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToRoleTypeMapping.setPK...(value);</span>
     * dataConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToRoleTypeMapping.setVersionNo(value);</span>
     * DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;DataConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToRoleTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;DataConfigToRoleTypeMappingCB&gt;() {
     *     public void specify(DataConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(dataConfigToRoleTypeMapping, cb, option);
     * </pre>
     * @param dataConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping,
            DataConfigToRoleTypeMappingCB cb,
            final UpdateOption<DataConfigToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(dataConfigToRoleTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<DataConfigToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        DataConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> void delegateSelectCursor(
            DataConfigToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends DataConfigToRoleTypeMapping> List<ENTITY> delegateSelectList(
            DataConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToRoleTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(DataConfigToRoleTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(DataConfigToRoleTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<DataConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<DataConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(DataConfigToRoleTypeMapping e,
            DataConfigToRoleTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(DataConfigToRoleTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(DataConfigToRoleTypeMapping e,
            UpdateOption<DataConfigToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(DataConfigToRoleTypeMapping e,
            DataConfigToRoleTypeMappingCB cb,
            UpdateOption<DataConfigToRoleTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected DataConfigToRoleTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                DataConfigToRoleTypeMapping.class);
    }

    protected DataConfigToRoleTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                DataConfigToRoleTypeMappingCB.class);
    }
}
