/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.DataConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.LabelType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of DATA_CONFIG_TO_LABEL_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     DATA_CRAWLING_CONFIG, LABEL_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     dataCrawlingConfig, labelType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToLabelTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToLabelTypeMappingDbm getMyDBMeta() {
        return DataConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public DataConfigToLabelTypeMapping newMyEntity() {
        return new DataConfigToLabelTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public DataConfigToLabelTypeMappingCB newMyConditionBean() {
        return new DataConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToLabelTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(DataConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;DataConfigToLabelTypeMapping&gt;() {
     *     public void handle(DataConfigToLabelTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<DataConfigToLabelTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> void doSelectCursor(
            DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToLabelTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (dataConfigToLabelTypeMapping != null) {
     *     ... = dataConfigToLabelTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectEntity(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectEntity(cb, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectEntity(
            final DataConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = dataConfigToLabelTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final DataConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private DataConfigToLabelTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;DataConfigToLabelTypeMapping&gt; dataConfigToLabelTypeMappingList = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping : dataConfigToLabelTypeMappingList) {
     *     ... = dataConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<DataConfigToLabelTypeMapping> selectList(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectList(cb, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> ListResultBean<ENTITY> doSelectList(
            DataConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;DataConfigToLabelTypeMapping&gt; page = dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping : page) {
     *     ... = dataConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<DataConfigToLabelTypeMapping> selectPage(
            DataConfigToLabelTypeMappingCB cb) {
        return doSelectPage(cb, DataConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            DataConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, DataConfigToLabelTypeMappingCB>() {
                    public int callbackSelectCount(
                            DataConfigToLabelTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(DataConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends DataConfigToLabelTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToLabelTypeMappingList The list of dataConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToLabelTypeMappingList,
                new InternalPulloutCallback<DataConfigToLabelTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig getFr(
                            DataConfigToLabelTypeMapping e) {
                        return e.getDataCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param dataConfigToLabelTypeMappingList The list of dataConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToLabelTypeMappingList,
                new InternalPulloutCallback<DataConfigToLabelTypeMapping, LabelType>() {
                    public LabelType getFr(DataConfigToLabelTypeMapping e) {
                        return e.getLabelType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(LabelType e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataConfigToLabelTypeMapping.setFoo...(value);
     * dataConfigToLabelTypeMapping.setBar...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">insert</span>(dataConfigToLabelTypeMapping);
     * ... = dataConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        assertEntityNotNull(dataConfigToLabelTypeMapping);
        delegateInsert(dataConfigToLabelTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * dataConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">update</span>(dataConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        helpUpdateInternally(dataConfigToLabelTypeMapping,
                new InternalUpdateCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param dataConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        helpInsertOrUpdateInternally(
                dataConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToLabelTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        update(entity);
                    }

                    public DataConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * dataConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">delete</span>(dataConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        helpDeleteInternally(dataConfigToLabelTypeMapping,
                new InternalDeleteCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        return delegateInsertList(dataConfigToLabelTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        return delegateUpdateList(dataConfigToLabelTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        return delegateDeleteList(dataConfigToLabelTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setPK...(value);</span>
     * dataConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setVersionNo(value);</span>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(dataConfigToLabelTypeMapping, cb);
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DataConfigToLabelTypeMappingCB cb) {
        return delegateQueryUpdate(dataConfigToLabelTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(dataConfigToLabelTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataConfigToLabelTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * dataConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *         public void specify(DataConfigToLabelTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(dataConfigToLabelTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            final UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(dataConfigToLabelTypeMapping,
                new InternalUpdateCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setPK...(value);</span>
     * dataConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataConfigToLabelTypeMapping.setVersionNo(value);</span>
     * DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;DataConfigToLabelTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void specify(DataConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(dataConfigToLabelTypeMapping, cb, option);
     * </pre>
     * @param dataConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DataConfigToLabelTypeMappingCB cb,
            final UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(dataConfigToLabelTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<DataConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> void delegateSelectCursor(
            DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends DataConfigToLabelTypeMapping> List<ENTITY> delegateSelectList(
            DataConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToLabelTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(DataConfigToLabelTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(DataConfigToLabelTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<DataConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<DataConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(DataConfigToLabelTypeMapping e,
            DataConfigToLabelTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(DataConfigToLabelTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(DataConfigToLabelTypeMapping e,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(DataConfigToLabelTypeMapping e,
            DataConfigToLabelTypeMappingCB cb,
            UpdateOption<DataConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected DataConfigToLabelTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                DataConfigToLabelTypeMapping.class);
    }

    protected DataConfigToLabelTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                DataConfigToLabelTypeMappingCB.class);
    }
}
