/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.cq.BrowserTypeCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.ciq.FileConfigToBrowserTypeMappingCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of FILE_CONFIG_TO_BROWSER_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public class BsFileConfigToBrowserTypeMappingCQ extends
        AbstractBsFileConfigToBrowserTypeMappingCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected FileConfigToBrowserTypeMappingCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsFileConfigToBrowserTypeMappingCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from FILE_CONFIG_TO_BROWSER_TYPE_MAPPING) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public FileConfigToBrowserTypeMappingCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new FileConfigToBrowserTypeMappingCIQ(
                    getChildQuery(), getSqlClause(), getAliasName(),
                    getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join FILE_CONFIG_TO_BROWSER_TYPE_MAPPING on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public FileConfigToBrowserTypeMappingCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        FileConfigToBrowserTypeMappingCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    public BsFileConfigToBrowserTypeMappingCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsFileConfigToBrowserTypeMappingCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _fileConfigId;

    public ConditionValue getFileConfigId() {
        if (_fileConfigId == null) {
            _fileConfigId = nCV();
        }
        return _fileConfigId;
    }

    protected ConditionValue getCValueFileConfigId() {
        return getFileConfigId();
    }

    protected Map<String, FileCrawlingConfigCQ> _fileConfigId_InScopeSubQuery_FileCrawlingConfigMap;

    public Map<String, FileCrawlingConfigCQ> getFileConfigId_InScopeSubQuery_FileCrawlingConfig() {
        return _fileConfigId_InScopeSubQuery_FileCrawlingConfigMap;
    }

    public String keepFileConfigId_InScopeSubQuery_FileCrawlingConfig(
            FileCrawlingConfigCQ subQuery) {
        if (_fileConfigId_InScopeSubQuery_FileCrawlingConfigMap == null) {
            _fileConfigId_InScopeSubQuery_FileCrawlingConfigMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_fileConfigId_InScopeSubQuery_FileCrawlingConfigMap.size() + 1);
        _fileConfigId_InScopeSubQuery_FileCrawlingConfigMap.put(key, subQuery);
        return "fileConfigId_InScopeSubQuery_FileCrawlingConfig." + key;
    }

    public BsFileConfigToBrowserTypeMappingCQ addOrderBy_FileConfigId_Asc() {
        regOBA("FILE_CONFIG_ID");
        return this;
    }

    public BsFileConfigToBrowserTypeMappingCQ addOrderBy_FileConfigId_Desc() {
        regOBD("FILE_CONFIG_ID");
        return this;
    }

    protected ConditionValue _browserTypeId;

    public ConditionValue getBrowserTypeId() {
        if (_browserTypeId == null) {
            _browserTypeId = nCV();
        }
        return _browserTypeId;
    }

    protected ConditionValue getCValueBrowserTypeId() {
        return getBrowserTypeId();
    }

    protected Map<String, BrowserTypeCQ> _browserTypeId_InScopeSubQuery_BrowserTypeMap;

    public Map<String, BrowserTypeCQ> getBrowserTypeId_InScopeSubQuery_BrowserType() {
        return _browserTypeId_InScopeSubQuery_BrowserTypeMap;
    }

    public String keepBrowserTypeId_InScopeSubQuery_BrowserType(
            BrowserTypeCQ subQuery) {
        if (_browserTypeId_InScopeSubQuery_BrowserTypeMap == null) {
            _browserTypeId_InScopeSubQuery_BrowserTypeMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_browserTypeId_InScopeSubQuery_BrowserTypeMap.size() + 1);
        _browserTypeId_InScopeSubQuery_BrowserTypeMap.put(key, subQuery);
        return "browserTypeId_InScopeSubQuery_BrowserType." + key;
    }

    public BsFileConfigToBrowserTypeMappingCQ addOrderBy_BrowserTypeId_Asc() {
        regOBA("BROWSER_TYPE_ID");
        return this;
    }

    public BsFileConfigToBrowserTypeMappingCQ addOrderBy_BrowserTypeId_Desc() {
        regOBD("BROWSER_TYPE_ID");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsFileConfigToBrowserTypeMappingCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsFileConfigToBrowserTypeMappingCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        FileConfigToBrowserTypeMappingCQ baseQuery = (FileConfigToBrowserTypeMappingCQ) baseQueryAsSuper;
        FileConfigToBrowserTypeMappingCQ unionQuery = (FileConfigToBrowserTypeMappingCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryBrowserType()) {
            unionQuery.queryBrowserType()
                    .reflectRelationOnUnionQuery(baseQuery.queryBrowserType(),
                            unionQuery.queryBrowserType());
        }
        if (baseQuery.hasConditionQueryFileCrawlingConfig()) {
            unionQuery.queryFileCrawlingConfig().reflectRelationOnUnionQuery(
                    baseQuery.queryFileCrawlingConfig(),
                    unionQuery.queryFileCrawlingConfig());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    public BrowserTypeCQ queryBrowserType() {
        return getConditionQueryBrowserType();
    }

    protected BrowserTypeCQ _conditionQueryBrowserType;

    public BrowserTypeCQ getConditionQueryBrowserType() {
        if (_conditionQueryBrowserType == null) {
            _conditionQueryBrowserType = xcreateQueryBrowserType();
            xsetupOuterJoinBrowserType();
        }
        return _conditionQueryBrowserType;
    }

    protected BrowserTypeCQ xcreateQueryBrowserType() {
        String nrp = resolveNextRelationPath(
                "FILE_CONFIG_TO_BROWSER_TYPE_MAPPING", "browserType");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        BrowserTypeCQ cq = new BrowserTypeCQ(this, getSqlClause(), jan,
                getNextNestLevel());
        cq.xsetForeignPropertyName("browserType");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinBrowserType() {
        BrowserTypeCQ cq = getConditionQueryBrowserType();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put(getRealColumnName("BROWSER_TYPE_ID"), cq
                .getRealColumnName("ID"));
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryBrowserType() {
        return _conditionQueryBrowserType != null;
    }

    public FileCrawlingConfigCQ queryFileCrawlingConfig() {
        return getConditionQueryFileCrawlingConfig();
    }

    protected FileCrawlingConfigCQ _conditionQueryFileCrawlingConfig;

    public FileCrawlingConfigCQ getConditionQueryFileCrawlingConfig() {
        if (_conditionQueryFileCrawlingConfig == null) {
            _conditionQueryFileCrawlingConfig = xcreateQueryFileCrawlingConfig();
            xsetupOuterJoinFileCrawlingConfig();
        }
        return _conditionQueryFileCrawlingConfig;
    }

    protected FileCrawlingConfigCQ xcreateQueryFileCrawlingConfig() {
        String nrp = resolveNextRelationPath(
                "FILE_CONFIG_TO_BROWSER_TYPE_MAPPING", "fileCrawlingConfig");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        FileCrawlingConfigCQ cq = new FileCrawlingConfigCQ(this,
                getSqlClause(), jan, getNextNestLevel());
        cq.xsetForeignPropertyName("fileCrawlingConfig");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinFileCrawlingConfig() {
        FileCrawlingConfigCQ cq = getConditionQueryFileCrawlingConfig();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put(getRealColumnName("FILE_CONFIG_ID"), cq
                .getRealColumnName("ID"));
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryFileCrawlingConfig() {
        return _conditionQueryFileCrawlingConfig != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, FileConfigToBrowserTypeMappingCQ> _scalarSubQueryMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, FileConfigToBrowserTypeMappingCQ> _myselfInScopeSubQueryMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return FileConfigToBrowserTypeMappingCB.class.getName();
    }

    String xCQ() {
        return FileConfigToBrowserTypeMappingCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
