/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sf.fess.Constants;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.service.LabelTypeService;

import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.InitMethod;

public class LabelTypeHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    private volatile List<Map<String, String>> labelTypeItems = new ArrayList<Map<String, String>>();

    protected LabelTypeService getLabelTypeService() {
        return SingletonS2Container.getComponent(LabelTypeService.class);
    }

    @InitMethod
    public void init() {
        List<Map<String, String>> itemList = new ArrayList<Map<String, String>>();
        List<LabelType> labelTypeList = getLabelTypeService()
                .getLabelTypeList();
        for (LabelType labelType : labelTypeList) {
            Map<String, String> map = new HashMap<String, String>(2);
            map.put(Constants.ITEM_LABEL, labelType.getName());
            map.put(Constants.ITEM_VALUE, labelType.getValue());
            itemList.add(map);
        }
        labelTypeItems = itemList;
    }

    public void refresh(List<LabelType> labelTypeList) {
        List<Map<String, String>> itemList = new ArrayList<Map<String, String>>();
        for (LabelType labelType : labelTypeList) {
            Map<String, String> map = new HashMap<String, String>(2);
            map.put(Constants.ITEM_LABEL, labelType.getName());
            map.put(Constants.ITEM_VALUE, labelType.getValue());
            itemList.add(map);
        }
        labelTypeItems = itemList;
    }

    public List<Map<String, String>> getLabelTypeItems() {
        if (labelTypeItems == null) {
            init();
        }
        return labelTypeItems;
    }

}
