//
// Copyright 2009-2010 Fess Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

@interface SearchResultModel : TTURLRequestModel {
	NSString* _searchQuery;
	NSMutableArray* _results;
    NSUInteger _offset;
    NSUInteger _pageSize;
    NSUInteger _recordCount;
    NSUInteger _maxPageNum;
}

@property (nonatomic, copy) NSString* searchQuery;
@property (nonatomic, readonly) NSArray* results;
@property (nonatomic, readonly) NSUInteger offset;
@property (nonatomic, readonly) NSUInteger pageSize;
@property (nonatomic, readonly) NSUInteger recordCount;
@property (nonatomic, readonly) NSUInteger maxPageNum;

- (id)initWithSearchQuery:(NSString*)searchQuery;

@end
