/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: DebugErrorHandler.java 142 2009-11-13 05:53:41Z akira-yokoi $
 * $Revision: 142 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.StringUtil;

/**
 * fobOpG[nhONX ParseExceptionۂɃG[ƂȂZ}[NĎsfBNgzɃG[t@Co͂B
 * 
 * @since 1.0
 */
public class DebugErrorHandler implements ParseErrorHandler {
    /** Rg̃JTCY */
    private static final short ERROR_COMENT_COL_SIZE = 7;

    /** Rg̍sTCY */
    private static final short ERROR_COMENT_ROW_SIZE = 2;

    /** O */
    private static Log log = LogFactory.getLog( DebugErrorHandler.class);

    /** G[t@C̏ݐ */
    private String errorFilePath = null;

    public void notifyException( Workbook workbook, Sheet sheet, ParseException exception) {
        // G[Z̃}[N
        if ( exception != null) {
            markupErrorCell( workbook, exception);
        }

        // G[ubN̏
        writeErrorBook( workbook);
    }

    /**
     * G[Z}[LO
     * 
     * @param workbook [NubN
     * @param errorCell
     * @param exception
     */
    protected void markupErrorCell( Workbook workbook, ParseException exception) {
        Cell errorCell = exception.getCell();
        if ( errorCell == null) {
            return;
        }
        // G[Z̑OiFԂɂ
        workbook.setActiveSheet( workbook.getSheetIndex( errorCell.getSheet()));
        errorCell.setAsActiveCell();

        if ( workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xssfWorkbook = ( XSSFWorkbook) workbook;

            CellStyle errorCellStyle = xssfWorkbook.createCellStyle();
            errorCellStyle.setFillForegroundColor( HSSFColor.ROSE.index);
            errorCellStyle.setFillPattern( XSSFCellStyle.SOLID_FOREGROUND);
            errorCell.setCellStyle( errorCellStyle);

            // TODO:RgǁA܂ȂBBB
            // XSSFComment xssfComment = ((XSSFSheet)sheet).createComment();
            // xssfComment.setRow( errorCell.getRowIndex());
            // xssfComment.setColumn( (short)errorCell.getColumnIndex());
            // XSSFRichTextString string = new XSSFRichTextString( ex.getMessage());
            // xssfComment.setString( ex.getMessage());
        } else {
            HSSFWorkbook hssfWorkbook = ( HSSFWorkbook) workbook;
            int sheetNum = hssfWorkbook.getNumberOfSheets();
            for ( int cnt = 0; cnt < sheetNum; cnt++) {
                hssfWorkbook.getSheetAt( cnt).setSelected( false);
            }

            // G[ZɔwiFݒ
            CellStyle errorCellStyle = hssfWorkbook.createCellStyle();
            errorCellStyle.setFillForegroundColor( HSSFColor.ROSE.index);
            errorCellStyle.setFillPattern( HSSFCellStyle.SOLID_FOREGROUND);
            errorCell.setCellStyle( errorCellStyle);

            // G[ZɃRgǉ
            short commentColFrom = ( short) (errorCell.getColumnIndex() + 1);
            short commentColTo = ( short) (errorCell.getColumnIndex() + ERROR_COMENT_COL_SIZE);
            int commentRowFrom = errorCell.getRowIndex();
            int commentRowTo = errorCell.getRowIndex() + ERROR_COMENT_ROW_SIZE;

            HSSFSheet hssfSheet = ( HSSFSheet) errorCell.getSheet();
            HSSFPatriarch patr = hssfSheet.createDrawingPatriarch();
            hssfSheet.setSelected( true);
            HSSFComment comment = patr.createComment( new HSSFClientAnchor( 0, 0, 0, 0, commentColFrom, commentRowFrom, commentColTo, commentRowTo));
            comment.setVisible( true);
            comment.setString( new HSSFRichTextString( createCommentMessage( exception)));
            errorCell.setCellComment( comment);
        }
    }

    /**
     * Rgɏo͂郁bZ[W̐
     * 
     * @param exception O
     * @return Rgɏo͂郁bZ[W
     */
    protected String createCommentMessage( ParseException exception) {
        StringBuilder commentMessageBuf = new StringBuilder();
        
        if( exception.getMessage() != null){
            commentMessageBuf.append( exception.getMessage());            
        }
        if ( exception.getCause() != null) {
            commentMessageBuf.append( "\n");
            commentMessageBuf.append( StringUtil.getPrintStackTrace( exception.getCause()));
        }
        return commentMessageBuf.toString();
    }

    /**
     * G[ubÑt@CJgfBNgɏ
     * 
     * @param workbook
     */
    protected void writeErrorBook( Workbook workbook) {
        String resultFileName = errorFilePath;
        if ( resultFileName == null) {
            resultFileName = "./" + System.currentTimeMillis();
            if ( workbook instanceof XSSFWorkbook) {
                resultFileName += BookController.XSSF_SUFFIX;
            } else {
                resultFileName += BookController.HSSF_SUFFIX;
            }
        }

        try {
            PoiUtil.writeBook( workbook, resultFileName);
            System.out.println( "\n" + resultFileName + "ɃG[t@C𐶐܂");
        } catch ( Exception e) {
            log.warn( "G[t@C̐Ɏs܂", e);
        }
    }

    /**
     * G[t@C̏ݐpX̎擾
     * 
     * @return G[t@C̏ݐpX
     */
    public String getErrorFilePath() {
        return errorFilePath;
    }

    /**
     * G[t@C̏ݐpX̐ݒ
     * 
     * @param errorFilePath G[t@C̏ݐpX
     */
    public void setErrorFilePath( String errorFilePath) {
        this.errorFilePath = errorFilePath;
    }
}
