/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: TextFileExporter.java 63 2009-05-21 07:36:51Z akira-yokoi $
 * $Revision: 63 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.exporter.sheet;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ExportException;

/**
 * ͌(f[^)t@Cɏo͂鏈NX
 * 
 * fBNgwƃt@CpXw肪\
 * w肵ꍇ͑o̐ݒŃt@Co͂B
 * 
 * fBNg(exportDir)w肵ꍇEEEwfBNg"V[g.txt"Ńt@Co
 * t@CpXw(filePath)w肵ꍇEEEw肳ꂽpXŃt@Co
 * 
 * @since 1.0
 *
 */
public class TextFileExporter implements SheetExporter {
	
    /**
     * K[
     */
    private static Log log = LogFactory.getLog( TextFileExporter.class);

    /**
     * o͐̃fBNgpX
     */
    private String directoryPath = null;

    /**
     * o͐̃x[XƂȂt@CpX
     */
    private String baseFilePath = null;

    /**
     * 
     */
    public void setup() {
    }

    /**
     * o͏̎s
     * 
     * @param sheet V[g
     * @param sheetdata V[gf[^
     * @throws ExportException t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇA
     * t@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ
     */
    public void export( Sheet sheet, SheetData sheetdata) throws ExportException {

        if ( directoryPath == null && baseFilePath == null) {
            if ( log.isErrorEnabled()) {
                log.error( "o͐w肵ĂB");
            }
        } else {
            // directoryPathw肳Ăꍇ
            if ( directoryPath != null) {
                File file = new File( directoryPath, sheetdata.getSheetName() + ".txt");
                writeTextFile( file, sheetdata.toString());

            }

            // baseFilePathw肳Ăꍇ
            if ( baseFilePath != null) {
                int parentPathIndex = baseFilePath.lastIndexOf( File.separatorChar);
                String parentPath = "";
                String headFileName = "";

                try {
                    parentPath = baseFilePath.substring( 0, parentPathIndex);
                    headFileName = baseFilePath.substring( parentPathIndex + 1);

                } catch ( IndexOutOfBoundsException iobe) {
                    // parentPathIndex-1̏ꍇ(baseFilePathɃZp[gꍇ)
                    throw new ExportException( iobe);
                }

                File file = new File( parentPath, headFileName + sheetdata.getSheetName() + ".txt");
                writeTextFile( file, sheetdata.toString());

            }
        }
    }

    /**
     * I
     */
    public void tearDown() {
    }

    /**
     * o͐̃fBNgpXԂ܂B
     * 
     * @return o͐̃fBNgpX
     */
    public String getDirectoryPath() {
        return directoryPath;
    }

    /**
     * o͐̃fBNgpXݒ肵܂B
     * 
     * @param directoryPath o͐̃fBNgpX
     */
    public void setDirectoryPath( String directoryPath) {
        this.directoryPath = directoryPath;
    }

    /**
     * o͐̃x[XƂȂt@CpXԂ܂B
     * 
     * @return o͐̃x[XƂȂt@CpX
     */
    public String getBaseFilePath() {
        return baseFilePath;
    }

    /**
     * o͐̃x[XƂȂt@CpXݒ肵܂B
     * 
     * @param baseFilePath o͐̃x[XƂȂt@CpX
     */
    public void setBaseFilePath( String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }

    /**
     * eLXgt@C݃\bh
     * 
     * @param file ރt@CIuWFNg
     * @param fileData t@Cɏ܂e
     * @throws ExportException t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇA
     * t@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ
     */
    private void writeTextFile( File file, String fileData) throws ExportException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter( new FileWriter( file));
            writer.write( fileData);

        } catch ( IOException ioe) {
            if ( log.isErrorEnabled()) {
                log.error( "t@CނƂł܂B");
            }
            throw new ExportException( ioe);

        } finally {
            try {
                if ( writer != null) {
                    writer.close();
                }
            } catch ( IOException ioe) {
                throw new ExportException( ioe);
            }
        }
    }
}
