/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.WString;
import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.ISVNKernel32Library;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

class SVNWin32Util {
    SVNWin32Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWritable(File file) {
        if (file == null) {
            return false;
        }
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            try {
                int rc = library.SetFileAttributesW(new WString(file.getAbsolutePath()), new NativeLong(128L));
                return rc != 0;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setHidden(File file) {
        if (file == null) {
            return false;
        }
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            try {
                int rc = library.SetFileAttributesW(new WString(file.getAbsolutePath()), new NativeLong(2L));
                return rc != 0;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File src, File dst) {
        if (src == null || dst == null) {
            return false;
        }
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return false;
        }
        if (dst.isFile() && !dst.canWrite()) {
            SVNFileUtil.setReadonly(dst, false);
            SVNFileUtil.setReadonly(src, true);
        }
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            try {
                int rc = library.MoveFileExW(new WString(src.getAbsoluteFile().getAbsolutePath()), new WString(dst.getAbsoluteFile().getAbsolutePath()), new NativeLong(3L));
                return rc != 0;
            }
            catch (Throwable th) {
            }
        }
        return false;
    }
}

