/*
 * RomRaider Open-Source Tuning, Logging and Reflashing
 * Copyright (C) 2006-2008 RomRaider.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package com.romraider.ramtune.test.io;

import com.romraider.io.connection.ConnectionProperties;

public final class RamTuneTestAppConnectionProperties implements ConnectionProperties {
    private final ConnectionProperties defaultConnectionProperties;
    private final int sendTimeout;

    public RamTuneTestAppConnectionProperties(ConnectionProperties defaultConnectionProperties, int sendTimeout) {
        this.defaultConnectionProperties = defaultConnectionProperties;
        this.sendTimeout = sendTimeout;
    }

    public int getBaudRate() {
        return defaultConnectionProperties.getBaudRate();
    }

    public int getDataBits() {
        return defaultConnectionProperties.getDataBits();
    }

    public int getStopBits() {
        return defaultConnectionProperties.getStopBits();
    }

    public int getParity() {
        return defaultConnectionProperties.getParity();
    }

    public int getConnectTimeout() {
        return defaultConnectionProperties.getConnectTimeout();
    }

    public int getSendTimeout() {
        return sendTimeout > 0 ? sendTimeout : defaultConnectionProperties.getSendTimeout();
    }
}
