﻿// In the original BSD license, both occurrences of the phrase "COPYRIGHT HOLDERS AND CONTRIBUTORS"
// in the disclaimer read "REGENTS AND CONTRIBUTORS".
//
// Here is the license template:
//
// Copyright (c) 2010, Masanori Usami
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are permitted provided
// that the following conditions are met:
//
//  * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
//    in the documentation and/or other materials provided with the distribution.
//  * Neither the name of the <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
// BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
// OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.using System;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace EAAddinDSM
{
    /// <summary>
    /// MVCパターンのModel相当の抽象クラス
    /// </summary>
    abstract class Model
    {
        /// <summary>
        /// モデルの更新の通知対象のオブジェクトを格納する
        /// </summary>
        protected ArrayList observer_;

        /// <summary>
        /// コンストラクタ
        /// モデルの更新の通知対象のオブジェクトを格納するobserver_を初期化
        /// </summary>
        public Model()
        {
            observer_ = new ArrayList();
        }

        /// <summary>
        /// モデル更新の通知対象のオブジェクトを追加する
        /// すでに存在するオブジェクトの場合は追加失敗とする
        /// </summary>
        /// <param name="observer">追加対象オブジェクト</param>
        /// <returns>true:追加成功 false:追加失敗</returns>
        public bool attach(Observer observer)
        {
            if (observer_.Contains(observer))
            {
                return false;
            }
            else
            {
                try
                {
                    observer_.Add(observer);
                    return true;
                }
                catch (System.NotSupportedException e)
                {
                    throw e;
                }
            }
        }

        /// <summary>
        /// 指定されたモデル更新の通知対象のオブジェクトを削除する
        /// 存在しないオブジェクトが指定された場合は削除失敗とする
        /// </summary>
        /// <param name="observer">削除対象オブジェクト</param>
        /// <returns>true:削除成功 false:削除失敗</returns>
        public bool detach(Observer observer)
        {
            if (observer_.Contains(observer))
            {
                try
                {
                    observer_.Remove(observer);
                    return true;
                }
                catch (System.NotSupportedException e)
                {
                    throw e;
                }
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// モデル更新時に登録されたオブジェクトに更新を通知するための処理
        /// 呼び出しは、モデルを更新した処理の中から行う必要がある
        /// </summary>
        public void update()
        {
            foreach (Observer observer in observer_)
            {
                observer.update();
            }
        }
    }
}
