/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * ウェブメールのフィルタのResultDataです。 <BR>
 * 
 */
public class WebMailGroupSendUserResultData implements ALData {

  /** グループ送信ID */
  private ALNumberField groupSend_id;

  /** グループ送信名 */
  private ALStringField groupSend_name;

  /** 所属者ユーザーID */
  private ALNumberField user_id;

  /** 所属者名 */
  private ALStringField user_name;

  /**
   * 
   * 
   */
  public void initField() {
    groupSend_id = new ALNumberField();
    groupSend_name = new ALStringField();
    user_id = new ALNumberField();
    user_name = new ALStringField();
  }

  /**
   * グループ送信IDを返します。<BR>
   * 
   * @return
   */
  public ALNumberField getGroupSendID() {
    return groupSend_id;
  }

  /**
   * グループ送信名を返します。<BR>
   * 
   * @return
   */
  public ALStringField getGroupSendName() {
    return groupSend_name;
  }

  /**
   * 所属者ユーザーIDを返します。<BR>
   * 
   * @return
   */
  public ALNumberField getUserId() {
    return user_id;
  }

  /**
   * ユーザー名を返します。<BR>
   * 
   * @return
   */
  public ALStringField getUserName() {
    return user_name;
  }

  /**
   * グループ送信IDをセットします。<BR>
   * 
   * @param groupSend_id
   */
  public void setGroupSendId(ALNumberField groupSend_id) {
    this.groupSend_id = groupSend_id;
  }

  /**
   * グループ送信名をセットします。<BR>
   * 
   * @param groupSend_name
   */
  public void setGroupSendName(ALStringField groupSend_name) {
    this.groupSend_name = groupSend_name;
  }

  /**
   * 所属者ユーザーIDをセットします。<BR>
   * 
   * @param user_id
   */
  public void setUserId(ALNumberField user_id) {
    this.user_id = user_id;
  }

  /**
   * 所属者名をセットします。<BR>
   * 
   * @param user_name
   */
  public void setUserName(ALStringField user_name) {
    this.user_name = user_name;
  }

}
