/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailSelectData;
import com.aimluck.eip.webmail.WebMailSendSelectData;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールの一覧を処理するクラスです。 <br />
 * 
 */
public class WebMailListScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailListScreen.class.getName());

  /**
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    String mode = rundata.getParameters().getString("mode");

    // add start
    String tab = rundata.getParameters().getString("tab");
    if (null == tab || tab.equals("")) {
      tab = ALEipUtils.getTemp(rundata, context, "tab");
    }

    // add end

    try {

      if ("recieve".equals(mode)) {
        // change start
        // メニューからメール受信をクリックしてきた場合
        // WebMailUtils.receiveMailsThread(rundata, context);

        // メール受信定時起動からの呼出時は全アカウントに対して受信処理を行う
        WebMailUtils.receiveAllAccountMailsThread(rundata, context);
      }

      // if ("stoprecieving".equals(mode)) {
      // // メニューからメール受信をクリックしてきた場合
      // WebMailUtils.stopReceiveMailThread(Integer.parseInt(accountId));
      // }

      VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

      // 受信フォルダもしくは送信フォルダに保存されているメールの一覧を表示する．

      // change start
      // 受信の場合
      if (WebMailUtils.TAB_RECEIVE.equals(tab)) {
        WebMailSelectData listData = new WebMailSelectData();
        listData.initField();
        listData.loadMailAccountList(rundata, context);
        // add start
        // フォルダ容量情報設定
        listData.loadMailBoxVolume(rundata, context);
        // add end
        listData.setRowsNum(Integer.parseInt(portlet
          .getPortletConfig()
          .getInitParameter("p1b-rows")));
        listData.setStrLength(Integer.parseInt(portlet
          .getPortletConfig()
          .getInitParameter("p4a-strlen")));
        listData.doViewList(this, rundata, context);

        // 送信の場合
      } else {
        WebMailSendSelectData listData = new WebMailSendSelectData();
        listData.initField();
        listData.loadMailAccountList(rundata, context);
        // add start
        // フォルダ容量情報設定
        listData.loadMailBoxVolume(rundata, context);
        // add end
        listData.setRowsNum(Integer.parseInt(portlet
          .getPortletConfig()
          .getInitParameter("p1b-rows")));
        listData.setStrLength(Integer.parseInt(portlet
          .getPortletConfig()
          .getInitParameter("p4a-strlen")));
        listData.doViewList(this, rundata, context);
      }
      // change end

      setTemplate(rundata, context, "portlets/html/ja/ajax-webmail-list.vm");
    } catch (Exception ex) {
      logger.error("[WebMailListScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
