/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTMailSend;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailConsts;
import com.aimluck.eip.webmail.util.FileZip;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * 受信トレイ、送信トレイより退避ファイルダウンロードを行うクラスです
 */
public class WebMailDownLoadScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebMailDownLoadScreen.class.getName());

  /** ログインユーザーのID * */
  private int user_id;

  /** ログインユーザー名 * */
  private String login_user_name;

  /** ファイル拡張子名 */
  private final String ZIP_EXTENSION = ".zip";

  /** ログ出力用メッセージ(メール一括退避用ファイル作成) * */
  private final String ERROR_MESSAGE_CREATE_SAVE_FOLDER = "メール一括退避用ファイル作成に失敗しました";

  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    // ログインユーザーID取得
    user_id = ALEipUtils.getUserId(rundata);
    // ログインユーザー名取得
    login_user_name = ALEipUtils.getUserFullName(user_id);

    try {
      // チェックボックスでチェックされたメールIDをListに展開
      List<String> values = new ArrayList<String>();
      Object[] objs = rundata.getParameters().getKeys();
      int length = objs.length;
      for (int i = 0; i < length; i++) {
        if (objs[i].toString().startsWith("check")) {
          String str = rundata.getParameters().getString(objs[i].toString());
          values.add(str);
        }
      }

      // ダウンロード先ディレクトリ取得
      final String tmpFilePath = JetspeedResources.getString("aipo.ziptmp.directory", "");
      // change start 運用フェーズ課題・障害台帳No.145
      // String downloadDirectoryPath =
      // tmpFilePath + File.separator + "download" + File.separator;
      String downloadDirectoryPath = tmpFilePath + File.separator + "download" + File.separator + user_id + "fromlist" + File.separator;
      // change end

      // ダウンロードファイル作成
      String fileName = makeDownloadFile(rundata, context, values, downloadDirectoryPath);
      // ダウンロードダイアログ出力
      WebMailUtils.downloadFile(rundata, downloadDirectoryPath, fileName, true);

    } catch (Exception ex) {
      logger.error("退避ファイルダウンロードに失敗しました" + login_user_name, ex);
      return;
    }
  }

  /**
   * @param rundata
   * @param context
   * @param values
   * @return
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   * @throws UnsupportedEncodingException
   * @throws NumberFormatException
   */
  private String makeDownloadFile(RunData rundata, Context context, List<String> values, String downloadDirectoryPath) throws ALPageNotFoundException,
      ALDBErrorException, NumberFormatException, UnsupportedEncodingException {

    // 最終的に圧縮するzipファイル
    File zip_file = null;

    int accountId = -1;
    user_id = ALEipUtils.getUserId(rundata);
    String login_user_name = ALEipUtils.getUserFullName(user_id);
    EipMMailAccount account = null;
    // アカウントIDが指定されていなければ終了
    accountId = Integer.parseInt(ALEipUtils.getTemp(rundata, context, WebMailUtils.ACCOUNT_ID));

    account = ALMailUtils.getMailAccount(user_id, accountId);

    if (accountId < 0 || account == null) {
      return null;
    }

    // フォルダ情報取得
    String folder_id = ALEipUtils.getTemp(rundata, context, WebMailUtils.FOLDER_ID);
    EipTMailFolder folder = WebMailUtils.getEipTMailFolder(account, folder_id);
    if (folder == null) {
      return null;
    }
    // フォルダ種別
    String folder_kind = folder.getFolderKind();

    // 退避ファイル出力先ディレクトリ生成
    File download_dir = WebMailUtils.makeFileDownloadDirectory(accountId, Integer.parseInt(folder_id), downloadDirectoryPath);

    try {
      // 退避対象となるメールのレコードを取得する。（フォルダ種別で参照テーブルが異なる）
      if (WebMailConsts.RECEIVE_FOLDER.equals(folder_kind)) {
        // フォルダ種別 = R:受信トレイの場合
        SelectQuery<EipTMail> query = Database.query(EipTMail.class);
        Expression exp = ExpressionFactory.inDbExp(EipTMail.MAIL_ID_PK_COLUMN, values);

        List<EipTMail> mailList = query.setQualifier(exp).fetchList();
        if (null != mailList || mailList.size() > 0) {
          // <結果レコード>の件数分対象となるメールファイルを、ダウンロード用にコピーする。
          for (int i = 0; i < mailList.size(); i++) {
            WebMailUtils.copyMailFileToDownloadDirectory(user_id, accountId, folder_kind, mailList.get(i).getFilePath(), mailList.get(i).getSubject(), mailList
              .get(i)
              .getEventDate(), download_dir, i);
          }
        }
      } else if (WebMailConsts.SEND_FOLDER.equals(folder_kind)) {
        // フォルダ種別 = S:送信トレイの場合
        SelectQuery<AvzTMailSend> query = Database.query(AvzTMailSend.class);
        Expression exp = ExpressionFactory.inDbExp(AvzTMailSend.MAIL_ID_PK_COLUMN, values);

        List<AvzTMailSend> mailList = query.setQualifier(exp).fetchList();
        if (null != mailList || mailList.size() > 0) {
          // <結果レコード>の件数分対象となるメールファイルを、ダウンロード用にコピーする。
          for (int i = 0; i < mailList.size(); i++) {
            WebMailUtils.copyMailFileToDownloadDirectory(user_id, accountId, folder_kind, mailList.get(i).getFilePath(), mailList.get(i).getSubject(), mailList
              .get(i)
              .getEventDate(), download_dir, i);
          }
        }
      }

      // 出力したディレクトリをZIP形式で圧縮する。
      zip_file = FileZip.zip(download_dir + ZIP_EXTENSION, download_dir.getAbsolutePath());

    } catch (IOException ioex) {
      Database.rollback();
      logger.error(ERROR_MESSAGE_CREATE_SAVE_FOLDER + login_user_name, ioex);
    } catch (Exception ex) {
      Database.rollback();
      logger.error(ERROR_MESSAGE_CREATE_SAVE_FOLDER + login_user_name, ex);
    }
    return zip_file.getName();
  }

}
